"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculatePriority = calculatePriority;
var _types = require("../commands_registry/types");
var _types2 = require("./types");
var _category_rules = require("./utils/category_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CATEGORY_PRIORITIES = {
  [_types2.SuggestionCategory.CUSTOM_ACTION]: 0,
  [_types2.SuggestionCategory.LANGUAGE_KEYWORD]: 50,
  // BY, WHERE, ON, WITH

  [_types2.SuggestionCategory.TIME_PARAM]: 100,
  [_types2.SuggestionCategory.PIPE]: 200,
  [_types2.SuggestionCategory.COMMA]: 201,
  [_types2.SuggestionCategory.VALUE]: 202,
  [_types2.SuggestionCategory.CONSTANT_VALUE]: 250,
  // Prompt text, query text constants

  [_types2.SuggestionCategory.USER_DEFINED_COLUMN]: 300,
  [_types2.SuggestionCategory.RECOMMENDED_FIELD]: 310,
  [_types2.SuggestionCategory.ECS_FIELD]: 330,
  [_types2.SuggestionCategory.TIME_FIELD]: 350,
  [_types2.SuggestionCategory.FIELD]: 350,
  [_types2.SuggestionCategory.OPERATOR]: 400,
  [_types2.SuggestionCategory.FUNCTION_TIME_SERIES_AGG]: 500,
  [_types2.SuggestionCategory.FUNCTION_AGG]: 500,
  [_types2.SuggestionCategory.FUNCTION_SCALAR]: 500,
  [_types2.SuggestionCategory.RECOMMENDED_QUERY_WITH_PRIORITY]: 590,
  // Search query (higher priority)
  [_types2.SuggestionCategory.RECOMMENDED_QUERY]: 600,
  [_types2.SuggestionCategory.UNKNOWN]: 900
};

// Context-specific priority adjustments (negative = boost up, positive = push down)
const CONTEXT_BOOSTS = {
  [_types.Location.STATS]: {
    [_types2.SuggestionCategory.LANGUAGE_KEYWORD]: -40,
    // From 50 to 10 (after CUSTOM_ACTION)
    [_types2.SuggestionCategory.FUNCTION_AGG]: -100,
    // From 500 to 400
    [_types2.SuggestionCategory.FUNCTION_TIME_SERIES_AGG]: -151 // From 500 to 349 (before fields at 350)
  },
  [_types.Location.STATS_BY]: {
    [_types2.SuggestionCategory.USER_DEFINED_COLUMN]: -300 // From 300 to 0
  }
};
function calculatePriority(item, context) {
  var _CATEGORY_PRIORITIES$, _CONTEXT_BOOSTS$locat, _CONTEXT_BOOSTS$locat2;
  const category = (0, _category_rules.detectCategory)(item);

  // Step 1: Get base priority from category
  const basePriority = (_CATEGORY_PRIORITIES$ = CATEGORY_PRIORITIES[category]) !== null && _CATEGORY_PRIORITIES$ !== void 0 ? _CATEGORY_PRIORITIES$ : CATEGORY_PRIORITIES[_types2.SuggestionCategory.UNKNOWN];

  // Step 2: Apply context-specific boosts
  const locationKey = context.location ? `${context.command.toLowerCase()}_${context.location.toLowerCase()}` : context.command.toLowerCase();
  const contextBoost = (_CONTEXT_BOOSTS$locat = (_CONTEXT_BOOSTS$locat2 = CONTEXT_BOOSTS[locationKey]) === null || _CONTEXT_BOOSTS$locat2 === void 0 ? void 0 : _CONTEXT_BOOSTS$locat2[category]) !== null && _CONTEXT_BOOSTS$locat !== void 0 ? _CONTEXT_BOOSTS$locat : 0;

  // Final priority = base + context boost
  return basePriority + contextBoost;
}