"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSettingsCompletionItems = getSettingsCompletionItems;
var _ = require("../../..");
var _types = require("../../sorting/types");
var _settings = require("../generated/settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getSettingsCompletionItems(isServerless) {
  return _settings.settings
  // Filter out serverless-only settings if not in serverless mode, if not flavour is provided don't return serverlessOnly settings.
  .filter(setting => isServerless ? setting.serverlessOnly : !setting.serverlessOnly)
  // Filter out settings we don't want as suggestions
  .filter(setting => !setting.ignoreAsSuggestion).map(setting => (0, _.withAutoSuggest)({
    label: setting.name,
    text: `${setting.name} = `,
    kind: 'Reference',
    detail: setting.description,
    sortText: '1',
    category: _types.SuggestionCategory.VALUE
  }));
}