"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.grokSupportedDataTypes = exports.fieldTypes = exports.dataTypes = exports.FunctionDefinitionTypes = exports.ESQL_STRING_TYPES = exports.ESQL_NUMERIC_DECIMAL_TYPES = exports.ESQL_NUMBER_TYPES = exports.ESQL_COMMON_NUMERIC_TYPES = exports.ESQL_ARITHMETIC_TYPES = void 0;
exports.isArrayType = isArrayType;
exports.isFieldType = void 0;
exports.isNumericType = isNumericType;
exports.isReturnType = exports.isParameterType = void 0;
exports.supportsArithmeticOperations = supportsArithmeticOperations;
exports.userDefinedTypes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * All supported field types in ES|QL. This is all the types
 * that can come back in the table from a query.
 */
const fieldTypes = exports.fieldTypes = ['boolean', 'date', 'double', 'ip', 'keyword', 'integer', 'long', 'text', 'unsigned_long', 'version', 'cartesian_point', 'cartesian_shape', 'geo_point', 'geo_shape', 'counter_integer', 'counter_long', 'counter_double', 'unsupported', 'date_nanos', 'function_named_parameters', 'aggregate_metric_double', 'dense_vector', 'histogram', 'exponential_histogram', 'tdigest'];
/**
 * All supported field types in ES|QL. This is all the types
 * that can come back in the table from a query.
 */
const userDefinedTypes = exports.userDefinedTypes = ['boolean', 'date', 'double', 'ip', 'keyword', 'integer', 'long', 'text', 'unsigned_long', 'version', 'cartesian_point', 'cartesian_shape', 'geo_point', 'geo_shape', 'counter_integer', 'counter_long', 'counter_double', 'unsupported', 'date_nanos', 'function_named_parameters', 'null', 'time_duration', 'date_period', 'param',
// Defines a named param such as ?value or ??field
'histogram', 'exponential_histogram', 'tdigest'];

/**
 * This is the list of all data types that are supported in ES|QL.
 *
 * Not all of these can be used as field types. Some can only be literals,
 * others may be the value of a field, but cannot be used in the index mapping.
 *
 * This is a partial list. The full list is here and we may need to expand this type as
 * the capabilities of the client-side engines grow.
 * https://github.com/elastic/elasticsearch/blob/main/x-pack/plugin/esql-core/src/main/java/org/elasticsearch/xpack/esql/core/type/DataType.java
 */
const dataTypes = exports.dataTypes = [...fieldTypes, 'null', 'time_duration', 'date_period', 'param',
// Defines a named param such as ?value or ??field,
'geohash', 'geohex', 'geotile'];
/**
 * This is a set of array types. These aren't official ES|QL types, but they are
 * currently used in the function definitions in a couple of specific scenarios.
 *
 * The fate of these is uncertain. They may be removed in the future.
 */
const arrayTypes = ['double[]', 'unsigned_long[]', 'long[]', 'integer[]', 'counter_integer[]', 'counter_long[]', 'counter_double[]', 'keyword[]', 'text[]', 'boolean[]', 'any[]', 'date[]', 'date_period[]', 'ip[]', 'cartesian_point[]', 'cartesian_shape[]', 'geo_point[]', 'geo_shape[]', 'version[]', 'date_nanos[]'];
function isArrayType(type) {
  return arrayTypes.includes(type);
}
let FunctionDefinitionTypes = exports.FunctionDefinitionTypes = /*#__PURE__*/function (FunctionDefinitionTypes) {
  FunctionDefinitionTypes["AGG"] = "agg";
  FunctionDefinitionTypes["SCALAR"] = "scalar";
  FunctionDefinitionTypes["OPERATOR"] = "operator";
  FunctionDefinitionTypes["GROUPING"] = "grouping";
  FunctionDefinitionTypes["TIME_SERIES_AGG"] = "time_series_agg";
  return FunctionDefinitionTypes;
}({});
const grokSupportedDataTypes = exports.grokSupportedDataTypes = ['int', 'long', 'double', 'float', 'boolean'];

/**
 * This is the type of a parameter in a function definition.
 */

const isFieldType = str => str !== undefined && fieldTypes.includes(str);
exports.isFieldType = isFieldType;
const isParameterType = str => str !== undefined && str !== 'unsupported' && (str === 'any' || dataTypes.includes(str) || arrayTypes.includes(str));
exports.isParameterType = isParameterType;
const isReturnType = str => str !== 'unsupported' && (str === 'unknown' || str === 'any' || dataTypes.includes(str));

/**
 * This is the return type of a function definition.
 *
 * TODO: remove `any`
 */
exports.isReturnType = isReturnType;
/**
 * Handles numeric types in ES|QL.
 */
const ESQL_COMMON_NUMERIC_TYPES = exports.ESQL_COMMON_NUMERIC_TYPES = ['double', 'long', 'integer'];
const ESQL_NUMERIC_DECIMAL_TYPES = exports.ESQL_NUMERIC_DECIMAL_TYPES = ['double', 'unsigned_long', 'long', 'counter_long', 'counter_double'];
const ESQL_NUMBER_TYPES = exports.ESQL_NUMBER_TYPES = ['integer', 'counter_integer', ...ESQL_NUMERIC_DECIMAL_TYPES];
const ESQL_ARITHMETIC_TYPES = exports.ESQL_ARITHMETIC_TYPES = [...ESQL_NUMBER_TYPES, 'aggregate_metric_double'];
function isNumericType(type) {
  return typeof type === 'string' && (type === 'decimal' || ESQL_NUMBER_TYPES.includes(type));
}
function supportsArithmeticOperations(type) {
  return ESQL_ARITHMETIC_TYPES.includes(type);
}
const ESQL_STRING_TYPES = exports.ESQL_STRING_TYPES = ['keyword', 'text'];