"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COMPLETIONS_BY_SETTING_NAME = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getProjectRoutingCommonCompletionItems = () => {
  return [{
    label: '_alias:_origin',
    text: '_alias:_origin',
    kind: 'Value',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.set.projectRouting.currentProjectDoc', {
      defaultMessage: 'Search only the current project'
    }),
    sortText: '1'
  }, {
    label: '_alias: *',
    text: '_alias: *',
    kind: 'Value',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.set.projectRouting.allProjectsDoc', {
      defaultMessage: 'Search all projects'
    }),
    sortText: '1'
  }];
};
const COMPLETIONS_BY_SETTING_NAME = exports.COMPLETIONS_BY_SETTING_NAME = {
  project_routing: getProjectRoutingCommonCompletionItems()
};