"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fuseCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fuseCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  validate: _validate.validate
};
const fuseCommand = exports.fuseCommand = {
  name: 'fuse',
  methods: fuseCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.fuseDoc', {
      defaultMessage: 'Combines multiple result sets with different scoring functions into a single result set.'
    }),
    declaration: `FUSE <fuse_method> SCORE BY <score_column> GROUP BY <group_column> KEY BY <key_columns> WITH <options>`,
    examples: [`…| FUSE`, `…| FUSE linear`, `…| FUSE linear WITH { "weights": { "fork1": 0.7, "fork2": 0.3 }, "normalizer": "minmax" }`],
    hidden: true,
    preview: true,
    name: 'fuse'
  }
};