"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _utils = require("../../../shared/ml_inference/utils");
var _ml_inference_logic = require("./ml_inference_logic");
var _zero_shot_inference_configuration = require("./zero_shot_inference_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/inference_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InferenceConfiguration = () => {
  const {
    addInferencePipelineModal: {
      configuration
    },
    selectedModel
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  if (!selectedModel || configuration.existingPipeline) return null;
  const modelType = (0, _utils.getMLType)(selectedModel.types);
  switch (modelType) {
    case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION:
      return /*#__PURE__*/_react.default.createElement(InferenceConfigurationWrapper, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_zero_shot_inference_configuration.ZeroShotClassificationInferenceConfiguration, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 11
        }
      }));
    default:
      return null;
  }
};
exports.InferenceConfiguration = InferenceConfiguration;
const InferenceConfigurationWrapper = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.inference.title', {
    defaultMessage: 'Inference Configuration'
  }))), children);
};