"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchUIEmbedSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_integrate/analytics_collection_integrate_searchui.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const searchUIEmbedSteps = setSelectedTab => [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchuiEmbed.stepOne.title', {
    defaultMessage: 'Embed Behavioral Analytics'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepOne.description",
    defaultMessage: "Follow the instructions to embed Behavioral Analytics into your site via {embedLink} or {clientLink}.",
    values: {
      embedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-telemetry-id": 'entSearch-analytics-integrate-javascriptEmbed-tab',
        onClick: () => {
          setSelectedTab('javascriptEmbed');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepOne.embedLink', {
        defaultMessage: 'Javascript Embed'
      })),
      clientLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-telemetry-id": 'entSearch-analytics-integrate-javascriptClientEmbed-tab',
        onClick: () => {
          setSelectedTab('javascriptClientEmbed');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepOne.clientLink', {
        defaultMessage: 'Javascript Client'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 13
    }
  }))))
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchuiEmbed.stepTwo.title', {
    defaultMessage: 'Install Search UI Behavioral Analytics Plugin'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepTwo.description', {
    defaultMessage: 'Download the Behavioral Analytics plugin from NPM.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, 'npm install @elastic/search-ui-analytics-plugin'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepTwo.importDescription', {
    defaultMessage: 'Then import the Behavioral Analytics plugin into your app.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, 'import AnalyticsPlugin from "@elastic/search-ui-analytics-plugin";'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepTwo.setupDescription', {
    defaultMessage: 'Finally, add the plugin to your Search UI configuration. Depending on how you have embedded Behavioral Analytics, you may need to pass in the client. The example below shows how to pass in the client when using the Javascript client.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, `
import { getTracker } from "@elastic/behavioral-analytics-javascript-tracker";

const searchUIConfig = {
...
plugins: [
  AnalyticsPlugin({
    client: getTracker()
  })
],
...
}`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepTwo.moreInfoDescription",
    defaultMessage: "See the {link} for more information on initializing the tracker and firing events.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://docs.elastic.co/search-ui/api/core/plugins/analytics-plugin",
        target: "_blank",
        "data-telemetry-id": 'entSearch-analytics-integrate-javascriptEmbed-analyticsPluginDocumentationLink',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.searchui.stepTwo.analyticsPluginDoc', {
        defaultMessage: 'Analytics Plugin Documentation'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }))))
}];
exports.searchUIEmbedSteps = searchUIEmbedSteps;