"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elasticAssistantQueryClient = exports.ReactQueryClientProvider = exports.ElasticAssistantQueryClient = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/context/query_client_context/elastic_assistant_query_client_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A security solution specific react-query query client that sets defaults
 */
class ElasticAssistantQueryClient extends _reactQuery.QueryClient {
  constructor(options = {}) {
    var _options$defaultOptio, _options$defaultOptio2, _options$defaultOptio3;
    const optionsWithDefaults = {
      ...options,
      defaultOptions: {
        ...((_options$defaultOptio = options.defaultOptions) !== null && _options$defaultOptio !== void 0 ? _options$defaultOptio : {}),
        queries: {
          refetchIntervalInBackground: false,
          refetchOnWindowFocus: false,
          refetchOnMount: true,
          keepPreviousData: true,
          ...((_options$defaultOptio2 = options === null || options === void 0 ? void 0 : (_options$defaultOptio3 = options.defaultOptions) === null || _options$defaultOptio3 === void 0 ? void 0 : _options$defaultOptio3.queries) !== null && _options$defaultOptio2 !== void 0 ? _options$defaultOptio2 : {})
        }
      }
    };
    super(optionsWithDefaults);
  }
}

/**
 * The default Security Solution Query Client. Can be imported and used from outside of React hooks
 * and still benefit from ReactQuery features (like caching, etc)
 *
 * @see https://tanstack.com/query/v4/docs/reference/QueryClient
 */
exports.ElasticAssistantQueryClient = ElasticAssistantQueryClient;
const elasticAssistantQueryClient = exports.elasticAssistantQueryClient = new ElasticAssistantQueryClient();
const ReactQueryClientProvider = exports.ReactQueryClientProvider = /*#__PURE__*/(0, _react.memo)(({
  queryClient,
  children
}) => {
  const client = (0, _react.useMemo)(() => {
    return queryClient || elasticAssistantQueryClient;
  }, [queryClient]);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: client,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 12
    }
  }, children);
});
ReactQueryClientProvider.displayName = 'ReactQueryClientProvider';