"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/typed_interrupt/typed_interrupts/input_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InputText = ({
  interruptValue: interrupt,
  resumeGraph,
  resumeValue: initialResumeValue,
  isLastInConversation
}) => {
  var _initialResumeValue$v, _interrupt$placeholde;
  const [input, setInput] = _react.default.useState((_initialResumeValue$v = initialResumeValue === null || initialResumeValue === void 0 ? void 0 : initialResumeValue.value) !== null && _initialResumeValue$v !== void 0 ? _initialResumeValue$v : '');
  const [resumeValue, setResumeValue] = _react.default.useState(initialResumeValue);
  const onSubmit = () => {
    const newResumeValue = {
      type: 'INPUT_TEXT',
      value: input
    };
    setResumeValue(newResumeValue);
    resumeGraph(interrupt.threadId, newResumeValue);
  };
  const onChange = e => {
    setInput(e.target.value);
  };
  const getOutcome = () => {
    var _resumeValue$value;
    switch (true) {
      case isLastInConversation === false && resumeValue === undefined:
      case interrupt.expired:
        return 'Expired';
      case resumeValue === undefined:
        return undefined;
      case resumeValue !== undefined:
        return (_resumeValue$value = resumeValue === null || resumeValue === void 0 ? void 0 : resumeValue.value) !== null && _resumeValue$value !== void 0 ? _resumeValue$value : 'Actioned';
    }
  };
  const outcome = getOutcome();
  const disabled = resumeValue !== undefined || interrupt.expired === true || !isLastInConversation;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "input-text-interrupt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, interrupt.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    placeholder: (_interrupt$placeholde = interrupt.placeholder) !== null && _interrupt$placeholde !== void 0 ? _interrupt$placeholde : 'Enter text to continue...',
    value: input,
    onChange: e => onChange(e),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    size: "s",
    onClick: onSubmit,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.elasticAssistantPlugin.typed_interrupt.input_text.submit.label",
    defaultMessage: "Submit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  })), outcome && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 21
    }
  }, outcome)));
};
exports.InputText = InputText;