"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryFindSortField = exports.AttackDiscoveryFindResponse = exports.AttackDiscoveryFindRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../../../../common_attributes.gen");
var _attack_discovery_api_alert = require("../../../attack_discovery_api_alert.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Attack discoveries API endpoint
 *   version: 2023-10-31
 */

/**
 * Allowed field names to sort Attack discovery results by. Clients should only pass one of the listed values.
 */

const AttackDiscoveryFindSortField = exports.AttackDiscoveryFindSortField = _zod.z.literal('@timestamp');
const AttackDiscoveryFindRequestQuery = exports.AttackDiscoveryFindRequestQuery = _zod.z.object({
  /**
   * Filter results to Attack discoveries that include any of the provided alert IDs
   */
  alert_ids: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Filter results to Attack discoveries created by any of the provided human readable connector names. Note that values must match the human readable `connector_name` property of an Attack discovery, e.g. "GPT-5 Chat", which are distinct from `connector_id` values used to generate Attack discoveries.
   */
  connector_names: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Enables a markdown syntax used to render pivot fields, for example `{{ user.name james }}`. When disabled, the same example would be rendered as `james`. This is primarily used for Attack discovery views within Kibana. Defaults to `false`.
   */
  enable_field_rendering: _zodHelpers.BooleanFromString.optional().default(false),
  /**
   * End of the time range for the search. Accepts absolute timestamps (ISO 8601) or relative date math (e.g. "now", "now-24h").
   */
  end: _zod.z.string().optional(),
  /**
   * Filter results to the Attack discoveries with the specified IDs
   */
  ids: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * If `true`, the response will include `unique_alert_ids` and `unique_alert_ids_count` aggregated across the matched Attack discoveries
   */
  include_unique_alert_ids: _zodHelpers.BooleanFromString.optional(),
  /**
   * Page number to return (used for pagination). Defaults to 1.
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * Number of Attack discoveries to return per page (used for pagination). Defaults to 10.
   */
  per_page: _zod.z.coerce.number().int().min(1).optional().default(10),
  /**
   * Free-text search query applied to relevant text fields of Attack discoveries (title, description, tags, etc.)
   */
  search: _zod.z.string().optional(),
  /**
   * Whether to filter by shared visibility. If omitted, both shared and privately visible Attack discoveries are returned. Use `true` to return only shared discoveries, `false` to return only those visible to the current user.
   */
  shared: _zodHelpers.BooleanFromString.optional(),
  /**
   * Field used to sort results. See `AttackDiscoveryFindSortField` for allowed values.
   */
  sort_field: AttackDiscoveryFindSortField.optional().default('@timestamp'),
  /**
   * Sort order direction `asc` for ascending or `desc` for descending. Defaults to `desc`.
   */
  sort_order: _common_attributes.SortOrder.optional().default('desc'),
  /**
   * Start of the time range for the search. Accepts absolute timestamps (ISO 8601) or relative date math (e.g. "now-7d").
   */
  start: _zod.z.string().optional(),
  /**
   * Filter by alert workflow status. Provide one or more of the allowed workflow states.
   */
  status: (0, _zodHelpers.ArrayFromString)(_zod.z.enum(['acknowledged', 'closed', 'open'])).optional(),
  /**
   * When true, return the created Attack discoveries with text replacements applied to the detailsMarkdown, entitySummaryMarkdown, summaryMarkdown, and title fields. Defaults to `true`.
   */
  with_replacements: _zodHelpers.BooleanFromString.optional().default(true)
});
const AttackDiscoveryFindResponse = exports.AttackDiscoveryFindResponse = _zod.z.object({
  /**
   * List of human readable connector names that are present in the matched Attack discoveries. Useful for building client filters or summaries.
   */
  connector_names: _zod.z.array(_zod.z.string()),
  /**
   * Array of matched Attack discovery objects. Each item follows the `AttackDiscoveryApiAlert` schema.
   */
  data: _zod.z.array(_attack_discovery_api_alert.AttackDiscoveryApiAlert),
  /**
   * Current page number of the paginated result set.
   */
  page: _zod.z.number().int(),
  /**
   * Number of items requested per page.
   */
  per_page: _zod.z.number().int(),
  /**
   * Total number of Attack discoveries matching the query (across all pages).
   */
  total: _zod.z.number().int(),
  /**
   * List of unique alert IDs aggregated from the matched Attack discoveries. Only present if `include_unique_alert_ids=true` in the request.
   */
  unique_alert_ids: _zod.z.array(_zod.z.string()).optional(),
  /**
   * Number of unique alert IDs across all matched Attack discoveries. Only present if `include_unique_alert_ids=true` in the request.
   */
  unique_alert_ids_count: _zod.z.number().int()
});