"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerProfileProviders = void 0;
var _classic_nav_root_profile = require("./common/classic_nav_root_profile");
var _deprecation_logs_data_source_profile = require("./common/deprecation_logs_data_source_profile");
var _patterns_data_source_profile = require("./common/patterns_data_source_profile");
var _register_enabled_profile_providers = require("./register_enabled_profile_providers");
var _profile = require("./example/example_data_source_profile/profile");
var _example_document_profile = require("./example/example_document_profile");
var _example_root_profile = require("./example/example_root_profile");
var _logs_data_source_profile = require("./observability/logs_data_source_profile");
var _observability_profile_providers = require("./observability/observability_profile_providers");
var _profile2 = require("./observability/observability_root_profile/profile");
var _create_profile_providers = require("./observability/traces_data_source_profile/create_profile_providers");
var _security_document_profile = require("./security/security_document_profile");
var _security_root_profile = require("./security/security_root_profile");
var _metrics_data_source_profile = require("./common/metrics_data_source_profile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Register profile providers for root, data source, and document contexts to the profile profile services
 * @param options Register profile provider options
 */
const registerProfileProviders = ({
  rootProfileService,
  dataSourceProfileService,
  documentProfileService,
  enabledExperimentalProfileIds,
  sharedServices,
  services
}) => {
  const providerServices = {
    ...sharedServices,
    ...services
  };
  const rootProfileProviders = createRootProfileProviders(providerServices);
  const dataSourceProfileProviders = createDataSourceProfileProviders(providerServices);
  const documentProfileProviders = createDocumentProfileProviders(providerServices);
  (0, _register_enabled_profile_providers.registerEnabledProfileProviders)({
    profileService: rootProfileService,
    providers: rootProfileProviders,
    enabledExperimentalProfileIds,
    services
  });
  (0, _register_enabled_profile_providers.registerEnabledProfileProviders)({
    profileService: dataSourceProfileService,
    providers: dataSourceProfileProviders,
    enabledExperimentalProfileIds,
    services
  });
  (0, _register_enabled_profile_providers.registerEnabledProfileProviders)({
    profileService: documentProfileService,
    providers: documentProfileProviders,
    enabledExperimentalProfileIds,
    services
  });
};

/**
 * Creates the available root profile providers
 * @param providerServices The profile provider services
 * @returns An array of available root profile providers
 */
exports.registerProfileProviders = registerProfileProviders;
const createRootProfileProviders = providerServices => [(0, _example_root_profile.createExampleRootProfileProvider)(), (0, _example_root_profile.createExampleSolutionViewRootProfileProvider)(), (0, _classic_nav_root_profile.createClassicNavRootProfileProvider)(providerServices), (0, _security_root_profile.createSecurityRootProfileProvider)(providerServices), (0, _profile2.createObservabilityRootProfileProvider)(providerServices)];

/**
 * Creates the available data source profile providers
 * @param providerServices The profile provider services
 * @returns An array of available data source profile providers
 */
const createDataSourceProfileProviders = providerServices => [(0, _profile.createExampleDataSourceProfileProvider)(), (0, _patterns_data_source_profile.createPatternsDataSourceProfileProvider)(providerServices), (0, _deprecation_logs_data_source_profile.createDeprecationLogsDataSourceProfileProvider)(), ...(0, _logs_data_source_profile.createObservabilityLogsDataSourceProfileProviders)(providerServices), ...(0, _create_profile_providers.createObservabilityTracesDataSourceProfileProviders)(providerServices), ...(0, _metrics_data_source_profile.createMetricsDataSourceProfileProviders)(providerServices)];

/**
 * Creates the available document profile providers
 * @param providerServices The profile provider services
 * @returns An array of available document profile providers
 */
const createDocumentProfileProviders = providerServices => [(0, _example_document_profile.createExampleDocumentProfileProvider)(), (0, _security_document_profile.createSecurityDocumentProfileProvider)(providerServices), ...(0, _observability_profile_providers.createObservabilityDocumentProfileProviders)(providerServices)];