"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromTabStateToSavedObjectTab = exports.fromSavedSearchToSavedObjectTab = exports.fromSavedObjectTabToTabState = exports.fromSavedObjectTabToSavedSearch = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _data_sources = require("../../../../../common/data_sources");
var _get_allowed_sample_size = require("../../../../utils/get_allowed_sample_size");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromSavedObjectTabToTabState = ({
  tab,
  existingTab,
  initialAppState
}) => {
  var _existingTab$appState;
  const appState = initialAppState !== null && initialAppState !== void 0 ? initialAppState : {
    columns: tab.columns,
    filters: tab.serializedSearchSource.filter,
    grid: tab.grid,
    hideChart: tab.hideChart,
    dataSource: (0, _data_sources.createDataSource)({
      query: tab.serializedSearchSource.query,
      dataView: tab.serializedSearchSource.index
    }),
    query: tab.serializedSearchSource.query,
    sort: tab.sort,
    viewMode: tab.viewMode,
    hideAggregatedPreview: tab.hideAggregatedPreview,
    rowHeight: tab.rowHeight,
    headerRowHeight: tab.headerRowHeight,
    rowsPerPage: tab.rowsPerPage,
    sampleSize: tab.sampleSize,
    breakdownField: tab.breakdownField,
    density: tab.density
  };
  return {
    ..._constants.DEFAULT_TAB_STATE,
    ...existingTab,
    id: tab.id,
    label: tab.label,
    initialInternalState: {
      serializedSearchSource: tab.serializedSearchSource,
      visContext: tab.visContext,
      controlGroupJson: tab.controlGroupJson
    },
    appState,
    previousAppState: (_existingTab$appState = existingTab === null || existingTab === void 0 ? void 0 : existingTab.appState) !== null && _existingTab$appState !== void 0 ? _existingTab$appState : appState,
    globalState: {
      timeRange: tab.timeRestore ? tab.timeRange : existingTab === null || existingTab === void 0 ? void 0 : existingTab.globalState.timeRange,
      refreshInterval: tab.timeRange ? tab.refreshInterval : existingTab === null || existingTab === void 0 ? void 0 : existingTab.globalState.refreshInterval
    }
  };
};
exports.fromSavedObjectTabToTabState = fromSavedObjectTabToTabState;
const fromSavedObjectTabToSavedSearch = async ({
  tab,
  discoverSession,
  services
}) => ({
  id: discoverSession.id,
  title: discoverSession.title,
  description: discoverSession.description,
  tags: discoverSession.tags,
  managed: discoverSession.managed,
  references: discoverSession.references,
  sharingSavedObjectProps: discoverSession.sharingSavedObjectProps,
  sort: tab.sort,
  columns: tab.columns,
  grid: tab.grid,
  hideChart: tab.hideChart,
  isTextBasedQuery: tab.isTextBasedQuery,
  usesAdHocDataView: tab.usesAdHocDataView,
  searchSource: await services.data.search.searchSource.create(tab.serializedSearchSource),
  viewMode: tab.viewMode,
  hideAggregatedPreview: tab.hideAggregatedPreview,
  rowHeight: tab.rowHeight,
  headerRowHeight: tab.headerRowHeight,
  timeRestore: tab.timeRestore,
  timeRange: tab.timeRange,
  refreshInterval: tab.refreshInterval,
  rowsPerPage: tab.rowsPerPage,
  sampleSize: tab.sampleSize,
  breakdownField: tab.breakdownField,
  density: tab.density,
  visContext: tab.visContext,
  controlGroupJson: tab.controlGroupJson
});
exports.fromSavedObjectTabToSavedSearch = fromSavedObjectTabToSavedSearch;
const fromTabStateToSavedObjectTab = ({
  tab,
  timeRestore,
  services
}) => {
  var _tab$appState$sort, _tab$appState$columns, _tab$appState$grid, _tab$appState$hideCha, _tab$initialInternalS, _tab$initialInternalS2, _tab$initialInternalS3, _tab$initialInternalS4, _tab$initialInternalS5, _tab$initialInternalS6;
  const allowedSampleSize = (0, _get_allowed_sample_size.getAllowedSampleSize)(tab.appState.sampleSize, services.uiSettings);
  return {
    id: tab.id,
    label: tab.label,
    sort: (_tab$appState$sort = tab.appState.sort) !== null && _tab$appState$sort !== void 0 ? _tab$appState$sort : [],
    columns: (_tab$appState$columns = tab.appState.columns) !== null && _tab$appState$columns !== void 0 ? _tab$appState$columns : [],
    grid: (_tab$appState$grid = tab.appState.grid) !== null && _tab$appState$grid !== void 0 ? _tab$appState$grid : {},
    hideChart: (_tab$appState$hideCha = tab.appState.hideChart) !== null && _tab$appState$hideCha !== void 0 ? _tab$appState$hideCha : false,
    isTextBasedQuery: (0, _esQuery.isOfAggregateQueryType)(tab.appState.query),
    usesAdHocDataView: (0, _lodash.isObject)((_tab$initialInternalS = tab.initialInternalState) === null || _tab$initialInternalS === void 0 ? void 0 : (_tab$initialInternalS2 = _tab$initialInternalS.serializedSearchSource) === null || _tab$initialInternalS2 === void 0 ? void 0 : _tab$initialInternalS2.index),
    serializedSearchSource: (_tab$initialInternalS3 = (_tab$initialInternalS4 = tab.initialInternalState) === null || _tab$initialInternalS4 === void 0 ? void 0 : _tab$initialInternalS4.serializedSearchSource) !== null && _tab$initialInternalS3 !== void 0 ? _tab$initialInternalS3 : {},
    viewMode: tab.appState.viewMode,
    hideAggregatedPreview: tab.appState.hideAggregatedPreview,
    rowHeight: tab.appState.rowHeight,
    headerRowHeight: tab.appState.headerRowHeight,
    timeRestore,
    timeRange: timeRestore ? tab.globalState.timeRange : undefined,
    refreshInterval: timeRestore ? tab.globalState.refreshInterval : undefined,
    rowsPerPage: tab.appState.rowsPerPage,
    sampleSize: tab.appState.sampleSize && tab.appState.sampleSize === allowedSampleSize ? tab.appState.sampleSize : undefined,
    breakdownField: tab.appState.breakdownField,
    density: tab.appState.density,
    visContext: (_tab$initialInternalS5 = tab.initialInternalState) === null || _tab$initialInternalS5 === void 0 ? void 0 : _tab$initialInternalS5.visContext,
    controlGroupJson: (_tab$initialInternalS6 = tab.initialInternalState) === null || _tab$initialInternalS6 === void 0 ? void 0 : _tab$initialInternalS6.controlGroupJson
  };
};
exports.fromTabStateToSavedObjectTab = fromTabStateToSavedObjectTab;
const fromSavedSearchToSavedObjectTab = ({
  tab,
  savedSearch,
  services
}) => {
  var _savedSearch$sort, _savedSearch$columns, _savedSearch$grid, _savedSearch$hideChar, _savedSearch$isTextBa, _savedSearch$searchSo;
  const allowedSampleSize = (0, _get_allowed_sample_size.getAllowedSampleSize)(savedSearch.sampleSize, services.uiSettings);
  return {
    id: tab.id,
    label: tab.label,
    sort: (_savedSearch$sort = savedSearch.sort) !== null && _savedSearch$sort !== void 0 ? _savedSearch$sort : [],
    columns: (_savedSearch$columns = savedSearch.columns) !== null && _savedSearch$columns !== void 0 ? _savedSearch$columns : [],
    grid: (_savedSearch$grid = savedSearch.grid) !== null && _savedSearch$grid !== void 0 ? _savedSearch$grid : {},
    hideChart: (_savedSearch$hideChar = savedSearch.hideChart) !== null && _savedSearch$hideChar !== void 0 ? _savedSearch$hideChar : false,
    isTextBasedQuery: (_savedSearch$isTextBa = savedSearch.isTextBasedQuery) !== null && _savedSearch$isTextBa !== void 0 ? _savedSearch$isTextBa : false,
    usesAdHocDataView: savedSearch.usesAdHocDataView,
    serializedSearchSource: (_savedSearch$searchSo = savedSearch.searchSource.getSerializedFields()) !== null && _savedSearch$searchSo !== void 0 ? _savedSearch$searchSo : {},
    viewMode: savedSearch.viewMode,
    hideAggregatedPreview: savedSearch.hideAggregatedPreview,
    rowHeight: savedSearch.rowHeight,
    headerRowHeight: savedSearch.headerRowHeight,
    timeRestore: savedSearch.timeRestore,
    timeRange: savedSearch.timeRange,
    refreshInterval: savedSearch.refreshInterval,
    rowsPerPage: savedSearch.rowsPerPage,
    sampleSize: savedSearch.sampleSize && savedSearch.sampleSize === allowedSampleSize ? savedSearch.sampleSize : undefined,
    breakdownField: savedSearch.breakdownField,
    density: savedSearch.density,
    visContext: savedSearch.visContext,
    controlGroupJson: savedSearch.controlGroupJson
  };
};
exports.fromSavedSearchToSavedObjectTab = fromSavedSearchToSavedObjectTab;