"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverNoResults = DiscoverNoResults;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _searchResponseWarnings = require("@kbn/search-response-warnings");
var _no_results_suggestions = require("./no_results_suggestions");
var _use_data_state = require("../../hooks/use_data_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/no_results/no_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function DiscoverNoResults({
  stateContainer,
  isTimeBased,
  query,
  filters,
  dataView,
  onDisableFilters
}) {
  const {
    documents$
  } = stateContainer.dataState.data$;
  const interceptedWarnings = (0, _use_data_state.useDataState)(documents$).interceptedWarnings;
  if (interceptedWarnings !== null && interceptedWarnings !== void 0 && interceptedWarnings.length) {
    return /*#__PURE__*/_react.default.createElement(_searchResponseWarnings.SearchResponseWarningsEmptyPrompt, {
      warnings: interceptedWarnings,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_no_results_suggestions.NoResultsSuggestions, {
    isTimeBased: isTimeBased,
    query: query,
    filters: filters,
    dataView: dataView,
    onDisableFilters: onDisableFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })));
}