"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContextAppFetch = useContextAppFetch;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _public = require("@kbn/data-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _anchor = require("../services/anchor");
var _context = require("../services/context");
var _context_query_state = require("../services/context_query_state");
var _use_discover_services = require("../../../hooks/use_discover_services");
var _scoped_services_provider = require("../../../components/scoped_services_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/context/hooks/use_context_app_fetch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createError = (statusKey, reason, error) => ({
  [statusKey]: {
    value: _context_query_state.LoadingStatus.FAILED,
    error,
    reason
  }
});
function useContextAppFetch({
  anchorId,
  dataView,
  appState
}) {
  const {
    scopedProfilesManager
  } = (0, _scoped_services_provider.useScopedServices)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    uiSettings: config,
    data,
    toastNotifications,
    filterManager
  } = services;
  const searchSource = (0, _react.useMemo)(() => {
    return data.search.searchSource.createEmpty();
  }, [data.search.searchSource]);
  const tieBreakerFieldName = (0, _react.useMemo)(() => (0, _discoverUtils.getTieBreakerFieldName)(dataView, config), [config, dataView]);
  const [fetchedState, setFetchedState] = (0, _react.useState)((0, _context_query_state.getInitialContextQueryState)());
  const setState = (0, _react.useCallback)(values => {
    setFetchedState(prevState => ({
      ...prevState,
      ...values
    }));
  }, []);
  const fetchAnchorRow = (0, _react.useCallback)(async () => {
    const errorTitle = _i18n.i18n.translate('discover.context.unableToLoadAnchorDocumentDescription', {
      defaultMessage: 'Unable to load the anchor document'
    });
    if (!tieBreakerFieldName) {
      setState(createError('anchorStatus', _context_query_state.FailureReason.INVALID_TIEBREAKER));
      toastNotifications.addDanger({
        title: errorTitle,
        text: _i18n.i18n.translate('discover.context.invalidTieBreakerFiledSetting', {
          defaultMessage: 'Invalid tie breaker field setting'
        })
      });
      return;
    }
    try {
      setState({
        anchorStatus: {
          value: _context_query_state.LoadingStatus.LOADING
        }
      });
      const sort = (0, _discoverUtils.getEsQuerySort)({
        sortDir: _public.SortDirection.desc,
        timeFieldName: dataView.timeFieldName,
        tieBreakerFieldName,
        isTimeNanosBased: dataView.isTimeNanosBased()
      });
      const result = await (0, _anchor.fetchAnchor)(anchorId, dataView, searchSource, sort, services, scopedProfilesManager);
      setState({
        anchor: result.anchorRow,
        anchorInterceptedWarnings: result.interceptedWarnings,
        anchorStatus: {
          value: _context_query_state.LoadingStatus.LOADED
        }
      });
      return result.anchorRow;
    } catch (error) {
      setState(createError('anchorStatus', _context_query_state.FailureReason.UNKNOWN, error));
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
          readOnly: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 103,
            columnNumber: 28
          }
        }, error.message), services)
      });
    }
  }, [tieBreakerFieldName, setState, toastNotifications, dataView, anchorId, searchSource, services, scopedProfilesManager]);
  const fetchSurroundingRows = (0, _react.useCallback)(async (type, fetchedAnchor) => {
    const filters = filterManager.getFilters();
    const count = type === _context.SurrDocType.PREDECESSORS ? appState.predecessorCount : appState.successorCount;
    const anchor = fetchedAnchor || fetchedState.anchor;
    const statusKey = `${type}Status`;
    const warningsKey = `${type}InterceptedWarnings`;
    const errorTitle = _i18n.i18n.translate('discover.context.unableToLoadDocumentDescription', {
      defaultMessage: 'Unable to load documents'
    });
    try {
      setState({
        [statusKey]: {
          value: _context_query_state.LoadingStatus.LOADING
        }
      });
      const result = anchor.id ? await (0, _context.fetchSurroundingDocs)(type, dataView, anchor, tieBreakerFieldName, _public.SortDirection.desc, count, filters, data, services, scopedProfilesManager) : {
        rows: [],
        interceptedWarnings: undefined
      };
      setState({
        [type]: result.rows,
        [warningsKey]: result.interceptedWarnings,
        [statusKey]: {
          value: _context_query_state.LoadingStatus.LOADED
        }
      });
    } catch (error) {
      setState(createError(statusKey, _context_query_state.FailureReason.UNKNOWN, error));
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
          readOnly: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 30
          }
        }, error.message), services)
      });
    }
  }, [filterManager, appState.predecessorCount, appState.successorCount, fetchedState.anchor, setState, dataView, tieBreakerFieldName, data, services, scopedProfilesManager, toastNotifications]);
  const fetchContextRows = (0, _react.useCallback)(anchor => Promise.allSettled([fetchSurroundingRows(_context.SurrDocType.PREDECESSORS, anchor), fetchSurroundingRows(_context.SurrDocType.SUCCESSORS, anchor)]), [fetchSurroundingRows]);
  const fetchAllRows = (0, _react.useCallback)(async () => {
    const anchor = await fetchAnchorRow();
    if (!anchor) return;
    return await fetchContextRows(anchor);
  }, [fetchAnchorRow, fetchContextRows]);
  const resetFetchedState = (0, _react.useCallback)(() => {
    setFetchedState((0, _context_query_state.getInitialContextQueryState)());
  }, []);
  return {
    fetchedState,
    fetchAllRows,
    fetchContextRows,
    fetchSurroundingRows,
    resetFetchedState
  };
}