"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescriptionFields = void 0;
exports.getRuleType = getRuleType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _validate = require("./rule_form/validate");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDescriptionFields = ({
  rule,
  prebuildFields
}) => {
  if (!rule || !prebuildFields) return [];
  return [prebuildFields.indexPattern([rule.params.searchConfiguration.index])];
};
exports.getDescriptionFields = getDescriptionFields;
function getRuleType() {
  return {
    id: _ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID,
    description: _i18n.i18n.translate('xpack.datasetQuality.alert.degradedDocs.descriptionText', {
      defaultMessage: 'Alert when degraded docs percentage exceeds a threshold.'
    }),
    iconClass: 'bell',
    documentationUrl: null,
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./rule_form')))),
    validate: _validate.validate,
    requiresAppContext: false,
    getDescriptionFields
  };
}