"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldEditorOpener = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _field_editor_loader = require("./components/field_editor_loader");
var _constants = require("./constants");
var _shared_imports = require("./shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/open_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Options for opening the field editor
 * @public
 */

const getFieldEditorOpener = ({
  core,
  dataViews,
  fieldFormats,
  fieldFormatEditors,
  search,
  usageCollection,
  apiService
}) => async options => {
  const {
    uiSettings,
    overlays,
    docLinks,
    notifications,
    settings,
    theme
  } = core;
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    uiSettings,
    docLinks,
    http: core.http,
    settings,
    theme
  });
  let overlayRef = null;
  const canCloseValidator = {
    current: () => true
  };
  const onMounted = args => {
    canCloseValidator.current = args.canCloseValidator;
  };
  const openEditor = async ({
    onSave,
    fieldName: fieldNameToEdit,
    fieldToCreate,
    ctx: {
      dataView: dataViewLazyOrNot
    }
  }) => {
    const closeEditor = () => {
      if (overlayRef) {
        overlayRef.close();
        overlayRef = null;
      }
    };
    const onSaveField = updatedField => {
      closeEditor();
      if (onSave) {
        onSave(updatedField);
      }
    };
    const getRuntimeField = name => {
      const fld = dataViewLazyOrNot.getAllRuntimeFields()[name];
      return {
        name,
        runtimeField: fld,
        isMapped: false,
        esTypes: [],
        type: undefined,
        customLabel: undefined,
        customDescription: undefined,
        count: undefined,
        spec: {
          parentName: undefined
        }
      };
    };
    let dataViewLazy;
    if (dataViewLazyOrNot instanceof _shared_imports.DataViewLazy) {
      dataViewLazy = dataViewLazyOrNot;
    } else {
      if (dataViewLazyOrNot.id) {
        // force cache reset to have the latest field attributes
        dataViews.clearDataViewLazyCache(dataViewLazyOrNot.id);
      }
      dataViewLazy = await dataViews.toDataViewLazy(dataViewLazyOrNot);
    }
    const dataViewField = fieldNameToEdit ? (await dataViewLazy.getFieldByName(fieldNameToEdit, true)) || getRuntimeField(fieldNameToEdit) : undefined;
    if (fieldNameToEdit && !dataViewField) {
      const err = _i18n.i18n.translate('indexPatternFieldEditor.noSuchFieldName', {
        defaultMessage: "Field named ''{fieldName}'' not found on index pattern",
        values: {
          fieldName: fieldNameToEdit
        }
      });
      notifications.toasts.addDanger(err);
      return closeEditor;
    }
    const isNewRuntimeField = !fieldNameToEdit;
    const isExistingRuntimeField = dataViewField && dataViewField.runtimeField && !dataViewField.isMapped && (
    // treat composite subfield instances as mapped fields for field editing purposes
    dataViewField.runtimeField.type !== 'composite' || !dataViewField.type);
    const fieldTypeToProcess = isNewRuntimeField || isExistingRuntimeField ? 'runtime' : 'concrete';
    let field;
    if (dataViewField) {
      if (isExistingRuntimeField) {
        var _dataViewLazy$getForm;
        // Runtime field
        field = {
          name: fieldNameToEdit,
          customLabel: dataViewField.customLabel,
          customDescription: dataViewField.customDescription,
          popularity: dataViewField.count,
          format: (_dataViewLazy$getForm = dataViewLazy.getFormatterForFieldNoDefault(fieldNameToEdit)) === null || _dataViewLazy$getForm === void 0 ? void 0 : _dataViewLazy$getForm.toJSON(),
          ...dataViewLazy.getRuntimeField(fieldNameToEdit)
        };
      } else {
        var _dataViewLazy$getForm2;
        // Concrete field
        field = {
          name: fieldNameToEdit,
          type: dataViewField !== null && dataViewField !== void 0 && dataViewField.esTypes ? dataViewField.esTypes[0] : 'keyword',
          customLabel: dataViewField.customLabel,
          customDescription: dataViewField.customDescription,
          popularity: dataViewField.count,
          format: (_dataViewLazy$getForm2 = dataViewLazy.getFormatterForFieldNoDefault(fieldNameToEdit)) === null || _dataViewLazy$getForm2 === void 0 ? void 0 : _dataViewLazy$getForm2.toJSON(),
          parentName: dataViewField.spec.parentName
        };
      }
    }
    overlayRef = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_field_editor_loader.FieldEditorLoader, {
      onSave: onSaveField,
      onCancel: closeEditor,
      onMounted: onMounted,
      docLinks: docLinks,
      fieldToEdit: field,
      fieldToCreate: fieldToCreate,
      fieldTypeToProcess: fieldTypeToProcess
      // currently using two dataView versions since API consumer is still potentially using legacy dataView
      // this is what is used internally
      ,
      dataView: dataViewLazy
      // this is what has been passed by API consumer
      ,
      dataViewToUpdate: dataViewLazyOrNot,
      search: search,
      dataViews: dataViews,
      notifications: notifications,
      usageCollection: usageCollection,
      apiService: apiService,
      fieldFormatEditors: fieldFormatEditors,
      fieldFormats: fieldFormats,
      uiSettings: uiSettings,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 13
      }
    })), core), {
      className: _constants.euiFlyoutClassname,
      maxWidth: 708,
      size: 'l',
      ownFocus: true,
      hideCloseButton: true,
      'aria-label': isNewRuntimeField ? _i18n.i18n.translate('indexPatternFieldEditor.createField.flyoutAriaLabel', {
        defaultMessage: 'Create field'
      }) : _i18n.i18n.translate('indexPatternFieldEditor.editField.flyoutAriaLabel', {
        defaultMessage: 'Edit {fieldName} field',
        values: {
          fieldName: fieldNameToEdit
        }
      }),
      onClose: flyout => {
        const canClose = canCloseValidator.current();
        if (canClose) {
          flyout.close();
        }
      },
      maskProps: {
        className: 'indexPatternFieldEditorMaskOverlay',
        // // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
        style: 'z-index: 1004' // we need this flyout to be above the timeline flyout (which has a z-index of 1003)
      }
    });
    return closeEditor;
  };
  return openEditor(options);
};
exports.getFieldEditorOpener = getFieldEditorOpener;