"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldDeleteModalOpener = exports.DeleteCompositeSubfield = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("./shared_imports");
var _delete_field_modal = require("./components/confirm_modals/delete_field_modal");
var _remove_fields = require("./lib/remove_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/open_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Options for opening the field editor
 */

/**
 * Error throw when there's an attempt to directly delete a composite subfield
 * @param fieldName - the name of the field to delete
 */
class DeleteCompositeSubfield extends Error {
  constructor(fieldName) {
    super(`Field '${fieldName} cannot be deleted because it is a composite subfield.`);
  }
}
exports.DeleteCompositeSubfield = DeleteCompositeSubfield;
const getFieldDeleteModalOpener = ({
  core,
  dataViews,
  usageCollection
}) => async options => {
  if (typeof options.fieldName === 'string') {
    var _fieldToDelete$runtim;
    const fieldToDelete = await options.ctx.dataView.getFieldByName(options.fieldName);
    // we can check for composite type since composite runtime field definitions themselves don't become fields
    const doesBelongToCompositeField = (fieldToDelete === null || fieldToDelete === void 0 ? void 0 : (_fieldToDelete$runtim = fieldToDelete.runtimeField) === null || _fieldToDelete$runtim === void 0 ? void 0 : _fieldToDelete$runtim.type) === 'composite';
    if (doesBelongToCompositeField) {
      throw new DeleteCompositeSubfield(options.fieldName);
    }
  }
  const {
    overlays,
    notifications
  } = core;
  let overlayRef = null;

  /**
   * Open the delete field modal
   * @param Options for delete field modal
   * @returns Function to close the delete field modal
   */
  const openDeleteModal = ({
    onDelete,
    fieldName,
    ctx: {
      dataView
    }
  }) => {
    const fieldsToDelete = Array.isArray(fieldName) ? fieldName : [fieldName];
    const closeModal = () => {
      if (overlayRef) {
        overlayRef.close();
        overlayRef = null;
      }
    };
    const onConfirmDelete = async () => {
      closeModal();
      await (0, _remove_fields.removeFields)(fieldsToDelete, dataView, {
        dataViews,
        usageCollection,
        notifications
      });
      if (onDelete) {
        onDelete(fieldsToDelete);
      }
    };
    overlayRef = overlays.openModal((0, _shared_imports.toMountPoint)(/*#__PURE__*/_react.default.createElement(_delete_field_modal.DeleteFieldModal, {
      fieldsToDelete: fieldsToDelete,
      closeModal: closeModal,
      confirmDelete: onConfirmDelete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }), core));
    return closeModal;
  };
  return openDeleteModal(options);
};
exports.getFieldDeleteModalOpener = getFieldDeleteModalOpener;