"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSessionEBTManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esQuery = require("@kbn/es-query");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SearchSessionEBTManager {
  constructor({
    core,
    logger
  }) {
    (0, _defineProperty2.default)(this, "reportEventCore", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.reportEventCore = core.analytics.reportEvent;
    this.logger = logger;
  }
  reportEvent(...args) {
    if (!this.reportEventCore) return;
    try {
      this.reportEventCore(...args);
    } catch (e) {
      this.logger.error(e);
    }
  }
  trackBgsStarted({
    entryPoint,
    session
  }) {
    var _session$attributes$r;
    const query = (_session$attributes$r = session.attributes.restoreState) === null || _session$attributes$r === void 0 ? void 0 : _session$attributes$r.query;
    const queryString = this.getQueryString(query);
    this.reportEvent(_constants.BG_SEARCH_START, {
      entry_point: entryPoint,
      query_lang: this.getQueryLanguage(query),
      session_id: session.attributes.sessionId,
      query_chars_bucket: this.getQueryStringCharCount(queryString),
      query_lines_bucket: this.getQueryStringLineCount(queryString)
    });
  }
  trackBgsCompleted({
    response,
    session
  }) {
    var _session$attributes$r2;
    this.reportEvent(_constants.BG_SEARCH_COMPLETE, {
      query_lang: this.getQueryLanguage((_session$attributes$r2 = session.attributes.restoreState) === null || _session$attributes$r2 === void 0 ? void 0 : _session$attributes$r2.query),
      session_id: session.id,
      runtime_ms: response.rawResponse.took,
      result_rows_bucket: this.getResultsCount(response),
      result_bytes_bucket: Buffer.byteLength(JSON.stringify(response.rawResponse))
    });
  }
  trackBgsError({
    session,
    error
  }) {
    var _attributes$error, _this$getHttpStatus, _session$attributes$r3;
    const errorType = 'attributes' in error ? (_attributes$error = error.attributes.error) === null || _attributes$error === void 0 ? void 0 : _attributes$error.type : '';
    const httpStatus = (_this$getHttpStatus = this.getHttpStatus(error)) !== null && _this$getHttpStatus !== void 0 ? _this$getHttpStatus : -1;
    this.reportEvent(_constants.BG_SEARCH_ERROR, {
      query_lang: this.getQueryLanguage((_session$attributes$r3 = session.attributes.restoreState) === null || _session$attributes$r3 === void 0 ? void 0 : _session$attributes$r3.query),
      session_id: session.id,
      error_type: errorType !== null && errorType !== void 0 ? errorType : '',
      http_status: httpStatus
    });
  }
  trackBgsCancelled({
    session,
    cancelSource
  }) {
    var _session$attributes$r4;
    this.reportEvent(_constants.BG_SEARCH_CANCEL, {
      query_lang: this.getQueryLanguage((_session$attributes$r4 = session.attributes.restoreState) === null || _session$attributes$r4 === void 0 ? void 0 : _session$attributes$r4.query),
      session_id: session.id,
      cancel_source: cancelSource
    });
  }
  trackBgsOpened({
    session,
    resumeSource
  }) {
    var _session$restoreState;
    this.reportEvent(_constants.BG_SEARCH_OPEN, {
      query_lang: this.getQueryLanguage((_session$restoreState = session.restoreState) === null || _session$restoreState === void 0 ? void 0 : _session$restoreState.query),
      session_id: session.id,
      resume_source: resumeSource || '',
      status: session.status
    });
  }
  trackBgsListView({
    entryPoint
  }) {
    this.reportEvent(_constants.BG_SEARCH_LIST_VIEW, {
      entry_point: entryPoint
    });
  }
  getHttpStatus(error) {
    if ('statusCode' in error) {
      return error.statusCode;
    }
    if ('attributes' in error) {
      var _attributes$rawRespon;
      return (_attributes$rawRespon = error.attributes.rawResponse) === null || _attributes$rawRespon === void 0 ? void 0 : _attributes$rawRespon.status;
    }
    return -1;
  }
  getResultsCount(response) {
    if ('documents_found' in response.rawResponse) {
      return response.rawResponse.documents_found || 0;
    } else if ('hits' in response.rawResponse) {
      if (response.rawResponse.hits.total) return response.rawResponse.hits.total;
      return response.rawResponse.hits.hits.length;
    }
    return 0;
  }
  getQueryLanguage(query) {
    if (!query) return '';
    if ((0, _esQuery.isOfAggregateQueryType)(query)) return 'esql';
    return query.language;
  }
  getQueryString(query) {
    if (!query) return '';
    if ((0, _esQuery.isOfAggregateQueryType)(query)) return query.esql;
    if (typeof query.query === 'string') return query.query;
    return Object.values(query.query).join('');
  }
  getQueryStringCharCount(queryString) {
    return queryString.replace(/\n/g, '').length;
  }
  getQueryStringLineCount(queryString) {
    return queryString.split('\n').length;
  }
}
exports.SearchSessionEBTManager = SearchSessionEBTManager;