"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSettingsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_client = require("../../dashboard_client");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_renderer/settings/settings_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DUPLICATE_TITLE_CALLOUT_ID = 'duplicateTitleCallout';
const DashboardSettingsFlyout = ({
  onClose,
  ariaLabelledBy
}) => {
  var _localSettings$descri;
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [localSettings, setLocalSettings] = (0, _react.useState)(dashboardApi.getSettings());
  const [isTitleDuplicate, setIsTitleDuplicate] = (0, _react.useState)(false);
  const [isTitleDuplicateConfirmed, setIsTitleDuplicateConfirmed] = (0, _react.useState)(false);
  const [isApplying, setIsApplying] = (0, _react.useState)(false);
  const isMounted = (0, _useMountedState.default)();
  const onTitleDuplicate = () => {
    if (!isMounted()) return;
    setIsTitleDuplicate(true);
    setIsTitleDuplicateConfirmed(true);
  };
  const onApply = async () => {
    var _dashboardApi$title$$;
    setIsApplying(true);
    const validTitle = await (0, _dashboard_client.checkForDuplicateDashboardTitle)({
      title: localSettings.title,
      copyOnSave: false,
      lastSavedTitle: (_dashboardApi$title$$ = dashboardApi.title$.value) !== null && _dashboardApi$title$$ !== void 0 ? _dashboardApi$title$$ : '',
      onTitleDuplicate,
      isTitleDuplicateConfirmed
    });
    if (!isMounted()) return;
    setIsApplying(false);
    if (validTitle) {
      dashboardApi.setSettings(localSettings);
      onClose();
    }
  };
  const updateDashboardSetting = (0, _react.useCallback)(newSettings => {
    setLocalSettings(prevSettings => {
      return {
        ...prevSettings,
        ...newSettings
      };
    });
  }, []);
  const renderDuplicateTitleCallout = () => {
    if (!isTitleDuplicate) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.embeddableApi.showSettings.flyout.form.duplicateTitleLabel",
        defaultMessage: "This dashboard already exists",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }),
      color: "warning",
      "data-test-subj": "duplicateTitleWarningMessage",
      id: DUPLICATE_TITLE_CALLOUT_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.duplicateTitleDescription",
      defaultMessage: "Saving ''{title}'' creates a duplicate title.",
      values: {
        title: localSettings.title
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    })));
  };
  const renderTagSelector = () => {
    var _localSettings$tags;
    const savedObjectsTaggingApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
    if (!savedObjectsTaggingApi) return;
    return /*#__PURE__*/_react.default.createElement(savedObjectsTaggingApi.ui.components.SavedObjectSaveModalTagSelector, {
      initialSelection: (_localSettings$tags = localSettings.tags) !== null && _localSettings$tags !== void 0 ? _localSettings$tags : [],
      onTagsSelected: selectedTags => updateDashboardSetting({
        tags: selectedTags
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: ariaLabelledBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.title",
    defaultMessage: "Dashboard settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, renderDuplicateTitleCallout(), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "dashboardSettingsPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.panelTitleFormRowLabel",
      defaultMessage: "Title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    autoFocus: true,
    id: "dashboardTitleInput",
    className: "dashboardTitleInputText",
    "data-test-subj": "dashboardTitleInput",
    name: "title",
    type: "text",
    value: localSettings.title,
    onChange: event => {
      setIsTitleDuplicate(false);
      setIsTitleDuplicateConfirmed(false);
      updateDashboardSetting({
        title: event.target.value
      });
    },
    "aria-label": _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.panelTitleInputAriaLabel', {
      defaultMessage: 'Change the dashboard title'
    }),
    "aria-describedby": isTitleDuplicate ? DUPLICATE_TITLE_CALLOUT_ID : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.panelDescriptionFormRowLabel",
      defaultMessage: "Description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    id: "dashboardDescriptionInput",
    className: "dashboardDescriptionInputText",
    "data-test-subj": "dashboardDescriptionInput",
    name: "description",
    value: (_localSettings$descri = localSettings.description) !== null && _localSettings$descri !== void 0 ? _localSettings$descri : '',
    onChange: event => updateDashboardSetting({
      description: event.target.value
    }),
    "aria-label": _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.panelDescriptionAriaLabel', {
      defaultMessage: 'Change the dashboard description'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  })), renderTagSelector(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.storeTimeWithDashboardFormRowHelpText",
      defaultMessage: "This changes the time filter to the currently selected time each time this dashboard is loaded.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "storeTimeWithDashboard",
    checked: localSettings.timeRestore,
    onChange: event => updateDashboardSetting({
      timeRestore: event.target.checked
    }),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.storeTimeWithDashboardFormRowLabel",
      defaultMessage: "Store time with dashboard",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.useMarginsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Use margins between panels'
    }),
    checked: localSettings.useMargins,
    onChange: event => updateDashboardSetting({
      useMargins: event.target.checked
    }),
    "data-test-subj": "dashboardMarginsCheckbox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.hideAllPanelTitlesSwitchLabel', {
      defaultMessage: 'Show panel titles'
    }),
    checked: !localSettings.hidePanelTitles,
    onChange: event => updateDashboardSetting({
      hidePanelTitles: !event.target.checked
    }),
    "data-test-subj": "dashboardPanelTitlesCheckbox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.formRow.syncAcrossPanelsLabel', {
      defaultMessage: 'Sync across panels'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncColorsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync color palettes across panels'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.embeddableApi.showSettings.flyout.form.syncColorsBetweenPanelsSwitchHelp",
        defaultMessage: "Only valid for legacy {default} and {compatibility} palettes",
        values: {
          default: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 279,
              columnNumber: 33
            }
          }, _i18n.i18n.translate('dashboard.palettes.defaultPaletteLabel', {
            defaultMessage: 'Default'
          })),
          compatibility: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 286,
              columnNumber: 33
            }
          }, _i18n.i18n.translate('dashboard.palettes.kibanaPaletteLabel', {
            defaultMessage: 'Compatibility'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 27
        }
      }),
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "top",
      size: "s",
      type: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 23
      }
    })),
    checked: localSettings.syncColors,
    onChange: event => updateDashboardSetting({
      syncColors: event.target.checked
    }),
    "data-test-subj": "dashboardSyncColorsCheckbox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncCursorBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync cursor across panels'
    }),
    checked: localSettings.syncCursor,
    onChange: event => {
      const syncCursor = event.target.checked;
      if (!syncCursor && localSettings.syncTooltips) {
        updateDashboardSetting({
          syncCursor,
          syncTooltips: false
        });
      } else {
        updateDashboardSetting({
          syncCursor
        });
      }
    },
    "data-test-subj": "dashboardSyncCursorCheckbox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncTooltipsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync tooltips across panels'
    }),
    checked: localSettings.syncTooltips,
    disabled: !Boolean(localSettings.syncCursor),
    onChange: event => updateDashboardSetting({
      syncTooltips: event.target.checked
    }),
    "data-test-subj": "dashboardSyncTooltipsCheckbox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    "data-test-subj": "cancelCustomizeDashboardButton",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.cancelButtonTitle",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "applyCustomizeDashboardButton",
    onClick: onApply,
    fill: true,
    "aria-describedby": isTitleDuplicate ? DUPLICATE_TITLE_CALLOUT_ID : undefined,
    isLoading: isApplying,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 13
    }
  }, isTitleDuplicate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.confirmApplyButtonTitle",
    defaultMessage: "Confirm and apply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.applyButtonTitle",
    defaultMessage: "Apply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 17
    }
  }))))));
};
exports.DashboardSettingsFlyout = DashboardSettingsFlyout;