"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveMenu = void 0;
exports.showSaveMenu = showSaveMenu;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/kibana-react-plugin/public");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/top_nav/save_menu/show_save_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const container = document.createElement('div');
let isOpen = false;
function cleanup() {
  if (!isOpen) {
    return;
  }
  _reactDom.default.unmountComponentAtNode(container);
  document.body.removeChild(container);
  isOpen = false;
}
const SaveMenu = ({
  dashboardApi,
  anchorElement,
  isResetting,
  isSaveInProgress,
  resetChanges,
  dashboardInteractiveSave
}) => {
  const [hasOverlays, hasUnsavedChanges, lastSavedId] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.hasOverlays$, dashboardApi.hasUnsavedChanges$, dashboardApi.savedObjectId$);
  const closePopover = (0, _react.useCallback)(() => {
    cleanup();
    anchorElement.focus();
  }, [anchorElement]);
  const panels = [{
    id: 0,
    initialFocusedItemIndex: 0,
    items: [{
      name: _dashboard_app_strings.topNavStrings.editModeInteractiveSave.label,
      icon: 'save',
      'data-test-subj': 'dashboardInteractiveSaveMenuItem',
      iconType: lastSavedId ? undefined : 'save',
      onClick: () => {
        dashboardInteractiveSave();
        closePopover();
      }
    }, {
      name: _dashboard_app_strings.topNavStrings.resetChanges.label,
      icon: 'editorUndo',
      'data-test-subj': 'dashboardDiscardChangesMenuItem',
      isLoading: isResetting,
      disabled: isResetting || !hasUnsavedChanges || hasOverlays || isSaveInProgress || !lastSavedId,
      onClick: () => {
        resetChanges();
        closePopover();
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: isOpen,
    closePopover: closePopover,
    button: anchorElement,
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    attachToAnchor: true,
    panelStyle: {
      maxWidth: 100
    },
    buffer: 0,
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }));
};
exports.SaveMenu = SaveMenu;
function showSaveMenu({
  coreServices,
  ...props
}) {
  if (isOpen) {
    cleanup();
    return;
  }
  const theme = coreServices.theme.getTheme();
  isOpen = true;
  document.body.appendChild(container);
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: coreServices,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: theme.darkMode ? 'dark' : 'light',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SaveMenu, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  })))), container);
}