"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicAuth = void 0;
var _v = require("@kbn/zod/v4");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const authSchema = _v.z.object({
  username: _v.z.string().min(1, {
    message: i18n.BASIC_AUTH_USERNAME_REQUIRED_MESSAGE
  }).meta({
    label: i18n.BASIC_AUTH_USERNAME_LABEL
  }),
  password: _v.z.string().min(1, {
    message: i18n.BASIC_AUTH_PASSWORD_REQUIRED_MESSAGE
  }).meta({
    sensitive: true,
    label: i18n.BASIC_AUTH_PASSWORD_LABEL
  })
}).meta({
  label: i18n.BASIC_AUTH_LABEL
});
/**
 * HTTP Basic Authentication
 * Use for: Username + Password auth (Jira, etc.)
 */
const BasicAuth = exports.BasicAuth = {
  id: 'basic',
  schema: authSchema,
  configure: async (_, axiosInstance, secret) => {
    // set global defaults
    axiosInstance.defaults.auth = {
      username: secret.username,
      password: secret.password
    };
    return axiosInstance;
  }
};