"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScaleMode = ScaleMode;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _color_mapping = require("../../state/color_mapping");
var _assignments = require("../../config/assignments");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/palette_selector/scale.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ScaleMode({
  palettes
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const colorMode = (0, _reactRedux.useSelector)(state => state.colorMapping.colorMode);
  const model = (0, _reactRedux.useSelector)(state => state.colorMapping);
  const {
    paletteId
  } = model;
  const updateColorMode = (0, _react.useCallback)((type, preserveColorChanges) => {
    const updatedColorMode = type === 'gradient' ? {
      type: 'gradient',
      steps: [{
        type: 'categorical',
        paletteId,
        colorIndex: 0,
        touched: false
      }],
      sort: 'desc'
    } : {
      type: 'categorical'
    };
    const assignments = (0, _assignments.updateAssignmentsPalette)(model.assignments, updatedColorMode, paletteId, palettes, preserveColorChanges);
    dispatch((0, _color_mapping.updatePalette)({
      paletteId,
      assignments,
      colorMode: updatedColorMode
    }));
  }, [paletteId, model.assignments, palettes, dispatch]);
  const [colorScaleModalId, setColorScaleModalId] = (0, _react.useState)(null);
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const colorScaleModal = colorScaleModalId !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    title: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.modalTitle', {
      defaultMessage: 'Color changes detected'
    }),
    onCancel: () => {
      setColorScaleModalId(null);
    },
    onConfirm: () => {
      if (colorScaleModalId) updateColorMode(colorScaleModalId, false);
      setColorScaleModalId(null);
    },
    cancelButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.goBackButtonLabel', {
      defaultMessage: 'Go back'
    }),
    confirmButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.discardButtonLabel', {
      defaultMessage: 'Discard changes'
    }),
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, colorScaleModalId === 'categorical' ? _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.categoricalModeDescription', {
    defaultMessage: `Switching to a categorical mode will discard all your custom color changes`
  }) : _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.sequentialModeDescription', {
    defaultMessage: `Switching to a gradient mode will discard all your custom color changes`
  }))) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, colorScaleModal, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.scaleLabel', {
      defaultMessage: `Mode`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "Mode",
    buttonSize: "compressed",
    "data-test-subj": "lns_colorMapping_scaleSwitch",
    options: [{
      id: `categorical`,
      label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.categoricalLabel', {
        defaultMessage: `Categorical`
      }),
      iconType: 'palette'
    }, {
      id: `gradient`,
      label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.gradientLabel', {
        defaultMessage: `Gradient`
      }),
      iconType: 'gradient'
    }],
    isIconOnly: true,
    idSelected: colorMode.type,
    onChange: id => {
      const hasChanges = model.assignments.some(a => a.touched);
      const hasGradientChanges = model.colorMode.type === 'gradient' && model.colorMode.steps.some(a => a.touched);
      if (hasChanges || hasGradientChanges) {
        setColorScaleModalId(id);
      } else {
        updateColorMode(id, false);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })));
}