"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EksCredentialsForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/fleet_extensions/cnvm_kspm/eks_credentials_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AWSSetupInfoContent = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "xl",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h2", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.setupInfoContentTitle",
  defaultMessage: "Setup Access",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.setupInfoContent",
  defaultMessage: "The integration will need elevated access to run some CIS benchmark rules. Select your preferred method of providing the AWS credentials this integration will use. You can follow these step-by-step instructions to generate the necessary credentials.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 7
  }
})));
const DocsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.docsLink",
  defaultMessage: "Read the {docs} for more details",
  values: {
    docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }, "documentation")
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 5
  }
}));
const AssumeRoleDescription = /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.assumeRoleDescription",
  defaultMessage: "An IAM role Amazon Resource Name (ARN) is an IAM identity that you can create in your AWS account. When creating an IAM role, users can define the role\u2019s permissions. Roles do not have standard long-term credentials such as passwords or access keys.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 7
  }
})));
const DirectAccessKeysDescription = /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.directAccessKeysDescription",
  defaultMessage: "Access keys are long-term credentials for an IAM user or the AWS account root user.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 7
  }
})));
const TemporaryKeysDescription = /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.temporaryKeysDescription",
  defaultMessage: "You can configure temporary security credentials in AWS to last for a specified duration. They consist of an access key ID, a secret access key, and a security token, which is typically found using GetSessionToken.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 88,
    columnNumber: 7
  }
})));
const SharedCredentialsDescription = /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 100,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.eksIntegration.sharedCredentialsDescription",
  defaultMessage: "If you use different AWS credentials for different tools or applications, you can use profiles to define multiple access keys in the same configuration file.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 101,
    columnNumber: 7
  }
})));
const AWS_FIELD_LABEL = {
  access_key_id: _i18n.i18n.translate('xpack.csp.eksIntegration.accessKeyIdLabel', {
    defaultMessage: 'Access Key ID'
  }),
  secret_access_key: _i18n.i18n.translate('xpack.csp.eksIntegration.secretAccessKeyLabel', {
    defaultMessage: 'Secret Access Key'
  })
};
const options = {
  assume_role: {
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.assumeRoleLabel', {
      defaultMessage: 'Assume role'
    }),
    info: AssumeRoleDescription,
    fields: {
      role_arn: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.roleArnLabel', {
          defaultMessage: 'Role ARN'
        }),
        dataTestSubj: 'roleArnInput'
      }
    },
    testId: 'assumeRoleTestId'
  },
  direct_access_keys: {
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'directAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'directAccessSecretKey',
        isSecret: true
      }
    },
    testId: 'directAccessKeyTestId'
  },
  temporary_keys: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'temporaryKeysAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'temporaryKeysSecretAccessKey',
        isSecret: true
      },
      session_token: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'temporaryKeysSessionToken'
      }
    },
    testId: 'temporaryKeyTestId'
  },
  shared_credentials: {
    label: _i18n.i18n.translate('xpack.csp.eksIntegration.sharedCredentialLabel', {
      defaultMessage: 'Shared credentials'
    }),
    info: SharedCredentialsDescription,
    fields: {
      shared_credential_file: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.sharedCredentialFileLabel', {
          defaultMessage: 'Shared Credential File'
        }),
        dataTestSubj: 'sharedCredentialFile'
      },
      credential_profile_name: {
        label: _i18n.i18n.translate('xpack.csp.eksIntegration.credentialProfileNameLabel', {
          defaultMessage: 'Credential Profile Name'
        }),
        dataTestSubj: 'credentialProfileName'
      }
    },
    testId: 'sharedCredentialsTestId'
  }
};
const AWS_CREDENTIALS_OPTIONS = Object.keys(options).map(value => ({
  id: value,
  label: options[value].label,
  testId: options[value].testId
}));
const getInputVarsFields = (input, fields) => {
  return Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
    const field = fields[id];
    return {
      id,
      label: field.label,
      type: field.type || 'text',
      dataTestSubj: field.dataTestSubj,
      value: inputVar.value,
      isSecret: field === null || field === void 0 ? void 0 : field.isSecret
    };
  });
};
const getAwsCredentialsType = input => {
  var _input$streams$0$vars, _input$streams$0$vars2;
  return (_input$streams$0$vars = input.streams[0].vars) !== null && _input$streams$0$vars !== void 0 && _input$streams$0$vars['aws.credentials.type'] ? (_input$streams$0$vars2 = input.streams[0].vars) === null || _input$streams$0$vars2 === void 0 ? void 0 : _input$streams$0$vars2['aws.credentials.type'].value : undefined;
};
const AwsCredentialTypeSelector = ({
  type,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.RadioGroup, {
  size: "s",
  options: [...AWS_CREDENTIALS_OPTIONS],
  idSelected: type,
  onChange: id => onChange(id),
  name: "awsCredentialType",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 260,
    columnNumber: 3
  }
});
const EksCredentialsForm = ({
  input,
  newPolicy,
  packageInfo,
  updatePolicy
}) => {
  // We only have a value for 'aws.credentials.type' once the form has mounted.
  // On initial render we don't have that value so we default to the first option.
  const awsCredentialsType = getAwsCredentialsType(input) || AWS_CREDENTIALS_OPTIONS[0].id;
  const group = options[awsCredentialsType];
  const fields = getInputVarsFields(input, group.fields);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AWSSetupInfoContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AwsCredentialTypeSelector, {
    type: awsCredentialsType,
    onChange: optionId => updatePolicy({
      updatedPolicy: (0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'aws.credentials.type': {
          value: optionId
        }
      })
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 7
    }
  }), DocsLink, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.AwsInputVarFields, {
    fields: fields,
    packageInfo: packageInfo,
    onChange: (key, value) => updatePolicy({
      updatedPolicy: (0, _utils.getPosturePolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      })
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }));
};
exports.EksCredentialsForm = EksCredentialsForm;