"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleAuditAction = exports.GapAutoFillSchedulerAuditAction = exports.AdHocRunAuditAction = void 0;
exports.adHocRunAuditEvent = adHocRunAuditEvent;
exports.gapAutoFillSchedulerAuditEvent = gapAutoFillSchedulerAuditEvent;
exports.ruleAuditEvent = ruleAuditEvent;
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleAuditAction = exports.RuleAuditAction = /*#__PURE__*/function (RuleAuditAction) {
  RuleAuditAction["CREATE"] = "rule_create";
  RuleAuditAction["GET"] = "rule_get";
  RuleAuditAction["BULK_GET"] = "rule_bulk_get";
  RuleAuditAction["RESOLVE"] = "rule_resolve";
  RuleAuditAction["UPDATE"] = "rule_update";
  RuleAuditAction["UPDATE_API_KEY"] = "rule_update_api_key";
  RuleAuditAction["ENABLE"] = "rule_enable";
  RuleAuditAction["DISABLE"] = "rule_disable";
  RuleAuditAction["DELETE"] = "rule_delete";
  RuleAuditAction["FIND"] = "rule_find";
  RuleAuditAction["MUTE"] = "rule_mute";
  RuleAuditAction["UNMUTE"] = "rule_unmute";
  RuleAuditAction["MUTE_ALERT"] = "rule_alert_mute";
  RuleAuditAction["UNMUTE_ALERT"] = "rule_alert_unmute";
  RuleAuditAction["AGGREGATE"] = "rule_aggregate";
  RuleAuditAction["BULK_EDIT"] = "rule_bulk_edit";
  RuleAuditAction["BULK_EDIT_PARAMS"] = "rule_bulk_edit_params";
  RuleAuditAction["GET_EXECUTION_LOG"] = "rule_get_execution_log";
  RuleAuditAction["GET_GLOBAL_EXECUTION_LOG"] = "rule_get_global_execution_log";
  RuleAuditAction["GET_GLOBAL_EXECUTION_KPI"] = "rule_get_global_execution_kpi";
  RuleAuditAction["GET_GLOBAL_EXECUTION_SUMMARY"] = "rule_get_global_execution_summary";
  RuleAuditAction["GET_ACTION_ERROR_LOG"] = "rule_get_action_error_log";
  RuleAuditAction["GET_RULE_EXECUTION_KPI"] = "rule_get_execution_kpi";
  RuleAuditAction["SNOOZE"] = "rule_snooze";
  RuleAuditAction["UNSNOOZE"] = "rule_unsnooze";
  RuleAuditAction["RUN_SOON"] = "rule_run_soon";
  RuleAuditAction["UNTRACK_ALERT"] = "rule_alert_untrack";
  RuleAuditAction["SCHEDULE_BACKFILL"] = "rule_schedule_backfill";
  RuleAuditAction["FIND_GAPS"] = "rule_find_gaps";
  RuleAuditAction["FILL_GAPS"] = "rule_fill_gaps";
  RuleAuditAction["GET_RULES_WITH_GAPS"] = "rule_get_rules_with_gaps";
  RuleAuditAction["GET_GAPS_SUMMARY_BY_RULE_IDS"] = "rule_get_gaps_summary_by_rule_ids";
  return RuleAuditAction;
}({});
let AdHocRunAuditAction = exports.AdHocRunAuditAction = /*#__PURE__*/function (AdHocRunAuditAction) {
  AdHocRunAuditAction["CREATE"] = "ad_hoc_run_create";
  AdHocRunAuditAction["GET"] = "ad_hoc_run_get";
  AdHocRunAuditAction["FIND"] = "ad_hoc_run_find";
  AdHocRunAuditAction["DELETE"] = "ad_hoc_run_delete";
  return AdHocRunAuditAction;
}({});
let GapAutoFillSchedulerAuditAction = exports.GapAutoFillSchedulerAuditAction = /*#__PURE__*/function (GapAutoFillSchedulerAuditAction) {
  GapAutoFillSchedulerAuditAction["CREATE"] = "gap_auto_fill_scheduler_create";
  GapAutoFillSchedulerAuditAction["GET"] = "gap_auto_fill_scheduler_get";
  GapAutoFillSchedulerAuditAction["UPDATE"] = "gap_auto_fill_scheduler_update";
  GapAutoFillSchedulerAuditAction["DELETE"] = "gap_auto_fill_scheduler_delete";
  return GapAutoFillSchedulerAuditAction;
}({});
const ruleEventVerbs = {
  rule_create: ['create', 'creating', 'created'],
  rule_get: ['access', 'accessing', 'accessed'],
  rule_bulk_get: ['bulk access', 'bulk accessing', 'bulk accessed'],
  rule_resolve: ['access', 'accessing', 'accessed'],
  rule_update: ['update', 'updating', 'updated'],
  rule_bulk_edit: ['update', 'updating', 'updated'],
  rule_bulk_edit_params: ['update', 'updating', 'updated'],
  rule_update_api_key: ['update API key of', 'updating API key of', 'updated API key of'],
  rule_enable: ['enable', 'enabling', 'enabled'],
  rule_disable: ['disable', 'disabling', 'disabled'],
  rule_delete: ['delete', 'deleting', 'deleted'],
  rule_find: ['access', 'accessing', 'accessed'],
  rule_mute: ['mute', 'muting', 'muted'],
  rule_unmute: ['unmute', 'unmuting', 'unmuted'],
  rule_alert_mute: ['mute alert of', 'muting alert of', 'muted alert of'],
  rule_alert_unmute: ['unmute alert of', 'unmuting alert of', 'unmuted alert of'],
  rule_aggregate: ['access', 'accessing', 'accessed'],
  rule_get_execution_log: ['access execution log for', 'accessing execution log for', 'accessed execution log for'],
  rule_get_global_execution_log: ['access execution log', 'accessing execution log', 'accessed execution log'],
  rule_get_action_error_log: ['access action error log for', 'accessing action error log for', 'accessed action error log for'],
  rule_snooze: ['snooze', 'snoozing', 'snoozed'],
  rule_unsnooze: ['unsnooze', 'unsnoozing', 'unsnoozed'],
  rule_run_soon: ['run', 'running', 'ran'],
  rule_get_execution_kpi: ['access execution KPI for', 'accessing execution KPI for', 'accessed execution KPI for'],
  rule_get_global_execution_kpi: ['access global execution KPI for', 'accessing global execution KPI for', 'accessed global execution KPI for'],
  rule_get_global_execution_summary: ['access global execution summary for', 'accessing global execution summary for', 'accessed global execution summary for'],
  rule_alert_untrack: ['untrack', 'untracking', 'untracked'],
  rule_schedule_backfill: ['schedule backfill for', 'scheduling backfill for', 'scheduled backfill for'],
  rule_find_gaps: ['find gaps for', 'finding gaps for', 'found gaps for'],
  rule_fill_gaps: ['fill gaps for', 'filling gaps for', 'filled gaps for'],
  rule_get_rules_with_gaps: ['get rules with gaps', 'getting rules with gaps', 'got rules with gaps'],
  rule_get_gaps_summary_by_rule_ids: ['get gaps summary by rule ids', 'getting gaps summary by rule ids', 'got gaps summary by rule ids']
};
const adHocRunEventVerbs = {
  ad_hoc_run_create: ['create ad hoc run for', 'creating ad hoc run for', 'created ad hoc run for'],
  ad_hoc_run_get: ['get ad hoc run for', 'getting ad hoc run for', 'got ad hoc run for'],
  ad_hoc_run_find: ['find ad hoc run for', 'finding ad hoc run for', 'found ad hoc run for'],
  ad_hoc_run_delete: ['delete ad hoc run for', 'deleting ad hoc run for', 'deleted ad hoc run for']
};
const ruleEventTypes = {
  rule_create: 'creation',
  rule_get: 'access',
  rule_bulk_get: 'access',
  rule_resolve: 'access',
  rule_update: 'change',
  rule_bulk_edit: 'change',
  rule_bulk_edit_params: 'change',
  rule_update_api_key: 'change',
  rule_enable: 'change',
  rule_disable: 'change',
  rule_delete: 'deletion',
  rule_find: 'access',
  rule_mute: 'change',
  rule_unmute: 'change',
  rule_alert_mute: 'change',
  rule_alert_unmute: 'change',
  rule_aggregate: 'access',
  rule_get_execution_log: 'access',
  rule_get_global_execution_log: 'access',
  rule_get_action_error_log: 'access',
  rule_snooze: 'change',
  rule_unsnooze: 'change',
  rule_run_soon: 'access',
  rule_get_execution_kpi: 'access',
  rule_get_global_execution_kpi: 'access',
  rule_get_global_execution_summary: 'access',
  rule_alert_untrack: 'change',
  rule_schedule_backfill: 'access',
  rule_find_gaps: 'access',
  rule_fill_gaps: 'change',
  rule_get_rules_with_gaps: 'access',
  rule_get_gaps_summary_by_rule_ids: 'access'
};
const adHocRunEventTypes = {
  ad_hoc_run_create: 'creation',
  ad_hoc_run_get: 'access',
  ad_hoc_run_find: 'access',
  ad_hoc_run_delete: 'deletion'
};
function ruleAuditEvent({
  action,
  savedObject,
  outcome,
  error
}) {
  const doc = savedObject ? [`rule [id=${savedObject.id}]`, savedObject.name && `[name=${savedObject.name}]`].filter(Boolean).join(' ') : 'a rule';
  const [present, progressive, past] = ruleEventVerbs[action];
  const message = error ? `Failed attempt to ${present} ${doc}` : outcome === 'unknown' ? `User is ${progressive} ${doc}` : `User has ${past} ${doc}`;
  const type = ruleEventTypes[action];
  return {
    message,
    event: {
      action,
      category: ['database'],
      type: type ? [type] : undefined,
      outcome: outcome !== null && outcome !== void 0 ? outcome : error ? 'failure' : 'success'
    },
    kibana: {
      saved_object: savedObject
    },
    error: error && {
      code: error.name,
      message: error.message
    }
  };
}
function adHocRunAuditEvent({
  action,
  savedObject,
  outcome,
  error
}) {
  const doc = savedObject ? [`${_saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE} [id=${savedObject.id}]`, savedObject.name && `${savedObject.name}`].filter(Boolean).join(' ') : 'an ad hoc run';
  const [present, progressive, past] = adHocRunEventVerbs[action];
  const message = error ? `Failed attempt to ${present} ${doc}` : outcome === 'unknown' ? `User is ${progressive} ${doc}` : `User has ${past} ${doc}`;
  const type = adHocRunEventTypes[action];
  return {
    message,
    event: {
      action,
      category: ['database'],
      type: type ? [type] : undefined,
      outcome: outcome !== null && outcome !== void 0 ? outcome : error ? 'failure' : 'success'
    },
    kibana: {
      saved_object: savedObject
    },
    error: error && {
      code: error.name,
      message: error.message
    }
  };
}
const gapAutoFillSchedulerEventVerbs = {
  gap_auto_fill_scheduler_create: ['create gap auto fill scheduler', 'creating gap auto fill scheduler', 'created gap auto fill scheduler'],
  gap_auto_fill_scheduler_get: ['get gap auto fill scheduler', 'getting gap auto fill scheduler', 'got gap auto fill scheduler'],
  gap_auto_fill_scheduler_update: ['update gap auto fill scheduler', 'updating gap auto fill scheduler', 'updated gap auto fill scheduler'],
  gap_auto_fill_scheduler_delete: ['delete gap auto fill scheduler', 'deleting gap auto fill scheduler', 'deleted gap auto fill scheduler']
};
const gapAutoFillSchedulerEventTypes = {
  gap_auto_fill_scheduler_create: 'creation',
  gap_auto_fill_scheduler_get: 'access',
  gap_auto_fill_scheduler_update: 'change',
  gap_auto_fill_scheduler_delete: 'deletion'
};
function gapAutoFillSchedulerAuditEvent({
  action,
  savedObject,
  outcome,
  error
}) {
  const doc = savedObject ? [`${_saved_objects.GAP_AUTO_FILL_SCHEDULER_SAVED_OBJECT_TYPE} [id=${savedObject.id}]`, savedObject.name && `[name=${savedObject.name}]`].filter(Boolean).join(' ') : 'a gap auto fill scheduler';
  const [present, progressive, past] = gapAutoFillSchedulerEventVerbs[action];
  const message = error ? `Failed attempt to ${present} ${doc}` : outcome === 'unknown' ? `User is ${progressive} ${doc}` : `User has ${past} ${doc}`;
  const type = gapAutoFillSchedulerEventTypes[action];
  return {
    message,
    event: {
      action,
      category: ['database'],
      type: type ? [type] : undefined,
      outcome: outcome !== null && outcome !== void 0 ? outcome : error ? 'failure' : 'success'
    },
    kibana: {
      saved_object: savedObject
    },
    error: error && {
      code: error.name,
      message: error.message
    }
  };
}