"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewInLogPatternAnalysisAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _table_action_button = require("./table_action_button");
var _get_table_item_as_kql = require("./get_table_item_as_kql");
var _use_filters_query = require("../../hooks/use_filters_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis_results_table/use_view_in_log_pattern_analysis_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isLogPattern = tableItem => (0, _mlAggUtils.isSignificantItem)(tableItem) && tableItem.type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.LOG_PATTERN;
const viewInLogPatternAnalysisMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.linksMenu.viewInLogPatternAnalysis', {
  defaultMessage: 'View in Log Pattern Analysis'
});
const useViewInLogPatternAnalysisAction = dataViewId => {
  const {
    application,
    share,
    data
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const mlLocator = (0, _react.useMemo)(() => share === null || share === void 0 ? void 0 : share.url.locators.get('ML_APP_LOCATOR'), [share === null || share === void 0 ? void 0 : share.url.locators]);

  // We cannot rely on the time range from AiOps App context because it is not always in sync with the time range used for analysis.
  // E.g. In the case of an embeddable inside cases, the time range is fixed and not coming from the time picker.
  const {
    timeRange
  } = (0, _use_filters_query.useFilterQueryUpdates)();
  const generateLogPatternAnalysisUrl = async groupTableItem => {
    if (mlLocator !== undefined) {
      const searchString = (0, _get_table_item_as_kql.getTableItemAsKQL)(groupTableItem);
      const ast = (0, _esQuery.fromKueryExpression)(searchString);
      const searchQuery = (0, _esQuery.toElasticsearchQuery)(ast);
      const appState = {
        logCategorization: {
          filters: data.query.filterManager.getFilters(),
          // QueryDslQueryContainer type triggers an error as being
          // not working with SerializableRecord, however, it works as expected.
          searchQuery: searchQuery,
          searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
          searchString: (0, _get_table_item_as_kql.getTableItemAsKQL)(groupTableItem)
        }
      };
      return await mlLocator.getUrl({
        page: 'aiops/log_categorization',
        pageState: {
          index: dataViewId,
          globalState: {
            time: timeRange
          },
          appState
        }
      });
    }
  };
  const logPatternAnalysisUrlError = (0, _react.useMemo)(() => {
    if (!mlLocator) {
      return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.mlLocatorMissingErrorMessage', {
        defaultMessage: 'No locator for Log Pattern Analysis detected'
      });
    }
    if (!dataViewId) {
      return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.autoGeneratedLogPatternAnalysisLinkErrorMessage', {
        defaultMessage: 'Unable to link to Log Pattern Analysis; no data view exists for this index'
      });
    }
  }, [dataViewId, mlLocator]);
  return {
    render: tableItem => {
      const message = logPatternAnalysisUrlError ? logPatternAnalysisUrlError : viewInLogPatternAnalysisMessage;
      const clickHandler = async () => {
        if (!isLogPattern(tableItem)) {
          const openInLogPatternAnalysisUrl = await generateLogPatternAnalysisUrl(tableItem);
          if (typeof openInLogPatternAnalysisUrl === 'string') {
            await application.navigateToUrl(openInLogPatternAnalysisUrl);
          }
        }
      };
      const isDisabled = logPatternAnalysisUrlError !== undefined || isLogPattern(tableItem);
      return /*#__PURE__*/_react.default.createElement(_table_action_button.TableActionButton, {
        dataTestSubjPostfix: "LogPatternAnalysis",
        iconType: "logPatternAnalysis",
        isDisabled: isDisabled,
        label: viewInLogPatternAnalysisMessage,
        tooltipText: !isLogPattern(tableItem) ? message : _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.logPatternLinkNotAvailableTooltipMessage', {
          defaultMessage: 'This link is not available if the table item is a log pattern itself.'
        }),
        onClick: clickHandler,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      });
    }
  };
};
exports.useViewInLogPatternAnalysisAction = useViewInLogPatternAnalysisAction;