"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettingsPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _managementSettingsSectionRegistry = require("@kbn/management-settings-section-registry");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/advanced_settings/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  setup: sectionRegistrySetup,
  start: sectionRegistryStart
} = new _managementSettingsSectionRegistry.SectionRegistry();
const LazyKibanaSettingsApplication = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-application')))).KibanaSettingsApplication
}));
const KibanaSettingsApplication = (0, _sharedUxUtility.withSuspense)(LazyKibanaSettingsApplication);
const title = _i18n.i18n.translate('advancedSettings.advancedSettingsLabel', {
  defaultMessage: 'Advanced Settings'
});
class AdvancedSettingsPlugin {
  setup(core, {
    management,
    home
  }) {
    const kibanaSection = management.sections.section.kibana;
    kibanaSection.registerApp({
      id: 'settings',
      title,
      order: 3,
      async mount({
        element,
        setBreadcrumbs,
        history
      }) {
        const [coreStart, {
          spaces
        }] = await core.getStartServices();
        const {
          docTitle
        } = coreStart.chrome;
        docTitle.change(title);
        setBreadcrumbs([{
          text: title
        }]);
        _reactDom.default.render(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(KibanaSettingsApplication, (0, _extends2.default)({}, coreStart, {
          history,
          spaces,
          sectionRegistry: sectionRegistryStart,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 13
          }
        }))), element);
        return () => {
          docTitle.reset();
          _reactDom.default.unmountComponentAtNode(element);
        };
      }
    });
    if (home) {
      home.featureCatalogue.register({
        id: 'advanced_settings',
        title,
        description: _i18n.i18n.translate('advancedSettings.featureCatalogueTitle', {
          defaultMessage: 'Customize your Kibana experience — change the date format, turn on dark mode, and more.'
        }),
        icon: 'gear',
        path: '/app/management/kibana/settings',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    return {
      ...sectionRegistrySetup
    };
  }
  start() {
    return {
      ...sectionRegistryStart
    };
  }
}
exports.AdvancedSettingsPlugin = AdvancedSettingsPlugin;