"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elementCanBeDisabled = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var SUPPORTED_ELEMENTS = ['fieldset', 'input', 'select', 'optgroup', 'option', 'button', 'textarea'];
var elementCanBeDisabled = exports.elementCanBeDisabled = function elementCanBeDisabled(htmlElement) {
  var _htmlElement$getAttri;
  if (!htmlElement) return false;
  var tagName = htmlElement.tagName && htmlElement.tagName.toLowerCase();
  var roleName = (_htmlElement$getAttri = htmlElement.getAttribute('role')) !== null && _htmlElement$getAttri !== void 0 ? _htmlElement$getAttri : '';
  return SUPPORTED_ELEMENTS.includes(roleName) || SUPPORTED_ELEMENTS.includes(tagName);
};