"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormControlButtonStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "isuld2-textContent",
  styles: "flex:1;text-align:start;label:textContent;"
} : {
  name: "isuld2-textContent",
  styles: "flex:1;text-align:start;label:textContent;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFormControlButtonStyles = exports.euiFormControlButtonStyles = function euiFormControlButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  return {
    euiFormControlButton: /*#__PURE__*/(0, _react.css)(formStyles.shared, " ", formStyles.uncompressed, " font-weight:", euiTheme.font.weight.regular, ";transition:none;&:hover{&::before{display:none;}}&:focus{", formStyles.focus, ";}&:disabled{", formStyles.disabled, ";};label:euiFormControlButton;"),
    isInvalid: /*#__PURE__*/(0, _react.css)(formStyles.invalid, " &:disabled{", formStyles.invalid, ";};label:isInvalid;"),
    compressed: /*#__PURE__*/(0, _react.css)(formStyles.compressed, ";;label:compressed;"),
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/(0, _react.css)(formStyles.fullWidth, ";label:fullWidth;"),
    euiFormControlButton__content: /*#__PURE__*/(0, _react.css)("justify-content:flex-start;", (0, _global_styling.logicalCSS)('width', '100%'), ";;label:euiFormControlButton__content;"),
    textContent: _ref,
    placeholder: /*#__PURE__*/(0, _react.css)((0, _form.euiFormPlaceholderStyles)(euiThemeContext), ";;label:placeholder;")
  };
};