/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchSortValuesAndFormats;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;

public class ShardSearchRequest
extends AbstractTransportRequest
implements IndicesRequest {
    private final String clusterAlias;
    private final ShardId shardId;
    private final int shardRequestIndex;
    private final int numberOfShards;
    private final long waitForCheckpoint;
    private final TimeValue waitForCheckpointsTimeout;
    private final SearchType searchType;
    private final TimeValue scroll;
    private final float indexBoost;
    private Boolean requestCache;
    private final long nowInMillis;
    private final boolean allowPartialSearchResults;
    private final OriginalIndices originalIndices;
    private boolean canReturnNullResponseIfMatchNoDocs;
    private SearchSortValuesAndFormats bottomSortValues;
    private AliasFilter aliasFilter;
    private SearchSourceBuilder source;
    private final ShardSearchContextId readerId;
    private final TimeValue keepAlive;
    private final TransportVersion channelVersion;
    private final boolean forceSyntheticSource;
    private final SplitShardCountSummary splitShardCountSummary;
    public static final TransportVersion SHARD_SEARCH_REQUEST_RESHARD_SHARD_COUNT_SUMMARY = TransportVersion.fromName("shard_search_request_reshard_shard_count_summary");
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ThreadLocal<BytesStreamOutput> scratch = ThreadLocal.withInitial(BytesStreamOutput::new);

    public ShardSearchRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int shardRequestIndex, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias) {
        this(originalIndices, searchRequest, shardId, shardRequestIndex, numberOfShards, aliasFilter, indexBoost, nowInMillis, clusterAlias, null, null, SplitShardCountSummary.UNSET);
    }

    public ShardSearchRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int shardRequestIndex, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias, ShardSearchContextId readerId, TimeValue keepAlive, SplitShardCountSummary splitShardCountSummary) {
        this(originalIndices, shardId, shardRequestIndex, numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.requestCache(), aliasFilter, indexBoost, searchRequest.allowPartialSearchResults(), searchRequest.scroll(), nowInMillis, clusterAlias, readerId, keepAlive, ShardSearchRequest.computeWaitForCheckpoint(searchRequest.getWaitForCheckpoints(), shardId, shardRequestIndex), searchRequest.getWaitForCheckpointsTimeout(), searchRequest.isForceSyntheticSource(), splitShardCountSummary);
        assert (searchRequest.allowPartialSearchResults() != null);
    }

    public static long computeWaitForCheckpoint(Map<String, long[]> indexToWaitForCheckpoints, ShardId shardId, int shardRequestIndex) {
        long waitForCheckpoint;
        long[] waitForCheckpoints = indexToWaitForCheckpoints.getOrDefault(shardId.getIndex().getName(), EMPTY_LONG_ARRAY);
        if (waitForCheckpoints.length == 0) {
            waitForCheckpoint = -2L;
        } else {
            assert (waitForCheckpoints.length > shardRequestIndex);
            waitForCheckpoint = waitForCheckpoints[shardRequestIndex];
        }
        return waitForCheckpoint;
    }

    public ShardSearchRequest(ShardId shardId, long nowInMillis, AliasFilter aliasFilter) {
        this(shardId, nowInMillis, aliasFilter, null, SplitShardCountSummary.UNSET);
    }

    public ShardSearchRequest(ShardId shardId, long nowInMillis, AliasFilter aliasFilter, String clusterAlias, SplitShardCountSummary splitShardCountSummary) {
        this(OriginalIndices.NONE, shardId, -1, -1, SearchType.QUERY_THEN_FETCH, null, null, aliasFilter, 1.0f, true, null, nowInMillis, clusterAlias, null, null, -2L, SearchService.NO_TIMEOUT, false, splitShardCountSummary);
    }

    public ShardSearchRequest(OriginalIndices originalIndices, ShardId shardId, int shardRequestIndex, int numberOfShards, SearchType searchType, SearchSourceBuilder source, Boolean requestCache, AliasFilter aliasFilter, float indexBoost, boolean allowPartialSearchResults, TimeValue scroll, long nowInMillis, @Nullable String clusterAlias, ShardSearchContextId readerId, TimeValue keepAlive, long waitForCheckpoint, TimeValue waitForCheckpointsTimeout, boolean forceSyntheticSource, SplitShardCountSummary splitShardCountSummary) {
        this.shardId = shardId;
        this.shardRequestIndex = shardRequestIndex;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source(source);
        this.requestCache = requestCache;
        this.aliasFilter = aliasFilter;
        this.indexBoost = indexBoost;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.scroll = scroll;
        this.nowInMillis = nowInMillis;
        this.clusterAlias = clusterAlias;
        this.originalIndices = originalIndices;
        this.readerId = readerId;
        this.keepAlive = keepAlive;
        assert (keepAlive == null || readerId != null) : "readerId: null keepAlive: " + String.valueOf(keepAlive);
        this.channelVersion = TransportVersion.current();
        this.waitForCheckpoint = waitForCheckpoint;
        this.waitForCheckpointsTimeout = waitForCheckpointsTimeout;
        this.forceSyntheticSource = forceSyntheticSource;
        this.splitShardCountSummary = splitShardCountSummary;
    }

    public ShardSearchRequest(ShardSearchRequest clone) {
        this.shardId = clone.shardId;
        this.shardRequestIndex = clone.shardRequestIndex;
        this.searchType = clone.searchType;
        this.numberOfShards = clone.numberOfShards;
        this.scroll = clone.scroll;
        this.source(clone.source);
        this.aliasFilter = clone.aliasFilter;
        this.indexBoost = clone.indexBoost;
        this.nowInMillis = clone.nowInMillis;
        this.requestCache = clone.requestCache;
        this.clusterAlias = clone.clusterAlias;
        this.allowPartialSearchResults = clone.allowPartialSearchResults;
        this.canReturnNullResponseIfMatchNoDocs = clone.canReturnNullResponseIfMatchNoDocs;
        this.bottomSortValues = clone.bottomSortValues;
        this.originalIndices = clone.originalIndices;
        this.readerId = clone.readerId;
        this.keepAlive = clone.keepAlive;
        this.channelVersion = clone.channelVersion;
        this.waitForCheckpoint = clone.waitForCheckpoint;
        this.waitForCheckpointsTimeout = clone.waitForCheckpointsTimeout;
        this.forceSyntheticSource = clone.forceSyntheticSource;
        this.splitShardCountSummary = clone.splitShardCountSummary;
    }

    public ShardSearchRequest(StreamInput in) throws IOException {
        super(in);
        Object[] types;
        this.shardId = new ShardId(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.shardRequestIndex = in.readVInt();
        this.numberOfShards = in.readVInt();
        this.scroll = in.readOptionalTimeValue();
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) && in.getTransportVersion().before(TransportVersions.V_8_9_X)) {
            List<QueryBuilder> rankQueryBuilders = in.readNamedWriteableCollectionAsList(QueryBuilder.class);
            assert (rankQueryBuilders.size() != 1) : "[rank] requires at least [2] sub searches, but only found [1]";
            if (rankQueryBuilders.size() >= 2) {
                assert (this.source != null && this.source.rankBuilder() != null);
                ArrayList<SubSearchSourceBuilder> subSearchSourceBuilders = new ArrayList<SubSearchSourceBuilder>();
                for (QueryBuilder queryBuilder : rankQueryBuilders) {
                    subSearchSourceBuilders.add(new SubSearchSourceBuilder(queryBuilder));
                }
                this.source.subSearches(subSearchSourceBuilders);
            }
        }
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (types = in.readStringArray()).length > 0) {
            throw new IllegalStateException("types are no longer supported in search requests but found [" + Arrays.toString(types) + "]");
        }
        this.aliasFilter = AliasFilter.readFrom(in);
        this.indexBoost = in.readFloat();
        this.nowInMillis = in.readVLong();
        this.requestCache = in.readOptionalBoolean();
        this.clusterAlias = in.readOptionalString();
        this.allowPartialSearchResults = in.readBoolean();
        this.canReturnNullResponseIfMatchNoDocs = in.readBoolean();
        this.bottomSortValues = in.readOptionalWriteable(SearchSortValuesAndFormats::new);
        this.readerId = in.readOptionalWriteable(ShardSearchContextId::new);
        this.keepAlive = in.readOptionalTimeValue();
        assert (this.keepAlive == null || this.readerId != null) : "readerId: null keepAlive: " + String.valueOf(this.keepAlive);
        this.channelVersion = TransportVersion.min(TransportVersion.readVersion(in), in.getTransportVersion());
        this.waitForCheckpoint = in.readLong();
        this.waitForCheckpointsTimeout = in.readTimeValue();
        this.forceSyntheticSource = in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0) ? in.readBoolean() : false;
        this.splitShardCountSummary = in.getTransportVersion().supports(SHARD_SEARCH_REQUEST_RESHARD_SHARD_COUNT_SUMMARY) ? new SplitShardCountSummary(in) : SplitShardCountSummary.UNSET;
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.innerWriteTo(out, false);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    protected final void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        this.shardId.writeTo(out);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            out.writeVInt(this.shardRequestIndex);
            out.writeVInt(this.numberOfShards);
        }
        out.writeOptionalTimeValue(this.scroll);
        out.writeOptionalWriteable(this.source);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) && out.getTransportVersion().before(TransportVersions.V_8_9_X)) {
            ArrayList<QueryBuilder> rankQueryBuilders = new ArrayList<QueryBuilder>();
            if (this.source != null && this.source.rankBuilder() != null && this.source.subSearches().size() >= 2) {
                for (SubSearchSourceBuilder subSearchSourceBuilder : this.source.subSearches()) {
                    rankQueryBuilders.add(subSearchSourceBuilder.getQueryBuilder());
                }
            }
            out.writeNamedWriteableCollection(rankQueryBuilders);
        }
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        this.aliasFilter.writeTo(out);
        out.writeFloat(this.indexBoost);
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        out.writeOptionalBoolean(this.requestCache);
        out.writeOptionalString(this.clusterAlias);
        out.writeBoolean(this.allowPartialSearchResults);
        if (!asKey) {
            out.writeBoolean(this.canReturnNullResponseIfMatchNoDocs);
            out.writeOptionalWriteable(this.bottomSortValues);
            out.writeOptionalWriteable(this.readerId);
            out.writeOptionalTimeValue(this.keepAlive);
        }
        TransportVersion.writeVersion(this.channelVersion, out);
        out.writeLong(this.waitForCheckpoint);
        out.writeTimeValue(this.waitForCheckpointsTimeout);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            out.writeBoolean(this.forceSyntheticSource);
        } else if (this.forceSyntheticSource) {
            throw new IllegalArgumentException("force_synthetic_source is not supported before 8.4.0");
        }
        if (out.getTransportVersion().supports(SHARD_SEARCH_REQUEST_RESHARD_SHARD_COUNT_SUMMARY)) {
            this.splitShardCountSummary.writeTo(out);
        }
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public SearchSourceBuilder source() {
        return this.source;
    }

    public AliasFilter getAliasFilter() {
        return this.aliasFilter;
    }

    public void setAliasFilter(AliasFilter aliasFilter) {
        this.aliasFilter = aliasFilter;
    }

    public void source(SearchSourceBuilder source) {
        if (source != null && source.pointInTimeBuilder() != null) {
            source = source.shallowCopy();
            source.pointInTimeBuilder(new PointInTimeBuilder(BytesArray.EMPTY));
        }
        this.source = source;
    }

    public int shardRequestIndex() {
        return this.shardRequestIndex;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public float indexBoost() {
        return this.indexBoost;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    public void requestCache(Boolean requestCache) {
        this.requestCache = requestCache;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public TimeValue scroll() {
        return this.scroll;
    }

    public void setBottomSortValues(SearchSortValuesAndFormats values) {
        this.bottomSortValues = values;
    }

    public SearchSortValuesAndFormats getBottomSortValues() {
        return this.bottomSortValues;
    }

    public boolean canReturnNullResponseIfMatchNoDocs() {
        return this.canReturnNullResponseIfMatchNoDocs;
    }

    public void canReturnNullResponseIfMatchNoDocs(boolean value) {
        this.canReturnNullResponseIfMatchNoDocs = value;
    }

    public ShardSearchContextId readerId() {
        return this.readerId;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public long waitForCheckpoint() {
        return this.waitForCheckpoint;
    }

    public TimeValue getWaitForCheckpointsTimeout() {
        return this.waitForCheckpointsTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesReference cacheKey(CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> differentiator) throws IOException {
        BytesStreamOutput out = scratch.get();
        try {
            this.innerWriteTo(out, true);
            if (differentiator != null) {
                differentiator.accept(this, out);
            }
            BytesArray bytesArray = new BytesArray(MessageDigests.digest(out.bytes(), MessageDigests.sha256()));
            return bytesArray;
        }
        finally {
            out.reset();
        }
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public SplitShardCountSummary getSplitShardCountSummary() {
        return this.splitShardCountSummary;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "shardId[" + String.valueOf(this.shardId()) + "]";
    }

    public Rewriteable<Rewriteable> getRewriteable() {
        return new RequestRewritable(this);
    }

    public static QueryBuilder parseAliasFilter(CheckedFunction<BytesReference, QueryBuilder, IOException> filterParser, IndexMetadata metadata, String ... aliasNames) {
        if (aliasNames == null || aliasNames.length == 0) {
            return null;
        }
        Index index = metadata.getIndex();
        Map<String, AliasMetadata> aliases = metadata.getAliases();
        if (aliasNames.length == 1) {
            AliasMetadata alias = aliases.get(aliasNames[0]);
            if (alias == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            return ShardSearchRequest.parseAliasFilter(filterParser, alias, index);
        }
        BoolQueryBuilder combined = new BoolQueryBuilder();
        for (String aliasName : aliasNames) {
            AliasMetadata alias = aliases.get(aliasName);
            if (alias == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            QueryBuilder parsedFilter = ShardSearchRequest.parseAliasFilter(filterParser, alias, index);
            if (parsedFilter == null) {
                return null;
            }
            combined.should(parsedFilter);
        }
        return combined;
    }

    private static QueryBuilder parseAliasFilter(CheckedFunction<BytesReference, QueryBuilder, IOException> filterParser, AliasMetadata alias, Index index) {
        if (alias.filter() == null) {
            return null;
        }
        try {
            return (QueryBuilder)filterParser.apply((Object)alias.filter().compressedReference());
        }
        catch (IOException ex) {
            throw new AliasFilterParsingException(index, alias.getAlias(), "Invalid alias filter", ex);
        }
    }

    public final Map<String, Object> getRuntimeMappings() {
        return this.source == null ? Collections.emptyMap() : this.source.runtimeMappings();
    }

    public TransportVersion getChannelVersion() {
        return this.channelVersion;
    }

    public boolean isForceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    static class RequestRewritable
    implements Rewriteable<Rewriteable> {
        final ShardSearchRequest request;

        RequestRewritable(ShardSearchRequest request) {
            this.request = request;
        }

        @Override
        public Rewriteable rewrite(QueryRewriteContext ctx) throws IOException {
            FieldSortBuilder primarySort;
            SearchSourceBuilder newSource = this.request.source() == null ? null : Rewriteable.rewrite(this.request.source(), ctx);
            AliasFilter newAliasFilter = Rewriteable.rewrite(this.request.getAliasFilter(), ctx);
            SearchExecutionContext searchExecutionContext = ctx.convertToSearchExecutionContext();
            if (searchExecutionContext != null && (primarySort = FieldSortBuilder.getPrimaryFieldSortOrNull(newSource)) != null && primarySort.isBottomSortShardDisjoint(searchExecutionContext, this.request.getBottomSortValues())) {
                assert (newSource != null) : "source should contain a primary sort field";
                newSource = newSource.shallowCopy();
                int trackTotalHitsUpTo = SearchRequest.resolveTrackTotalHitsUpTo(this.request.scroll, this.request.source);
                if (trackTotalHitsUpTo == -1 && newSource.suggest() == null && newSource.aggregations() == null) {
                    newSource.query(new MatchNoneQueryBuilder());
                } else {
                    newSource.size(0);
                }
                this.request.source(newSource);
                this.request.setBottomSortValues(null);
            }
            if (newSource == this.request.source() && newAliasFilter == this.request.getAliasFilter()) {
                return this;
            }
            this.request.source(newSource);
            this.request.setAliasFilter(newAliasFilter);
            return new RequestRewritable(this.request);
        }
    }
}

