/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.vectors.GenericFlatVectorReaders;
import org.elasticsearch.search.vectors.ESAcceptDocs;
import org.elasticsearch.search.vectors.IVFKnnSearchStrategy;

public abstract class IVFVectorsReader
extends KnnVectorsReader {
    private final IndexInput ivfCentroids;
    private final IndexInput ivfClusters;
    private final SegmentReadState state;
    private final FieldInfos fieldInfos;
    protected final IntObjectHashMap<FieldEntry> fields;
    private final GenericFlatVectorReaders genericReaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IVFVectorsReader(SegmentReadState state, GenericFlatVectorReaders.LoadFlatVectorsReader loadReader) throws IOException {
        this.state = state;
        this.fieldInfos = state.fieldInfos;
        this.fields = new IntObjectHashMap();
        this.genericReaders = new GenericFlatVectorReaders();
        String meta = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"mivf");
        int versionMeta = -1;
        boolean success = false;
        try (ChecksumIndexInput ivfMeta = state.directory.openChecksumInput(meta);){
            Throwable priorE = null;
            try {
                versionMeta = CodecUtil.checkIndexHeader((DataInput)ivfMeta, (String)"ES920DiskBBQVectorsFormat", (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                this.readFields(ivfMeta, versionMeta, this.genericReaders, loadReader);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)ivfMeta, (Throwable)priorE);
            }
            this.ivfCentroids = IVFVectorsReader.openDataInput(state, versionMeta, "cenivf", "ES920DiskBBQVectorsFormat", state.context);
            this.ivfClusters = IVFVectorsReader.openDataInput(state, versionMeta, "clivf", "ES920DiskBBQVectorsFormat", state.context);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    public abstract CentroidIterator getCentroidIterator(FieldInfo var1, int var2, IndexInput var3, float[] var4, IndexInput var5, AcceptDocs var6, float var7, FloatVectorValues var8, float var9) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
        IndexInput in = state.directory.openInput(fileName, context);
        boolean success = false;
        try {
            int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (versionMeta != versionVectorData) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
            }
            CodecUtil.retrieveChecksum((IndexInput)in);
            success = true;
            IndexInput indexInput = in;
            return indexInput;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)in);
            }
        }
    }

    private void readFields(ChecksumIndexInput meta, int versionMeta, GenericFlatVectorReaders genericFields, GenericFlatVectorReaders.LoadFlatVectorsReader loadReader) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = this.fieldInfos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = this.readField((IndexInput)meta, info, versionMeta);
            genericFields.loadField(fieldNumber, fieldEntry, loadReader);
            this.fields.put(info.number, (Object)fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private FieldEntry readField(IndexInput input, FieldInfo info, int versionMeta) throws IOException {
        String rawVectorFormat = input.readString();
        boolean useDirectIOReads = versionMeta >= 1 && input.readByte() == 1;
        VectorEncoding vectorEncoding = IVFVectorsReader.readVectorEncoding((DataInput)input);
        VectorSimilarityFunction similarityFunction = IVFVectorsReader.readSimilarityFunction((DataInput)input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
        }
        int numCentroids = input.readInt();
        long centroidOffset = input.readLong();
        long centroidLength = input.readLong();
        float[] globalCentroid = new float[info.getVectorDimension()];
        long postingListOffset = -1L;
        long postingListLength = -1L;
        float globalCentroidDp = 0.0f;
        if (centroidLength > 0L) {
            postingListOffset = input.readLong();
            postingListLength = input.readLong();
            input.readFloats(globalCentroid, 0, globalCentroid.length);
            globalCentroidDp = Float.intBitsToFloat(input.readInt());
        }
        return this.doReadField(input, rawVectorFormat, useDirectIOReads, similarityFunction, vectorEncoding, numCentroids, centroidOffset, centroidLength, postingListOffset, postingListLength, globalCentroid, globalCentroidDp);
    }

    protected abstract FieldEntry doReadField(IndexInput var1, String var2, boolean var3, VectorSimilarityFunction var4, VectorEncoding var5, int var6, long var7, long var9, long var11, long var13, float[] var15, float var16) throws IOException;

    private static VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int i = input.readInt();
        if (i < 0 || i >= Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.size()) {
            throw new IllegalArgumentException("invalid distance function: " + i);
        }
        return (VectorSimilarityFunction)Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.get(i);
    }

    private static VectorEncoding readVectorEncoding(DataInput input) throws IOException {
        int encodingId = input.readInt();
        if (encodingId < 0 || encodingId >= VectorEncoding.values().length) {
            throw new CorruptIndexException("Invalid vector encoding id: " + encodingId, input);
        }
        return VectorEncoding.values()[encodingId];
    }

    public final void checkIntegrity() throws IOException {
        for (FlatVectorsReader reader : this.genericReaders.allReaders()) {
            reader.checkIntegrity();
        }
        CodecUtil.checksumEntireFile((IndexInput)this.ivfCentroids);
        CodecUtil.checksumEntireFile((IndexInput)this.ivfClusters);
    }

    private FlatVectorsReader getReaderForField(String field) {
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null) {
            throw new IllegalArgumentException("Could not find field [" + field + "]");
        }
        return this.genericReaders.getReaderForField(info.number);
    }

    public final FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.getReaderForField(field).getFloatVectorValues(field);
    }

    public final ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.getReaderForField(field).getByteVectorValues(field);
    }

    public final void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
        if (!fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            this.getReaderForField(field).search(field, target, knnCollector, acceptDocs);
            return;
        }
        if (fieldInfo.getVectorDimension() != target.length) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + fieldInfo.getVectorDimension());
        }
        ESAcceptDocs esAcceptDocs = acceptDocs instanceof ESAcceptDocs ? (ESAcceptDocs)acceptDocs : null;
        FloatVectorValues values = this.getReaderForField(field).getFloatVectorValues(field);
        int numVectors = values.size();
        float approximateCost = esAcceptDocs == null ? acceptDocs.cost() : (esAcceptDocs instanceof ESAcceptDocs.ESAcceptDocsAll ? numVectors : esAcceptDocs.approximateCost());
        float percentFiltered = Math.max(0.0f, Math.min(1.0f, approximateCost / (float)numVectors));
        float visitRatio = 0.0f;
        KnnSearchStrategy knnSearchStrategy = knnCollector.getSearchStrategy();
        if (knnSearchStrategy instanceof IVFKnnSearchStrategy) {
            IVFKnnSearchStrategy ivfSearchStrategy = (IVFKnnSearchStrategy)knnSearchStrategy;
            visitRatio = ivfSearchStrategy.getVisitRatio();
        }
        FieldEntry entry = (FieldEntry)this.fields.get(fieldInfo.number);
        if (visitRatio == 0.0f) {
            float estimated = Math.round(Math.log10(numVectors) * Math.log10(numVectors) * (double)knnCollector.k());
            visitRatio = estimated / (float)numVectors;
        }
        long maxVectorVisited = (long)(2.0 * (double)visitRatio * (double)numVectors);
        IndexInput postListSlice = entry.postingListSlice(this.ivfClusters);
        CentroidIterator centroidPrefetchingIterator = this.getCentroidIterator(fieldInfo, entry.numCentroids, entry.centroidSlice(this.ivfCentroids), target, postListSlice, acceptDocs, approximateCost, values, visitRatio);
        Bits acceptDocsBits = acceptDocs.bits();
        PostingVisitor scorer = this.getPostingVisitor(fieldInfo, postListSlice, target, acceptDocsBits);
        long expectedDocs = 0L;
        long actualDocs = 0L;
        while (centroidPrefetchingIterator.hasNext() && (maxVectorVisited > expectedDocs || knnCollector.minCompetitiveSimilarity() == Float.NEGATIVE_INFINITY)) {
            CentroidOffsetAndLength offsetAndLength = centroidPrefetchingIterator.nextPostingListOffsetAndLength();
            expectedDocs += (long)scorer.resetPostingsScorer(offsetAndLength.offset());
            actualDocs += (long)scorer.visit(knnCollector);
            if (knnCollector.getSearchStrategy() == null) continue;
            knnCollector.getSearchStrategy().nextVectorsBlock();
        }
        if (acceptDocsBits != null) {
            float unfilteredRatioVisited = (float)expectedDocs / (float)numVectors;
            int filteredVectors = (int)Math.ceil((float)numVectors * percentFiltered);
            float expectedScored = Math.min((float)(2 * filteredVectors) * unfilteredRatioVisited, (float)expectedDocs / 2.0f);
            while (centroidPrefetchingIterator.hasNext() && ((float)actualDocs < expectedScored || actualDocs < (long)knnCollector.k())) {
                CentroidOffsetAndLength offsetAndLength = centroidPrefetchingIterator.nextPostingListOffsetAndLength();
                scorer.resetPostingsScorer(offsetAndLength.offset());
                actualDocs += (long)scorer.visit(knnCollector);
                if (knnCollector.getSearchStrategy() == null) continue;
                knnCollector.getSearchStrategy().nextVectorsBlock();
            }
        }
    }

    public final void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
        ByteVectorValues values = this.getReaderForField(field).getByteVectorValues(field);
        for (int i = 0; i < values.size(); ++i) {
            float score = fieldInfo.getVectorSimilarityFunction().compare(target, values.vectorValue(i));
            knnCollector.collect(values.ordToDoc(i), score);
            if (!knnCollector.earlyTerminated()) continue;
            return;
        }
    }

    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        Map raw = this.getReaderForField(fieldInfo.name).getOffHeapByteSize(fieldInfo);
        FieldEntry fe = (FieldEntry)this.fields.get(fieldInfo.number);
        if (fe == null) {
            assert (fieldInfo.getVectorEncoding() == VectorEncoding.BYTE);
            return raw;
        }
        Map<String, Long> centroidsClusters = Map.of("cenivf", fe.centroidLength, "clivf", fe.postingListLength);
        return KnnVectorsReader.mergeOffHeapByteSizeMaps((Map)raw, centroidsClusters);
    }

    public void close() throws IOException {
        ArrayList<FlatVectorsReader> closeables = new ArrayList<FlatVectorsReader>(this.genericReaders.allReaders());
        Collections.addAll(closeables, this.ivfCentroids, this.ivfClusters);
        IOUtils.close(closeables);
    }

    public abstract PostingVisitor getPostingVisitor(FieldInfo var1, IndexInput var2, float[] var3, Bits var4) throws IOException;

    protected static class FieldEntry
    implements GenericFlatVectorReaders.Field {
        protected final String rawVectorFormatName;
        protected final boolean useDirectIOReads;
        protected final VectorSimilarityFunction similarityFunction;
        protected final VectorEncoding vectorEncoding;
        protected final int numCentroids;
        protected final long centroidOffset;
        protected final long centroidLength;
        protected final long postingListOffset;
        protected final long postingListLength;
        protected final float[] globalCentroid;
        protected final float globalCentroidDp;

        protected FieldEntry(String rawVectorFormatName, boolean useDirectIOReads, VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, int numCentroids, long centroidOffset, long centroidLength, long postingListOffset, long postingListLength, float[] globalCentroid, float globalCentroidDp) {
            this.rawVectorFormatName = rawVectorFormatName;
            this.useDirectIOReads = useDirectIOReads;
            this.similarityFunction = similarityFunction;
            this.vectorEncoding = vectorEncoding;
            this.numCentroids = numCentroids;
            this.centroidOffset = centroidOffset;
            this.centroidLength = centroidLength;
            this.postingListOffset = postingListOffset;
            this.postingListLength = postingListLength;
            this.globalCentroid = globalCentroid;
            this.globalCentroidDp = globalCentroidDp;
        }

        @Override
        public String rawVectorFormatName() {
            return this.rawVectorFormatName;
        }

        @Override
        public boolean useDirectIOReads() {
            return this.useDirectIOReads;
        }

        public int numCentroids() {
            return this.numCentroids;
        }

        public float[] globalCentroid() {
            return this.globalCentroid;
        }

        public float globalCentroidDp() {
            return this.globalCentroidDp;
        }

        public VectorSimilarityFunction similarityFunction() {
            return this.similarityFunction;
        }

        public IndexInput centroidSlice(IndexInput centroidFile) throws IOException {
            return centroidFile.slice("centroids", this.centroidOffset, this.centroidLength);
        }

        public IndexInput postingListSlice(IndexInput postingListFile) throws IOException {
            return postingListFile.slice("postingLists", this.postingListOffset, this.postingListLength);
        }
    }

    public static interface CentroidIterator {
        public boolean hasNext();

        public CentroidOffsetAndLength nextPostingListOffsetAndLength() throws IOException;
    }

    public static interface PostingVisitor {
        public int resetPostingsScorer(long var1) throws IOException;

        public int visit(KnnCollector var1) throws IOException;
    }

    public record CentroidOffsetAndLength(long offset, long length) {
    }
}

