/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;

public class BytesRefs {
    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            return bytesRef.utf8ToString();
        }
        return value.toString();
    }

    public static BytesRef toBytesRef(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            return bytesRef;
        }
        return new BytesRef((CharSequence)value.toString());
    }

    public static BytesRef checkIndexableLength(BytesRef input) {
        if (input.length > 32766) {
            throw new IllegalArgumentException("Term is longer than maximum indexable length, term starting with [" + BytesRefs.safeStringPrefix(input, 10));
        }
        return input;
    }

    public static BytesRef toExactSizedBytesRef(String s) {
        int l = s.length();
        byte[] b = new byte[UnicodeUtil.calcUTF16toUTF8Length((CharSequence)s, (int)0, (int)l)];
        UnicodeUtil.UTF16toUTF8((CharSequence)s, (int)0, (int)l, (byte[])b);
        return new BytesRef(b, 0, b.length);
    }

    private static String safeStringPrefix(BytesRef input, int prefixLength) {
        BytesRef prefix = new BytesRef(input.bytes, input.offset, prefixLength);
        try {
            return prefix.utf8ToString();
        }
        catch (Exception e) {
            return prefix.toString();
        }
    }
}

