/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.GenericNamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.Text;
import org.elasticsearch.xcontent.XContentString;

public abstract class StreamInput
extends InputStream {
    private TransportVersion version = TransportVersion.current();
    private static final int SMALL_STRING_LIMIT = 1024;
    private static final ThreadLocal<byte[]> stringReadBuffer = ThreadLocal.withInitial(() -> new byte[1024]);
    private static final ThreadLocal<char[]> smallSpare = ThreadLocal.withInitial(() -> new char[1024]);
    private char[] largeSpare;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final TimeUnit[] TIME_UNITS = TimeUnit.values();

    public TransportVersion getTransportVersion() {
        return this.version;
    }

    public void setTransportVersion(TransportVersion version) {
        this.version = version;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public BytesReference readBytesReference() throws IOException {
        int length = this.readArraySize();
        return this.readBytesReference(length);
    }

    public ReleasableBytesReference readReleasableBytesReference() throws IOException {
        return ReleasableBytesReference.wrap(this.readBytesReference());
    }

    public ReleasableBytesReference readReleasableBytesReference(int length) throws IOException {
        return ReleasableBytesReference.wrap(this.readBytesReference(length));
    }

    public BytesReference readSlicedBytesReference() throws IOException {
        return this.readBytesReference();
    }

    public BytesReference readSlicedBytesReference(int bytes) throws IOException {
        return this.readBytesReference(bytes);
    }

    public boolean supportReadAllToReleasableBytesReference() {
        return false;
    }

    public ReleasableBytesReference readAllToReleasableBytesReference() throws IOException {
        assert (false) : "This InputStream doesn't support readAllToReleasableBytesReference";
        throw new UnsupportedOperationException("This InputStream doesn't support readAllToReleasableBytesReference");
    }

    @Nullable
    public BytesReference readOptionalBytesReference() throws IOException {
        int length = this.readVInt() - 1;
        if (length < 0) {
            return null;
        }
        return this.readBytesReference(length);
    }

    public BytesReference readBytesReference(int length) throws IOException {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesArray(bytes, 0, length);
    }

    public BytesRef readBytesRef() throws IOException {
        int length = this.readArraySize();
        return this.readBytesRef(length);
    }

    @Nullable
    public BytesRef readBytesRefOrNullIfEmpty() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return null;
        }
        return this.readBytesRef(length);
    }

    public BytesRef readBytesRef(int length) throws IOException {
        if (length == 0) {
            return new BytesRef();
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesRef(bytes, 0, length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public Integer readOptionalInt() throws IOException {
        if (this.readBoolean()) {
            return this.readInt();
        }
        return null;
    }

    public int readVInt() throws IOException {
        return this.readVIntSlow();
    }

    protected final int readVIntSlow() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if ((b & 0x80) != 0) {
            StreamInput.throwOnBrokenVInt(b, i);
        }
        return i | (b & 0x7F) << 28;
    }

    protected static void throwOnBrokenVInt(byte b, int accumulated) throws IOException {
        throw new IOException("Invalid vInt ((" + Integer.toHexString(b) + " & 0x7f) << 28) | " + Integer.toHexString(accumulated));
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        return this.readVLongSlow();
    }

    protected final long readVLongSlow() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if (b != 0 && b != 1) {
            StreamInput.throwOnBrokenVLong(b, i);
        }
        return i |= (long)b << 63;
    }

    protected static void throwOnBrokenVLong(byte b, long accumulated) throws IOException {
        throw new IOException("Invalid vlong (" + Integer.toHexString(b) + " << 63) | " + Long.toHexString(accumulated));
    }

    @Nullable
    public Long readOptionalVLong() throws IOException {
        if (this.readBoolean()) {
            return this.readVLong();
        }
        return null;
    }

    public long readZLong() throws IOException {
        long currentByte;
        long accumulator = 0L;
        int i = 0;
        while (((currentByte = (long)this.readByte()) & 0x80L) != 0L) {
            accumulator |= (currentByte & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IOException("variable-length stream is too long");
        }
        return BitUtil.zigZagDecode((long)(accumulator | currentByte << i));
    }

    @Nullable
    public Long readOptionalLong() throws IOException {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    public BigInteger readBigInteger() throws IOException {
        return new BigInteger(this.readString());
    }

    private Text readText(int length) throws IOException {
        byte[] bytes = new byte[length];
        if (length > 0) {
            this.readBytes(bytes, 0, length);
        }
        XContentString.UTF8Bytes encoded = new XContentString.UTF8Bytes(bytes);
        return new Text(encoded);
    }

    @Nullable
    public Text readOptionalText() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        return this.readText(length);
    }

    public Text readText() throws IOException {
        int length = this.readInt();
        return this.readText(length);
    }

    @Nullable
    public String readOptionalString() throws IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SecureString readOptionalSecureString() throws IOException {
        SecureString value = null;
        BytesReference bytesRef = this.readOptionalBytesReference();
        if (bytesRef != null) {
            byte[] bytes = BytesReference.toBytes(bytesRef);
            try {
                value = new SecureString(CharArrays.utf8BytesToChars((byte[])bytes));
            }
            finally {
                Arrays.fill(bytes, (byte)0);
            }
        }
        return value;
    }

    @Nullable
    public Float readOptionalFloat() throws IOException {
        if (this.readBoolean()) {
            return Float.valueOf(this.readFloat());
        }
        return null;
    }

    @Nullable
    public Integer readOptionalVInt() throws IOException {
        if (this.readBoolean()) {
            return this.readVInt();
        }
        return null;
    }

    private char[] ensureLargeSpare(int charCount) {
        char[] spare = this.largeSpare;
        if (spare == null || spare.length < charCount) {
            this.largeSpare = spare = new char[ArrayUtil.oversize((int)charCount, (int)2)];
        }
        return spare;
    }

    public String readString() throws IOException {
        int charCount = this.readArraySize();
        return this.doReadString(charCount);
    }

    protected String doReadString(int charCount) throws IOException {
        char[] charBuffer = charCount > 1024 ? this.ensureLargeSpare(charCount) : smallSpare.get();
        int charsOffset = 0;
        int offsetByteArray = 0;
        int sizeByteArray = 0;
        int missingFromPartial = 0;
        byte[] byteBuffer = stringReadBuffer.get();
        while (charsOffset < charCount) {
            int toRead;
            int minRemainingBytes;
            int charsLeft = charCount - charsOffset;
            int bufferFree = byteBuffer.length - sizeByteArray;
            if (missingFromPartial > 0) {
                minRemainingBytes = missingFromPartial + charsLeft - 1;
                missingFromPartial = 0;
            } else {
                minRemainingBytes = charsLeft;
            }
            if (bufferFree < minRemainingBytes) {
                if (offsetByteArray > 0) {
                    switch (sizeByteArray -= offsetByteArray) {
                        case 1: {
                            byteBuffer[0] = byteBuffer[offsetByteArray];
                            break;
                        }
                        case 2: {
                            byteBuffer[0] = byteBuffer[offsetByteArray];
                            byteBuffer[1] = byteBuffer[offsetByteArray + 1];
                        }
                    }
                    assert (sizeByteArray <= 2) : "We never copy more than 2 bytes here since a char is 3 bytes max";
                    toRead = Math.min(bufferFree + offsetByteArray, minRemainingBytes);
                    offsetByteArray = 0;
                } else {
                    toRead = bufferFree;
                }
            } else {
                toRead = minRemainingBytes;
            }
            this.readBytes(byteBuffer, sizeByteArray, toRead);
            sizeByteArray += toRead;
            while (offsetByteArray < sizeByteArray - 2) {
                int c = byteBuffer[offsetByteArray] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        charBuffer[charsOffset++] = (char)c;
                        break;
                    }
                    case 12: 
                    case 13: {
                        charBuffer[charsOffset++] = (char)((c & 0x1F) << 6 | byteBuffer[++offsetByteArray] & 0x3F);
                        break;
                    }
                    case 14: {
                        charBuffer[charsOffset++] = (char)((c & 0xF) << 12 | (byteBuffer[++offsetByteArray] & 0x3F) << 6 | byteBuffer[++offsetByteArray] & 0x3F);
                        break;
                    }
                    default: {
                        StreamInput.throwOnBrokenChar(c);
                    }
                }
                ++offsetByteArray;
            }
            int bufferedBytesRemaining = sizeByteArray - offsetByteArray;
            block16: for (int i = 0; i < bufferedBytesRemaining; ++i) {
                int c = byteBuffer[offsetByteArray] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        charBuffer[charsOffset++] = (char)c;
                        ++offsetByteArray;
                        continue block16;
                    }
                    case 12: 
                    case 13: {
                        missingFromPartial = 2 - (bufferedBytesRemaining - i);
                        if (missingFromPartial == 0) {
                            int n = charsOffset++;
                            int n2 = ++offsetByteArray;
                            ++offsetByteArray;
                            charBuffer[n] = (char)((c & 0x1F) << 6 | byteBuffer[n2] & 0x3F);
                        }
                        ++i;
                        continue block16;
                    }
                    case 14: {
                        missingFromPartial = 3 - (bufferedBytesRemaining - i);
                        ++i;
                        continue block16;
                    }
                    default: {
                        StreamInput.throwOnBrokenChar(c);
                    }
                }
            }
        }
        return new String(charBuffer, 0, charCount);
    }

    protected String tryReadStringFromBytes(byte[] bytes, int start, int limit, int chars) throws IOException {
        int end = start + chars;
        if (limit < end) {
            return null;
        }
        for (int pos = start; pos < end; ++pos) {
            if ((bytes[pos] & 0x80) == 0) continue;
            return this.tryReadUtf8StringFromBytes(bytes, start, limit, pos, end - pos);
        }
        this.skip(chars);
        return new String(bytes, start, chars, StandardCharsets.ISO_8859_1);
    }

    private String tryReadUtf8StringFromBytes(byte[] bytes, int start, int limit, int pos, int chars) throws IOException {
        block5: while (pos < limit && chars-- > 0) {
            int c = bytes[pos] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++pos;
                    continue block5;
                }
                case 12: 
                case 13: {
                    pos += 2;
                    continue block5;
                }
                case 14: {
                    if (StreamInput.maybeHighSurrogate(bytes, pos, limit)) {
                        return null;
                    }
                    pos += 3;
                    continue block5;
                }
            }
            StreamInput.throwOnBrokenChar(c);
        }
        if (chars == 0 && pos <= limit) {
            this.skip(pos -= start);
            return new String(bytes, start, pos, StandardCharsets.UTF_8);
        }
        return null;
    }

    private static boolean maybeHighSurrogate(byte[] bytes, int pos, int limit) {
        if (pos + 2 >= limit) {
            return true;
        }
        int c1 = bytes[pos] & 0xFF;
        int c2 = bytes[pos + 1] & 0xFF;
        int c3 = bytes[pos + 2] & 0xFF;
        int surrogateCandidate = (c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
        return surrogateCandidate >= 55296 && surrogateCandidate <= 56319;
    }

    private static void throwOnBrokenChar(int c) throws IOException {
        throw new IOException("Invalid string; unexpected character: " + c + " hex: " + Integer.toHexString(c));
    }

    public SecureString readSecureString() throws IOException {
        BytesReference bytesRef = this.readSlicedBytesReference();
        char[] chars = bytesRef.hasArray() ? CharArrays.utf8BytesToChars((byte[])bytesRef.array(), (int)bytesRef.arrayOffset(), (int)bytesRef.length()) : CharArrays.utf8BytesToChars((byte[])BytesReference.toBytes(bytesRef));
        return new SecureString(chars);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Nullable
    public final Double readOptionalDouble() throws IOException {
        if (this.readBoolean()) {
            return this.readDouble();
        }
        return null;
    }

    public final boolean readBoolean() throws IOException {
        return StreamInput.readBoolean(this.readByte());
    }

    private static boolean readBoolean(byte value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        String message = String.format(Locale.ROOT, "unexpected byte [0x%02x]", value);
        throw new IllegalStateException(message);
    }

    @Nullable
    public final Boolean readOptionalBoolean() throws IOException {
        byte value = this.readByte();
        if (value == 2) {
            return null;
        }
        return StreamInput.readBoolean(value);
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int available() throws IOException;

    public String[] readStringArray() throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readString();
        }
        return ret;
    }

    @Nullable
    public String[] readOptionalStringArray() throws IOException {
        if (this.readBoolean()) {
            return this.readStringArray();
        }
        return null;
    }

    @Nullable
    public byte[] readOptionalByteArray() throws IOException {
        if (this.readBoolean()) {
            return this.readByteArray();
        }
        return null;
    }

    @Nullable
    public float[] readOptionalFloatArray() throws IOException {
        if (this.readBoolean()) {
            return this.readFloatArray();
        }
        return null;
    }

    public <V> Map<String, V> readMap(Writeable.Reader<V> valueReader) throws IOException {
        return this.readMap(StreamInput::readString, valueReader, Maps::newHashMapWithExpectedSize);
    }

    public <K, V> Map<K, V> readMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        return this.readMap(keyReader, valueReader, Maps::newHashMapWithExpectedSize);
    }

    public <K, V> Map<K, V> readOrderedMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        return this.readMap(keyReader, valueReader, Maps::newLinkedHashMapWithExpectedSize);
    }

    private <K, V> Map<K, V> readMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader, IntFunction<Map<K, V>> constructor) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyMap();
        }
        Map<K, V> map = constructor.apply(size);
        for (int i = 0; i < size; ++i) {
            K key = keyReader.read(this);
            V value = valueReader.read(this);
            map.put(key, value);
        }
        return map;
    }

    public <V> Map<String, List<V>> readMapOfLists(Writeable.Reader<V> valueReader) throws IOException {
        return this.readMap(i -> i.readCollectionAsList(valueReader));
    }

    public <K, V> Map<K, V> readMapValues(Writeable.Reader<V> valueReader, Function<V, K> keyMapper) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Map.of();
        }
        Map<K, V> map = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            V value = valueReader.read(this);
            map.put(keyMapper.apply(value), value);
        }
        return map;
    }

    public <K, V, M extends Map<K, V>> M readMapValues(Writeable.Reader<V> valueReader, Function<V, K> keyMapper, IntFunction<M> constructor) throws IOException {
        int size = this.readArraySize();
        Map map = (Map)constructor.apply(size);
        for (int i = 0; i < size; ++i) {
            V value = valueReader.read(this);
            map.put(keyMapper.apply(value), value);
        }
        return (M)map;
    }

    @Nullable
    public Map<String, Object> readGenericMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    public <V> Map<String, V> readImmutableMap(Writeable.Reader<V> valueReader) throws IOException {
        return this.readImmutableMap(StreamInput::readString, valueReader);
    }

    public <K, V> Map<K, V> readOptionalImmutableMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        boolean present = this.readBoolean();
        return present ? this.readImmutableMap(keyReader, valueReader) : null;
    }

    public <K, V> Map<K, V> readImmutableMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readVInt();
        if (size == 0) {
            return Map.of();
        }
        if (size == 1) {
            return Map.of(keyReader.read(this), valueReader.read(this));
        }
        Map.Entry[] entries = new Map.Entry[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = Map.entry(keyReader.read(this), valueReader.read(this));
        }
        return Map.ofEntries(entries);
    }

    public <K, V> ImmutableOpenMap<K, V> readImmutableOpenMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readVInt();
        if (size == 0) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder<K, V> builder = ImmutableOpenMap.builder(size);
        for (int i = 0; i < size; ++i) {
            builder.put(keyReader.read(this), valueReader.read(this));
        }
        return builder.build();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        return switch (type) {
            case -1 -> null;
            case 0 -> this.readString();
            case 1 -> this.readInt();
            case 2 -> this.readLong();
            case 3 -> Float.valueOf(this.readFloat());
            case 4 -> this.readDouble();
            case 5 -> this.readBoolean();
            case 6 -> this.readByteArray();
            case 7 -> this.readCollection(StreamInput::readGenericValue, ArrayList::new, Collections.emptyList());
            case 8 -> this.readArray();
            case 9 -> {
                if (this.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
                    yield this.readOrderedMap(StreamInput::readGenericValue, StreamInput::readGenericValue);
                }
                yield this.readOrderedMap(StreamInput::readString, StreamInput::readGenericValue);
            }
            case 10 -> {
                if (this.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
                    yield this.readMap(StreamInput::readGenericValue, StreamInput::readGenericValue);
                }
                yield this.readMap(StreamInput::readGenericValue);
            }
            case 11 -> this.readByte();
            case 12 -> this.readDate();
            case 13 -> this.readZonedDateTime();
            case 14 -> this.readBytesReference();
            case 15 -> this.readText();
            case 16 -> this.readShort();
            case 17 -> this.readIntArray();
            case 18 -> this.readLongArray();
            case 19 -> this.readFloatArray();
            case 20 -> this.readDoubleArray();
            case 21 -> this.readBytesRef();
            case 22 -> this.readGeoPoint();
            case 23 -> this.readZonedDateTime();
            case 24 -> this.readCollection(StreamInput::readGenericValue, Sets::newLinkedHashSetWithExpectedSize, Collections.emptySet());
            case 25 -> this.readCollection(StreamInput::readGenericValue, Sets::newHashSetWithExpectedSize, Collections.emptySet());
            case 26 -> this.readBigInteger();
            case 27 -> this.readOffsetTime();
            case 28 -> this.readDuration();
            case 29 -> this.readPeriod();
            case 30 -> this.readNamedWriteable(GenericNamedWriteable.class);
            default -> throw new IOException("Can't read unknown type [" + type + "]");
        };
    }

    public final Instant readInstant() throws IOException {
        return Instant.ofEpochSecond(this.readLong(), this.readInt());
    }

    @Nullable
    public final Instant readOptionalInstant() throws IOException {
        boolean present = this.readBoolean();
        return present ? this.readInstant() : null;
    }

    private ZonedDateTime readZonedDateTime() throws IOException {
        String timeZoneId = this.readString();
        Instant instant = this.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? Instant.ofEpochSecond(this.readZLong(), this.readInt()) : Instant.ofEpochMilli(this.readLong());
        return ZonedDateTime.ofInstant(instant, ZoneId.of(timeZoneId));
    }

    private OffsetTime readOffsetTime() throws IOException {
        String zoneOffsetId = this.readString();
        return OffsetTime.of(LocalTime.ofNanoOfDay(this.readLong()), ZoneOffset.of(zoneOffsetId));
    }

    private Duration readDuration() throws IOException {
        long seconds = this.readLong();
        long nanos = this.readLong();
        return Duration.ofSeconds(seconds, nanos);
    }

    private Period readPeriod() throws IOException {
        int years = this.readInt();
        int months = this.readInt();
        int days = this.readInt();
        return Period.of(years, months, days);
    }

    private Object[] readArray() throws IOException {
        int size8 = this.readArraySize();
        if (size8 == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] list8 = new Object[size8];
        for (int i = 0; i < size8; ++i) {
            list8[i] = this.readGenericValue();
        }
        return list8;
    }

    private Date readDate() throws IOException {
        return new Date(this.readLong());
    }

    public GeoPoint readGeoPoint() throws IOException {
        return new GeoPoint(this.readDouble(), this.readDouble());
    }

    public ZoneId readZoneId() throws IOException {
        return ZoneId.of(this.readString());
    }

    public ZoneId readOptionalZoneId() throws IOException {
        if (this.readBoolean()) {
            return ZoneId.of(this.readString());
        }
        return null;
    }

    public int[] readIntArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt();
        }
        return values;
    }

    public int[] readVIntArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVInt();
        }
        return values;
    }

    public long[] readLongArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readLong();
        }
        return values;
    }

    public long[] readVLongArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVLong();
        }
        return values;
    }

    public float[] readFloatArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] values = new float[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readFloat();
        }
        return values;
    }

    public double[] readDoubleArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDouble();
        }
        return values;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    public <T> T[] readArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        int length = this.readArraySize();
        T[] values = arraySupplier.apply(length);
        for (int i = 0; i < length; ++i) {
            values[i] = reader.read(this);
        }
        return values;
    }

    public <T> T[] readOptionalArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        return this.readBoolean() ? this.readArray(reader, arraySupplier) : null;
    }

    @Nullable
    public <T extends Writeable> T readOptionalWriteable(Writeable.Reader<T> reader) throws IOException {
        return (T)((Writeable)this.readOptional(reader));
    }

    public <T> T readOptional(Writeable.Reader<T> reader) throws IOException {
        if (this.readBoolean()) {
            T t = reader.read(this);
            if (t == null) {
                StreamInput.throwOnNullRead(reader);
            }
            return t;
        }
        return null;
    }

    protected static void throwOnNullRead(Writeable.Reader<?> reader) throws IOException {
        IOException e = new IOException("Writeable.Reader [" + String.valueOf(reader) + "] returned null which is not allowed.");
        assert (false) : e;
        throw e;
    }

    @Nullable
    public <T extends Exception> T readException() throws IOException {
        return (T)((Exception)ElasticsearchException.readException(this));
    }

    @Nullable
    public <T extends Exception> T readOptionalException() throws IOException {
        if (this.readBoolean()) {
            return (T)((Exception)ElasticsearchException.readException(this));
        }
        return null;
    }

    public NamedWriteableRegistry namedWriteableRegistry() {
        return null;
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass, String name) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readOptionalNamedWriteable(Class<C> categoryClass) throws IOException {
        if (this.readBoolean()) {
            return this.readNamedWriteable(categoryClass);
        }
        return null;
    }

    public <T> List<T> readCollectionAsList(Writeable.Reader<T> reader) throws IOException {
        return this.readCollection(reader, ArrayList::new, Collections.emptyList());
    }

    public <T> List<T> readCollectionAsImmutableList(Writeable.Reader<T> reader) throws IOException {
        int count = this.readArraySize();
        return switch (count) {
            case 0 -> List.of();
            case 1 -> List.of(reader.read(this));
            case 2 -> List.of(reader.read(this), reader.read(this));
            default -> {
                Object[] entries = new Object[count];
                for (int i = 0; i < count; ++i) {
                    entries[i] = reader.read(this);
                }
                Object[] typedEntries = entries;
                yield List.of(typedEntries);
            }
        };
    }

    public List<String> readStringCollectionAsImmutableList() throws IOException {
        return this.readCollectionAsImmutableList(StreamInput::readString);
    }

    public List<String> readStringCollectionAsList() throws IOException {
        return this.readCollectionAsList(StreamInput::readString);
    }

    @Nullable
    public <T> List<T> readOptionalCollectionAsList(Writeable.Reader<T> reader) throws IOException {
        boolean isPresent = this.readBoolean();
        return isPresent ? this.readCollectionAsList(reader) : null;
    }

    @Nullable
    public List<String> readOptionalStringCollectionAsList() throws IOException {
        return this.readOptionalCollectionAsList(StreamInput::readString);
    }

    public <T> Set<T> readCollectionAsSet(Writeable.Reader<T> reader) throws IOException {
        return this.readCollection(reader, Sets::newHashSetWithExpectedSize, Collections.emptySet());
    }

    public <T> Set<T> readCollectionAsImmutableSet(Writeable.Reader<T> reader) throws IOException {
        int count = this.readArraySize();
        return switch (count) {
            case 0 -> Set.of();
            case 1 -> Set.of(reader.read(this));
            case 2 -> Set.of(reader.read(this), reader.read(this));
            default -> {
                Object[] entries = new Object[count];
                for (int i = 0; i < count; ++i) {
                    entries[i] = reader.read(this);
                }
                Object[] typedEntries = entries;
                yield Set.of(typedEntries);
            }
        };
    }

    public <T extends NamedWriteable> List<T> readNamedWriteableCollectionAsList(Class<T> categoryClass) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    public <C> C readCollection(IntFunction<C> constructor, CheckedBiConsumer<StreamInput, C, IOException> itemConsumer) throws IOException {
        int count = this.readArraySize();
        C result = constructor.apply(count);
        for (int i = 0; i < count; ++i) {
            itemConsumer.accept(this, result);
        }
        return result;
    }

    private <T, C extends Collection<? super T>> C readCollection(Writeable.Reader<T> reader, IntFunction<C> constructor, C empty) throws IOException {
        int count = this.readArraySize();
        if (count == 0) {
            return empty;
        }
        Collection builder = (Collection)constructor.apply(count);
        for (int i = 0; i < count; ++i) {
            builder.add(reader.read(this));
        }
        assert (builder.size() == count) : Strings.format("read %d items but resulting collection has size %d - were duplicates removed?", count, builder.size());
        return (C)builder;
    }

    public <E extends Enum<E>> E readEnum(Class<E> enumClass) throws IOException {
        return (E)this.readEnum(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    @Nullable
    public <E extends Enum<E>> E readOptionalEnum(Class<E> enumClass) throws IOException {
        if (this.readBoolean()) {
            return (E)this.readEnum(enumClass, (Enum[])enumClass.getEnumConstants());
        }
        return null;
    }

    private <E extends Enum<E>> E readEnum(Class<E> enumClass, E[] values) throws IOException {
        int ordinal = this.readVInt();
        if (ordinal < 0 || ordinal >= values.length) {
            throw new IOException("Unknown " + enumClass.getSimpleName() + " ordinal [" + ordinal + "]");
        }
        return values[ordinal];
    }

    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> enumClass) throws IOException {
        int size = this.readVInt();
        EnumSet<Enum> res = EnumSet.noneOf(enumClass);
        if (size == 0) {
            return res;
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < size; ++i) {
            res.add(this.readEnum(enumClass, values));
        }
        return res;
    }

    public static StreamInput wrap(byte[] bytes) {
        return StreamInput.wrap(bytes, 0, bytes.length);
    }

    public static StreamInput wrap(byte[] bytes, int offset, int length) {
        return new ByteBufferStreamInput(ByteBuffer.wrap(bytes, offset, length));
    }

    protected int readArraySize() throws IOException {
        int arraySize = this.readVInt();
        if (arraySize > ArrayUtil.MAX_ARRAY_LENGTH) {
            StreamInput.throwExceedsMaxArraySize(arraySize);
        }
        if (arraySize < 0) {
            StreamInput.throwNegative(arraySize);
        }
        this.ensureCanReadBytes(arraySize);
        return arraySize;
    }

    private static void throwNegative(int arraySize) {
        throw new NegativeArraySizeException("array size must be positive but was: " + arraySize);
    }

    private static void throwExceedsMaxArraySize(int arraySize) {
        throw new IllegalStateException("array length must be <= to " + ArrayUtil.MAX_ARRAY_LENGTH + " but was: " + arraySize);
    }

    protected abstract void ensureCanReadBytes(int var1) throws EOFException;

    protected static void throwEOF(int bytesToRead, int bytesAvailable) throws EOFException {
        throw new EOFException("tried to read: " + bytesToRead + " bytes but only " + bytesAvailable + " remaining");
    }

    public TimeValue readTimeValue() throws IOException {
        long duration = this.readZLong();
        TimeUnit timeUnit = TIME_UNITS[this.readByte()];
        return switch (timeUnit) {
            case TimeUnit.MILLISECONDS -> TimeValue.timeValueMillis((long)duration);
            case TimeUnit.SECONDS -> TimeValue.timeValueSeconds((long)duration);
            case TimeUnit.MINUTES -> TimeValue.timeValueMinutes((long)duration);
            default -> new TimeValue(duration, timeUnit);
        };
    }

    @Nullable
    public TimeValue readOptionalTimeValue() throws IOException {
        if (this.readBoolean()) {
            return this.readTimeValue();
        }
        return null;
    }

    static {
        if (!Arrays.equals((Object[])TIME_UNITS, (Object[])new TimeUnit[]{TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS})) {
            throw new AssertionError((Object)"Incompatible JDK version used that breaks assumptions on the structure of the TimeUnit enum");
        }
    }
}

