/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.common.util.set.Sets;

public record EsqlResolvedIndexExpression(Set<String> expression, Set<String> resolved) {
    private static final EsqlResolvedIndexExpression EMPTY = new EsqlResolvedIndexExpression(Set.of(), Set.of());

    public static Map<String, EsqlResolvedIndexExpression> from(FieldCapabilitiesResponse response) {
        return Stream.concat(Stream.of(Map.entry("", response.getResolvedLocally())), response.getResolvedRemotely().entrySet().stream()).map(entry -> Map.entry((String)entry.getKey(), ((ResolvedIndexExpressions)entry.getValue()).expressions().stream().filter(e -> !e.localExpressions().indices().isEmpty()).filter(e -> e.localExpressions().localIndexResolutionResult() == ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS).map(e -> new EsqlResolvedIndexExpression(Set.of(e.original()), e.localExpressions().indices())).reduce(EMPTY, EsqlResolvedIndexExpression::merge))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static EsqlResolvedIndexExpression merge(EsqlResolvedIndexExpression a, EsqlResolvedIndexExpression b) {
        return new EsqlResolvedIndexExpression(Sets.union(a.expression(), b.expression()), Sets.union(a.resolved(), b.resolved()));
    }
}

