/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.stats.CCSUsage;
import org.elasticsearch.action.admin.cluster.stats.CCSUsageTelemetry;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.compute.data.BlockFactoryProvider;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryAction;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.action.EsqlQueryTask;
import org.elasticsearch.xpack.esql.analysis.AnalyzerSettings;
import org.elasticsearch.xpack.esql.core.async.AsyncTaskManagementService;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.execution.PlanExecutor;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.inference.InferenceService;
import org.elasticsearch.xpack.esql.planner.PlannerSettings;
import org.elasticsearch.xpack.esql.plugin.ComputeService;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;
import org.elasticsearch.xpack.esql.plugin.EsqlQueryStatus;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;
import org.elasticsearch.xpack.esql.session.EsqlSession;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.session.Versioned;

public class TransportEsqlQueryAction
extends HandledTransportAction<EsqlQueryRequest, EsqlQueryResponse>
implements AsyncTaskManagementService.AsyncOperation<EsqlQueryRequest, EsqlQueryResponse, EsqlQueryTask> {
    private final ThreadPool threadPool;
    private final PlanExecutor planExecutor;
    private final ComputeService computeService;
    private final ExchangeService exchangeService;
    private final ClusterService clusterService;
    private final Executor requestExecutor;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final EnrichLookupService enrichLookupService;
    private final LookupFromIndexService lookupFromIndexService;
    private final AsyncTaskManagementService<EsqlQueryRequest, EsqlQueryResponse, EsqlQueryTask> asyncTaskManagementService;
    private final RemoteClusterService remoteClusterService;
    private final UsageService usageService;
    private final TransportActionServices services;
    private volatile boolean defaultAllowPartialResults;
    private volatile int resultTruncationMaxSize;
    private volatile int resultTruncationDefaultSize;
    private volatile int timeseriesResultTruncationMaxSize;
    private volatile int timeseriesResultTruncationDefaultSize;

    @Inject
    public TransportEsqlQueryAction(TransportService transportService, ActionFilters actionFilters, PlanExecutor planExecutor, SearchService searchService, ExchangeService exchangeService, ClusterService clusterService, ProjectResolver projectResolver, ThreadPool threadPool, BigArrays bigArrays, BlockFactoryProvider blockFactoryProvider, Client client, NamedWriteableRegistry registry, IndexNameExpressionResolver indexNameExpressionResolver, UsageService usageService) {
        super("indices:data/read/esql", transportService, actionFilters, EsqlQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.planExecutor = planExecutor;
        this.clusterService = clusterService;
        this.requestExecutor = threadPool.executor("search");
        exchangeService.registerTransportHandler(transportService);
        this.exchangeService = exchangeService;
        this.enrichPolicyResolver = new EnrichPolicyResolver(clusterService, transportService, planExecutor.indexResolver(), projectResolver);
        AbstractLookupService.LookupShardContextFactory lookupLookupShardContextFactory = AbstractLookupService.LookupShardContextFactory.fromSearchService(searchService);
        this.enrichLookupService = new EnrichLookupService(clusterService, searchService.getIndicesService(), lookupLookupShardContextFactory, transportService, indexNameExpressionResolver, bigArrays, blockFactoryProvider.blockFactory(), projectResolver);
        this.lookupFromIndexService = new LookupFromIndexService(clusterService, searchService.getIndicesService(), lookupLookupShardContextFactory, transportService, indexNameExpressionResolver, bigArrays, blockFactoryProvider.blockFactory(), projectResolver);
        this.asyncTaskManagementService = new AsyncTaskManagementService(".async-search", client, "async_search", registry, this.taskManager, EsqlQueryAction.INSTANCE.name(), (AsyncTaskManagementService.AsyncOperation)this, EsqlQueryTask.class, clusterService, threadPool, bigArrays);
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.usageService = usageService;
        this.services = new TransportActionServices(transportService, searchService, exchangeService, clusterService, projectResolver, indexNameExpressionResolver, usageService, new InferenceService(client), blockFactoryProvider, new PlannerSettings(clusterService), new CrossProjectModeDecider(clusterService.getSettings()));
        this.computeService = new ComputeService(this.services, this.enrichLookupService, this.lookupFromIndexService, threadPool, bigArrays, blockFactoryProvider.blockFactory());
        this.defaultAllowPartialResults = (Boolean)EsqlPlugin.QUERY_ALLOW_PARTIAL_RESULTS.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EsqlPlugin.QUERY_ALLOW_PARTIAL_RESULTS, v -> {
            this.defaultAllowPartialResults = v;
        });
        this.resultTruncationMaxSize = (Integer)AnalyzerSettings.QUERY_RESULT_TRUNCATION_MAX_SIZE.get(clusterService.getSettings());
        this.resultTruncationDefaultSize = (Integer)AnalyzerSettings.QUERY_RESULT_TRUNCATION_DEFAULT_SIZE.get(clusterService.getSettings());
        this.timeseriesResultTruncationMaxSize = (Integer)AnalyzerSettings.QUERY_TIMESERIES_RESULT_TRUNCATION_MAX_SIZE.get(clusterService.getSettings());
        this.timeseriesResultTruncationDefaultSize = (Integer)AnalyzerSettings.QUERY_TIMESERIES_RESULT_TRUNCATION_DEFAULT_SIZE.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnalyzerSettings.QUERY_RESULT_TRUNCATION_MAX_SIZE, v -> {
            this.resultTruncationMaxSize = v;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnalyzerSettings.QUERY_RESULT_TRUNCATION_DEFAULT_SIZE, v -> {
            this.resultTruncationDefaultSize = v;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnalyzerSettings.QUERY_TIMESERIES_RESULT_TRUNCATION_MAX_SIZE, v -> {
            this.timeseriesResultTruncationMaxSize = v;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnalyzerSettings.QUERY_TIMESERIES_RESULT_TRUNCATION_DEFAULT_SIZE, v -> {
            this.timeseriesResultTruncationDefaultSize = v;
        });
    }

    protected void doExecute(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        this.requestExecutor.execute((Runnable)ActionRunnable.wrap((ActionListener)listener.delegateFailureAndWrap(ActionListener::respondAndRelease), l -> this.doExecuteForked(task, request, (ActionListener<EsqlQueryResponse>)l)));
    }

    private void doExecuteForked(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search"}));
        if (TransportEsqlQueryAction.requestIsAsync(request)) {
            this.asyncTaskManagementService.asyncExecute((TaskAwareRequest)request, request.waitForCompletionTimeout(), request.keepOnCompletion(), listener);
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    public void execute(EsqlQueryRequest request, EsqlQueryTask task, ActionListener<EsqlQueryResponse> listener) {
        task.setExecutionInfo(this.createEsqlExecutionInfo(request));
        ActionListener.run(listener, l -> this.innerExecute((Task)task, request, (ActionListener<EsqlQueryResponse>)l));
    }

    private void innerExecute(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        if (request.allowPartialResults() == null) {
            request.allowPartialResults(this.defaultAllowPartialResults);
        }
        TransportVersion localMinimumVersion = this.clusterService.state().getMinTransportVersion();
        EsqlFlags flags = this.computeService.createFlags();
        String sessionId = this.sessionID(task);
        EsqlExecutionInfo executionInfo = this.getOrCreateExecutionInfo(task, request);
        EsqlSession.PlanRunner planRunner = (plan, configuration, foldCtx, resultListener) -> this.computeService.execute(sessionId, (CancellableTask)task, flags, plan, configuration, foldCtx, executionInfo, (ActionListener<Result>)resultListener);
        this.planExecutor.esql(request, sessionId, localMinimumVersion, new AnalyzerSettings(this.resultTruncationMaxSize, this.resultTruncationDefaultSize, this.timeseriesResultTruncationMaxSize, this.timeseriesResultTruncationDefaultSize), this.enrichPolicyResolver, executionInfo, (IndicesExpressionGrouper)this.remoteClusterService, planRunner, this.services, (ActionListener<Versioned<Result>>)ActionListener.wrap(result -> {
            this.recordCCSTelemetry(task, executionInfo, request, null);
            this.planExecutor.metrics().recordTook(executionInfo.overallTook().millis());
            EsqlQueryResponse response = this.toResponse(task, request, request.profile(), (Versioned<Result>)result);
            assert (response.isAsync() == request.async()) : "The response must be async if the request was async";
            if (response.isAsync()) {
                if (response.asyncExecutionId().isPresent()) {
                    String asyncExecutionId = response.asyncExecutionId().get();
                    this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Id", asyncExecutionId);
                }
                boolean isRunning = response.isRunning();
                this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Is-Running", isRunning ? "?1" : "?0");
            }
            listener.onResponse((Object)response);
        }, ex -> {
            this.recordCCSTelemetry(task, executionInfo, request, (Exception)ex);
            listener.onFailure(ex);
        }));
    }

    private void recordCCSTelemetry(Task task, EsqlExecutionInfo executionInfo, EsqlQueryRequest request, @Nullable Exception exception) {
        TimeValue took;
        if (!executionInfo.isCrossClusterSearch() && executionInfo.includeExecutionMetadata() != EsqlExecutionInfo.IncludeExecutionMetadata.ALWAYS) {
            return;
        }
        CCSUsage.Builder usageBuilder = new CCSUsage.Builder();
        usageBuilder.setClientFromTask(task);
        if (exception != null) {
            if (exception instanceof VerificationException) {
                VerificationException ve = (VerificationException)((Object)exception);
                CCSUsageTelemetry.Result failureType = this.classifyVerificationException(ve);
                if (failureType != CCSUsageTelemetry.Result.UNKNOWN) {
                    usageBuilder.setFailure(failureType);
                } else {
                    usageBuilder.setFailure(exception);
                }
            } else {
                usageBuilder.setFailure(exception);
            }
        }
        if ((took = executionInfo.overallTook()) != null) {
            usageBuilder.took(took.getMillis());
        }
        if (request.async()) {
            usageBuilder.setFeature("async");
        }
        AtomicInteger remotesCount = new AtomicInteger();
        executionInfo.getClusters().forEach((clusterAlias, cluster) -> {
            if (cluster.getStatus() == EsqlExecutionInfo.Cluster.Status.SKIPPED) {
                usageBuilder.skippedRemote(clusterAlias);
            } else {
                usageBuilder.perClusterUsage(clusterAlias, cluster.getTook());
            }
            if (!clusterAlias.equals("")) {
                remotesCount.getAndIncrement();
            }
        });
        if (remotesCount.get() == 0) {
            return;
        }
        usageBuilder.setRemotesCount(remotesCount.get());
        this.usageService.getEsqlUsageHolder().updateUsage(usageBuilder.build());
    }

    private CCSUsageTelemetry.Result classifyVerificationException(VerificationException exception) {
        if (exception.getDetailedMessage().contains("Unknown index")) {
            return CCSUsageTelemetry.Result.NOT_FOUND;
        }
        return CCSUsageTelemetry.Result.UNKNOWN;
    }

    private EsqlExecutionInfo getOrCreateExecutionInfo(Task task, EsqlQueryRequest request) {
        EsqlQueryTask esqlQueryTask;
        if (task instanceof EsqlQueryTask && (esqlQueryTask = (EsqlQueryTask)task).executionInfo() != null) {
            return esqlQueryTask.executionInfo();
        }
        return this.createEsqlExecutionInfo(request);
    }

    private EsqlExecutionInfo createEsqlExecutionInfo(EsqlQueryRequest request) {
        if (request.includeCCSMetadata() != null && request.includeExecutionMetadata() != null) {
            throw new VerificationException("Both [include_execution_metadata] and [include_ccs_metadata] query parameters are set. Use only one", new Object[0]);
        }
        EsqlExecutionInfo.IncludeExecutionMetadata includeExecutionMetadata = Boolean.TRUE.equals(request.includeExecutionMetadata()) ? EsqlExecutionInfo.IncludeExecutionMetadata.ALWAYS : (Boolean.TRUE.equals(request.includeCCSMetadata()) ? EsqlExecutionInfo.IncludeExecutionMetadata.CCS_ONLY : EsqlExecutionInfo.IncludeExecutionMetadata.NEVER);
        Boolean allowPartialResults = request.allowPartialResults() != null ? request.allowPartialResults() : this.defaultAllowPartialResults;
        return new EsqlExecutionInfo(clusterAlias -> this.remoteClusterService.shouldSkipOnFailure(clusterAlias, allowPartialResults), includeExecutionMetadata);
    }

    private EsqlQueryResponse toResponse(Task task, EsqlQueryRequest request, boolean profileEnabled, Versioned<Result> result) {
        EsqlQueryResponse.Profile profile;
        Result innerResult = result.inner();
        List<ColumnInfoImpl> columns = innerResult.schema().stream().map(c -> {
            ArrayList<String> originalTypes;
            if (c instanceof UnsupportedAttribute) {
                UnsupportedAttribute ua = (UnsupportedAttribute)((Object)c);
                originalTypes = new ArrayList<String>(ua.originalTypes());
                Collections.sort(originalTypes);
            } else {
                originalTypes = null;
            }
            return new ColumnInfoImpl(c.name(), c.dataType().outputType(), originalTypes);
        }).toList();
        EsqlQueryResponse.Profile profile2 = profile = profileEnabled ? new EsqlQueryResponse.Profile(innerResult.completionInfo().driverProfiles(), innerResult.completionInfo().planProfiles(), result.minimumVersion()) : null;
        if (task instanceof EsqlQueryTask) {
            EsqlQueryTask asyncTask = (EsqlQueryTask)task;
            if (request.keepOnCompletion()) {
                String asyncExecutionId = asyncTask.getExecutionId().getEncoded();
                return new EsqlQueryResponse(columns, innerResult.pages(), innerResult.completionInfo().documentsFound(), innerResult.completionInfo().valuesLoaded(), profile, request.columnar(), asyncExecutionId, false, request.async(), task.getStartTime(), ((EsqlQueryTask)task).getExpirationTimeMillis(), innerResult.executionInfo());
            }
        }
        return new EsqlQueryResponse(columns, innerResult.pages(), innerResult.completionInfo().documentsFound(), innerResult.completionInfo().valuesLoaded(), profile, request.columnar(), request.async(), task.getStartTime(), this.threadPool.absoluteTimeInMillis() + request.keepAlive().millis(), innerResult.executionInfo());
    }

    final String sessionID(Task task) {
        return new TaskId(this.clusterService.localNode().getId(), task.getId()).toString();
    }

    public ExchangeService exchangeService() {
        return this.exchangeService;
    }

    public EnrichLookupService enrichLookupService() {
        return this.enrichLookupService;
    }

    public EsqlQueryTask createTask(EsqlQueryRequest request, long id, String type, String action, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, final AsyncExecutionId asyncExecutionId) {
        return new EsqlQueryTask(this, id, type, action, request.query(), parentTaskId, headers, originHeaders, asyncExecutionId, request.keepAlive()){

            public Task.Status getStatus() {
                return new EsqlQueryStatus(asyncExecutionId);
            }
        };
    }

    public EsqlQueryResponse initialResponse(EsqlQueryTask task) {
        String asyncExecutionId = task.getExecutionId().getEncoded();
        this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Id", asyncExecutionId);
        this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Is-Running", "?1");
        return new EsqlQueryResponse(List.of(), List.of(), 0L, 0L, null, false, asyncExecutionId, true, true, task.getStartTime(), task.getExpirationTimeMillis(), task.executionInfo());
    }

    public EsqlQueryResponse readResponse(StreamInput inputStream) throws IOException {
        throw new AssertionError((Object)"should not reach here");
    }

    private static boolean requestIsAsync(EsqlQueryRequest request) {
        return request.async();
    }

    public LookupFromIndexService getLookupFromIndexService() {
        return this.lookupFromIndexService;
    }
}

