/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexReshardService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.xpack.core.security.authz.IndicesAndAliasesResolverField;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.session.Configuration;

final class DataNodeRequest
extends AbstractTransportRequest
implements IndicesRequest.Replaceable {
    private static final TransportVersion REDUCE_LATE_MATERIALIZATION = TransportVersion.fromName((String)"esql_reduce_late_materialization");
    private static final Logger logger = LogManager.getLogger(DataNodeRequest.class);
    private final String sessionId;
    private final Configuration configuration;
    private final String clusterAlias;
    private final Map<Index, AliasFilter> aliasFilters;
    private final PhysicalPlan plan;
    private List<Shard> shards;
    private String[] indices;
    private final IndicesOptions indicesOptions;
    private final boolean runNodeLevelReduction;
    private final boolean reductionLateMaterialization;

    DataNodeRequest(String sessionId, Configuration configuration, String clusterAlias, List<Shard> shards, Map<Index, AliasFilter> aliasFilters, PhysicalPlan plan, String[] indices, IndicesOptions indicesOptions, boolean runNodeLevelReduction, boolean reductionLateMaterialization) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.clusterAlias = clusterAlias;
        this.shards = shards;
        this.aliasFilters = aliasFilters;
        this.plan = plan;
        this.indices = indices;
        this.indicesOptions = indicesOptions;
        this.runNodeLevelReduction = runNodeLevelReduction;
        this.reductionLateMaterialization = reductionLateMaterialization;
    }

    DataNodeRequest(StreamInput in) throws IOException {
        this(in, null);
    }

    DataNodeRequest(StreamInput in, PlanStreamInput.NameIdMapper idMapper) throws IOException {
        super(in);
        this.sessionId = in.readString();
        this.configuration = new Configuration(new BlockStreamInput(in, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE)));
        this.clusterAlias = in.readString();
        this.shards = in.getTransportVersion().supports(IndexReshardService.RESHARDING_SHARD_SUMMARY_IN_ESQL) ? in.readCollectionAsList(Shard::new) : in.readCollectionAsList(i -> new Shard(new ShardId(i), SplitShardCountSummary.UNSET));
        this.aliasFilters = in.readMap(Index::new, AliasFilter::readFrom);
        PlanStreamInput pin = new PlanStreamInput(in, in.namedWriteableRegistry(), this.configuration, idMapper);
        this.plan = (PhysicalPlan)pin.readNamedWriteable(PhysicalPlan.class);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        this.runNodeLevelReduction = in.readBoolean();
        this.reductionLateMaterialization = in.getTransportVersion().onOrAfter((VersionId)REDUCE_LATE_MATERIALIZATION) ? in.readBoolean() : false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sessionId);
        this.configuration.writeTo(out);
        out.writeString(this.clusterAlias);
        if (out.getTransportVersion().supports(IndexReshardService.RESHARDING_SHARD_SUMMARY_IN_ESQL)) {
            out.writeCollection(this.shards);
        } else {
            out.writeCollection(this.shards, (o, s) -> s.shardId().writeTo(o));
        }
        out.writeMap(this.aliasFilters);
        new PlanStreamOutput(out, this.configuration).writeNamedWriteable((NamedWriteable)this.plan);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBoolean(this.runNodeLevelReduction);
        if (out.getTransportVersion().onOrAfter((VersionId)REDUCE_LATE_MATERIALIZATION)) {
            out.writeBoolean(this.reductionLateMaterialization);
        }
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesRequest indices(String ... indices) {
        this.indices = indices;
        if (Arrays.equals(IndicesAndAliasesResolverField.NO_INDICES_OR_ALIASES_ARRAY, indices) || Arrays.asList(indices).contains("-*")) {
            logger.trace(() -> Strings.format((String)"Indices empty after index resolution, also clearing shardIds %s", (Object[])new Object[]{this.shards}));
            this.shards = Collections.emptyList();
        }
        return this;
    }

    public boolean includeDataStreams() {
        return true;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        if (!parentTaskId.isSet()) {
            assert (false) : "DataNodeRequest must have a parent task";
            throw new IllegalStateException("DataNodeRequest must have a parent task");
        }
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            public String getDescription() {
                return DataNodeRequest.this.getDescription();
            }
        };
    }

    String sessionId() {
        return this.sessionId;
    }

    Configuration configuration() {
        return this.configuration;
    }

    QueryPragmas pragmas() {
        return this.configuration.pragmas();
    }

    String clusterAlias() {
        return this.clusterAlias;
    }

    List<Shard> shards() {
        return this.shards;
    }

    Map<Index, AliasFilter> aliasFilters() {
        return this.aliasFilters;
    }

    PhysicalPlan plan() {
        return this.plan;
    }

    boolean runNodeLevelReduction() {
        return this.runNodeLevelReduction;
    }

    boolean reductionLateMaterialization() {
        return this.reductionLateMaterialization;
    }

    public String getDescription() {
        return "shards=" + String.valueOf(this.shards) + " plan=" + String.valueOf((Object)this.plan);
    }

    public String toString() {
        return "DataNodeRequest{" + this.getDescription() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DataNodeRequest request = (DataNodeRequest)((Object)o);
        return this.sessionId.equals(request.sessionId) && this.configuration.equals(request.configuration) && this.clusterAlias.equals(request.clusterAlias) && this.shards.equals(request.shards) && this.aliasFilters.equals(request.aliasFilters) && this.plan.equals((Object)request.plan) && this.getParentTask().equals((Object)request.getParentTask()) && Arrays.equals(this.indices, request.indices) && this.indicesOptions.equals((Object)request.indicesOptions) && this.runNodeLevelReduction == request.runNodeLevelReduction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionId, this.configuration, this.clusterAlias, this.shards, this.aliasFilters, this.plan, Arrays.hashCode(this.indices), this.indicesOptions, this.runNodeLevelReduction});
    }

    public DataNodeRequest withPlan(ExchangeSinkExec newPlan) {
        return new DataNodeRequest(this.sessionId, this.configuration, this.clusterAlias, this.shards, this.aliasFilters, newPlan, this.indices, this.indicesOptions, this.runNodeLevelReduction, this.reductionLateMaterialization);
    }

    public record Shard(ShardId shardId, SplitShardCountSummary reshardSplitShardCountSummary) implements Writeable
    {
        Shard(StreamInput in) throws IOException {
            this(new ShardId(in), new SplitShardCountSummary(in));
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.shardId.writeTo(out);
            this.reshardSplitShardCountSummary.writeTo(out);
        }
    }
}

