/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.operator.comparison;

import java.util.Objects;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.VectorBinaryOperator;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.VectorMatch;

public class VectorBinaryComparison
extends VectorBinaryOperator {
    private final ComparisonOp op;
    private final boolean boolMode;

    public VectorBinaryComparison(Source source, LogicalPlan left, LogicalPlan right, VectorMatch match, boolean boolMode, ComparisonOp op) {
        super(source, left, right, match, !boolMode, op);
        this.op = op;
        this.boolMode = boolMode;
    }

    public ComparisonOp op() {
        return this.op;
    }

    public boolean boolMode() {
        return this.boolMode;
    }

    @Override
    public VectorBinaryOperator replaceChildren(LogicalPlan newLeft, LogicalPlan newRight) {
        return new VectorBinaryComparison(this.source(), newLeft, newRight, this.match(), this.boolMode, this.op());
    }

    protected NodeInfo<VectorBinaryComparison> info() {
        return NodeInfo.create((Node)this, VectorBinaryComparison::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)this.match(), (Object)this.boolMode(), (Object)this.op());
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            VectorBinaryComparison that = (VectorBinaryComparison)((Object)o);
            return this.boolMode == that.boolMode;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.boolMode);
    }

    public static enum ComparisonOp implements VectorBinaryOperator.BinaryOp
    {
        EQ,
        NEQ,
        GT,
        GTE,
        LT,
        LTE;


        @Override
        public VectorBinaryOperator.ScalarFunctionFactory asFunction() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Equals::new;
                case 1 -> NotEquals::new;
                case 2 -> GreaterThan::new;
                case 3 -> GreaterThanOrEqual::new;
                case 4 -> LessThan::new;
                case 5 -> LessThanOrEqual::new;
            };
        }
    }
}

