/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.StdDev;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class StdDevOverTime
extends TimeSeriesAggregateFunction {
    @FunctionInfo(returnType={"double"}, description="Calculates the population standard deviation over time of a numeric field.", type=FunctionType.TIME_SERIES_AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="stddev_over_time")})
    public StdDevOverTime(Source source, @Param(name="number", type={"double", "integer", "long"}, description="Expression that outputs values to calculate the standard deviation of.") Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW);
    }

    public StdDevOverTime(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("StdDevOverTime does not have a writeable name");
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    protected NodeInfo<StdDevOverTime> info() {
        return NodeInfo.create((Node)this, StdDevOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    public StdDevOverTime replaceChildren(List<Expression> newChildren) {
        return new StdDevOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public StdDevOverTime withFilter(Expression filter) {
        return new StdDevOverTime(this.source(), this.field(), filter, this.window());
    }

    @Override
    public AggregateFunction perTimeSeriesAggregation() {
        return new StdDev(this.source(), this.field(), this.filter(), this.window());
    }
}

