/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class OpenIndexStep
extends AsyncActionStep {
    static final String NAME = "open-index";

    OpenIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            OpenIndexRequest request = (OpenIndexRequest)new OpenIndexRequest(new String[]{indexMetadata.getIndex().getName()}).masterNodeTimeout(TimeValue.MAX_VALUE);
            this.getClient(currentState.projectId()).admin().indices().open(request, listener.delegateFailureAndWrap((l, openIndexResponse) -> {
                if (!openIndexResponse.isAcknowledged()) {
                    throw new ElasticsearchException("open index request failed to be acknowledged", new Object[0]);
                }
                l.onResponse(null);
            }));
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

