/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperTestCase;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.NumberTypeOutOfRangeSpec;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class NumberFieldMapperTests
extends MapperTestCase {
    protected abstract List<NumberTypeOutOfRangeSpec> outOfRangeSpecs();

    protected abstract Number missingValue();

    protected boolean allowsIndexTimeScript() {
        return false;
    }

    @Override
    protected void registerParameters(MapperTestCase.ParameterChecker checker) throws IOException {
        checker.registerConflictCheck("doc_values", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("doc_values", false)));
        checker.registerConflictCheck("index", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("index", false)));
        checker.registerConflictCheck("store", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("store", true)));
        checker.registerConflictCheck("null_value", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("null_value", 1)));
        checker.registerUpdateCheck((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("coerce", false)), m -> NumberFieldMapperTests.assertFalse((boolean)((NumberFieldMapper)m).coerce()));
        if (this.allowsIndexTimeScript()) {
            checker.registerConflictCheck("script", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("script", "foo")));
            checker.registerUpdateCheck((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("script", "test");
                b.field("on_script_error", "fail");
            }), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("script", "test");
                b.field("on_script_error", "continue");
            }), m -> NumberFieldMapperTests.assertThat(m.builderParams.onScriptError(), Matchers.is((Object)OnScriptError.CONTINUE)));
        }
    }

    @Override
    protected Object getSampleValueForDocument() {
        return 123;
    }

    public void testExistsQueryDocValuesDisabled() throws IOException {
        MapperService mapperService = this.createMapperService(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", false);
        })));
        this.assertExistsQuery(mapperService);
        this.assertParseMinimalWarnings();
    }

    public void testAggregationsDocValuesDisabled() throws IOException {
        MapperService mapperService = this.createMapperService(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", false);
        })));
        this.assertAggregatableConsistency(mapperService.fieldType("field"));
    }

    public void testDefaults() throws Exception {
        XContentBuilder mapping = NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping));
        DocumentMapper mapper = this.createDocumentMapper(mapping);
        NumberFieldMapperTests.assertEquals((Object)Strings.toString((XContentBuilder)mapping), (Object)mapper.mappingSource().toString());
        ParsedDocument doc = mapper.parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", 123))));
        List fields = doc.rootDoc().getFields("field");
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.stream().filter(f -> f.fieldType().pointIndexDimensionCount() != 0).count());
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.stream().filter(f -> f.fieldType().docValuesType() != DocValuesType.NONE).count());
    }

    public void testNotIndexed() throws Exception {
        DocumentMapper mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("index", false);
        })));
        ParsedDocument doc = mapper.parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", 123))));
        List fields = doc.rootDoc().getFields("field");
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.size());
        IndexableField dvField = (IndexableField)fields.get(0);
        NumberFieldMapperTests.assertEquals((Object)DocValuesType.SORTED_NUMERIC, (Object)dvField.fieldType().docValuesType());
    }

    public void testNoDocValues() throws Exception {
        DocumentMapper mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", false);
        })));
        ParsedDocument doc = mapper.parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", 123))));
        List fields = doc.rootDoc().getFields("field");
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.size());
        IndexableField pointField = (IndexableField)fields.get(0);
        NumberFieldMapperTests.assertEquals((long)1L, (long)pointField.fieldType().pointIndexDimensionCount());
        NumberFieldMapperTests.assertEquals((double)123.0, (double)pointField.numericValue().doubleValue(), (double)0.0);
    }

    public void testStore() throws Exception {
        DocumentMapper mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("store", true);
        })));
        ParsedDocument doc = mapper.parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", 123))));
        List fields = doc.rootDoc().getFields("field");
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.stream().filter(f -> f.fieldType().pointIndexDimensionCount() != 0).count());
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.stream().filter(f -> f.fieldType().docValuesType() != DocValuesType.NONE).count());
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.stream().filter(f -> f.fieldType().stored()).count());
    }

    public void testCoerce() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        ParsedDocument doc = mapper.parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", "123"))));
        List fields = doc.rootDoc().getFields("field");
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.stream().filter(f -> f.fieldType().pointIndexDimensionCount() != 0).count());
        NumberFieldMapperTests.assertEquals((long)1L, (long)fields.stream().filter(f -> f.fieldType().docValuesType() != DocValuesType.NONE).count());
        DocumentMapper mapper2 = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("coerce", false);
        })));
        Exception e = (Exception)NumberFieldMapperTests.expectThrows(DocumentParsingException.class, () -> mapper2.parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", "123")))));
        NumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"passed as String"));
    }

    @Override
    protected boolean supportsIgnoreMalformed() {
        return true;
    }

    @Override
    protected List<MapperTestCase.ExampleMalformedValue> exampleMalformedValues() {
        return List.of(this.exampleMalformedValue("a").errorMatches("For input string: \"a\""), this.exampleMalformedValue((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(false))).errorMatches((Matcher<String>)Matchers.both((Matcher)Matchers.containsString((String)"Current token")).and(Matchers.containsString((String)"not numeric, can not use numeric value accessors"))));
    }

    public void testIgnoreMalformedWithObject() throws Exception {
        SourceToParse malformed = NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startObject("field").field("foo", "bar").endObject()));
        for (Boolean ignoreMalformed : new Boolean[]{true, false}) {
            DocumentMapper mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("ignore_malformed", ignoreMalformed);
            })));
            DocumentParsingException e = (DocumentParsingException)NumberFieldMapperTests.expectThrows(DocumentParsingException.class, () -> mapper.parse(malformed));
            NumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Cannot parse object as number"));
        }
    }

    public void testNullValue() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        SourceToParse source = NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.nullField("field")));
        ParsedDocument doc = mapper.parse(source);
        NumberFieldMapperTests.assertThat(doc.rootDoc().getFields("field"), Matchers.empty());
        Number missing = this.missingValue();
        mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("null_value", missing);
        })));
        doc = mapper.parse(source);
        List fields = doc.rootDoc().getFields("field");
        List<IndexableField> pointFields = fields.stream().filter(f -> f.fieldType().pointIndexDimensionCount() != 0).toList();
        NumberFieldMapperTests.assertEquals((long)1L, (long)pointFields.size());
        NumberFieldMapperTests.assertEquals((long)1L, (long)pointFields.get(0).fieldType().pointIndexDimensionCount());
        NumberFieldMapperTests.assertFalse((boolean)pointFields.get(0).fieldType().stored());
        List<IndexableField> dvFields = fields.stream().filter(f -> f.fieldType().docValuesType() != DocValuesType.NONE).toList();
        NumberFieldMapperTests.assertEquals((long)1L, (long)dvFields.size());
        NumberFieldMapperTests.assertEquals((Object)DocValuesType.SORTED_NUMERIC, (Object)dvFields.get(0).fieldType().docValuesType());
        NumberFieldMapperTests.assertFalse((boolean)dvFields.get(0).fieldType().stored());
    }

    public void testOutOfRangeValues() throws IOException {
        for (NumberTypeOutOfRangeSpec item : this.outOfRangeSpecs()) {
            DocumentMapper mapper = this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("type", item.type.typeName()))));
            Exception e = (Exception)NumberFieldMapperTests.expectThrows(DocumentParsingException.class, () -> mapper.parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)item::write))));
            NumberFieldMapperTests.assertThat("Incorrect error message for [" + String.valueOf(item.type) + "] with value [" + String.valueOf(item.value) + "]", e.getCause().getMessage(), Matchers.containsString((String)item.message));
        }
    }

    public void testDimension() throws IOException {
        MapperService mapperService = this.createMapperService(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> this.minimalMapping((XContentBuilder)b))));
        NumberFieldMapper.NumberFieldType ft = (NumberFieldMapper.NumberFieldType)mapperService.fieldType("field");
        NumberFieldMapperTests.assertFalse((boolean)ft.isDimension());
        this.assertDimension(false, NumberFieldMapper.NumberFieldType::isDimension);
        this.assertDimension(true, NumberFieldMapper.NumberFieldType::isDimension);
        this.assertTimeSeriesIndexing();
    }

    public void testMetricType() throws IOException {
        MapperService mapperService = this.createMapperService(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        NumberFieldMapper.NumberFieldType ft = (NumberFieldMapper.NumberFieldType)mapperService.fieldType("field");
        NumberFieldMapperTests.assertNull((Object)ft.getMetricType());
        this.assertMetricType("gauge", NumberFieldMapper.NumberFieldType::getMetricType);
        this.assertMetricType("counter", NumberFieldMapper.NumberFieldType::getMetricType);
        Exception e = (Exception)NumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createMapperService(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_metric", "histogram");
        }))));
        NumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Unknown value [histogram] for field [time_series_metric] - accepted values are [gauge, counter]"));
        e = (Exception)NumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createMapperService(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_metric", "unknown");
        }))));
        NumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Unknown value [unknown] for field [time_series_metric] - accepted values are [gauge, counter]"));
    }

    public void testTimeSeriesIndexDefault() throws Exception {
        TimeSeriesParams.MetricType randomMetricType = NumberFieldMapperTests.randomFrom(TimeSeriesParams.MetricType.scalar());
        Settings.Builder indexSettings = this.getIndexSettingsBuilder().put(IndexSettings.MODE.getKey(), IndexMode.TIME_SERIES.getName()).put(IndexMetadata.INDEX_ROUTING_PATH.getKey(), "dimension_field");
        MapperService mapperService = this.createMapperService(indexSettings.build(), NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_metric", randomMetricType.toString());
        })));
        NumberFieldMapper.NumberFieldType ft = (NumberFieldMapper.NumberFieldType)mapperService.fieldType("field");
        NumberFieldMapperTests.assertThat(ft.getMetricType(), Matchers.equalTo((Object)randomMetricType));
        NumberFieldMapperTests.assertTrue((boolean)ft.indexType().hasOnlyDocValues());
    }

    public void testMetricAndDocvalues() {
        Exception e = (Exception)NumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_metric", "counter").field("doc_values", false);
        }))));
        NumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Field [time_series_metric] requires that [doc_values] is true"));
    }

    @Override
    protected Object generateRandomInputValue(MappedFieldType ft) {
        Number n = this.randomNumber();
        return NumberFieldMapperTests.randomBoolean() ? n : n.toString();
    }

    @Override
    protected MapperTestCase.IngestScriptSupport ingestScriptSupport() {
        return new MapperTestCase.IngestScriptSupport(this){

            @Override
            protected <T> T compileOtherScript(Script script, ScriptContext<T> context) {
                if (context == LongFieldScript.CONTEXT) {
                    return (T)LongFieldScript.PARSE_FROM_SOURCE;
                }
                if (context == DoubleFieldScript.CONTEXT) {
                    return (T)DoubleFieldScript.PARSE_FROM_SOURCE;
                }
                throw new UnsupportedOperationException("Unknown script " + script.getIdOrCode());
            }

            @Override
            ScriptFactory emptyFieldScript() {
                return null;
            }

            @Override
            ScriptFactory nonEmptyFieldScript() {
                return null;
            }
        };
    }

    public void testScriptableTypes() throws IOException {
        if (this.allowsIndexTimeScript()) {
            this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("script", "foo");
            })));
        } else {
            Exception e = (Exception)NumberFieldMapperTests.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("script", "foo");
            }))));
            NumberFieldMapperTests.assertEquals((Object)"Failed to parse mapping: Unknown parameter [script] for mapper [field]", (Object)e.getMessage());
        }
    }

    public void testAllowMultipleValuesField() throws IOException {
        MapperService mapperService = this.createMapperService(NumberFieldMapperTests.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> this.minimalMapping((XContentBuilder)b))));
        Mapper mapper = mapperService.mappingLookup().getMapper("field");
        if (mapper instanceof NumberFieldMapper) {
            NumberFieldMapper numberFieldMapper = (NumberFieldMapper)mapper;
            numberFieldMapper.setAllowMultipleValues(false);
        } else {
            NumberFieldMapperTests.fail((String)("mapper [" + String.valueOf(mapper.getClass()) + "] error, not number field"));
        }
        Exception e = (Exception)NumberFieldMapperTests.expectThrows(DocumentParsingException.class, () -> mapperService.documentMapper().parse(NumberFieldMapperTests.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.array("field", new Object[]{this.randomNumber(), this.randomNumber(), this.randomNumber()})))));
        NumberFieldMapperTests.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Only one field can be stored per key"));
    }

    protected abstract Number randomNumber();

    @Override
    protected List<MapperTestCase.SortShortcutSupport> getSortShortcutSupport() {
        return List.of(new MapperTestCase.SortShortcutSupport((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField), true), new MapperTestCase.SortShortcutSupport(IndexVersion.fromId((int)5000099), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField), false));
    }

    protected class NumberSyntheticSourceSupport
    implements MapperTestCase.SyntheticSourceSupport {
        private final Long nullValue;
        private final boolean coerce;
        private final boolean docValues;
        private final Function<Number, Number> round;
        private final boolean ignoreMalformed;

        protected NumberSyntheticSourceSupport(Function<Number, Number> round, boolean ignoreMalformed) {
            this.nullValue = LuceneTestCase.usually() ? null : Long.valueOf(NumberFieldMapperTests.this.randomNumber().longValue());
            this.coerce = LuceneTestCase.rarely();
            this.docValues = ESTestCase.randomBoolean();
            this.round = round;
            this.ignoreMalformed = ignoreMalformed;
        }

        @Override
        public boolean preservesExactSource() {
            return !this.docValues;
        }

        @Override
        public MapperTestCase.SyntheticSourceExample example(int maxVals) {
            if (ESTestCase.randomBoolean()) {
                Tuple<Object, Object> v2 = this.generateValue();
                if (this.preservesExactSource()) {
                    Object rawInput = v2.v1();
                    return new MapperTestCase.SyntheticSourceExample(rawInput, rawInput, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::mapping));
                }
                Object object = v2.v2();
                if (object instanceof Number) {
                    Number n = (Number)object;
                    Number result = this.round.apply(n);
                    return new MapperTestCase.SyntheticSourceExample(v2.v1(), result, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::mapping));
                }
                return new MapperTestCase.SyntheticSourceExample(v2.v1(), v2.v2(), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::mapping));
            }
            List<Tuple> values = ESTestCase.randomList(1, maxVals, this::generateValue);
            List<Object> in = values.stream().map(Tuple::v1).toList();
            if (this.preservesExactSource()) {
                return new MapperTestCase.SyntheticSourceExample(in, in, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::mapping));
            }
            List outList = values.stream().filter(v -> v.v2() instanceof Number).map(t -> this.round.apply((Number)t.v2())).sorted().collect(Collectors.toCollection(ArrayList::new));
            values.stream().filter(v -> false == v.v2() instanceof Number).map(Tuple::v2).forEach(outList::add);
            List out = outList.size() == 1 ? outList.get(0) : outList;
            return new MapperTestCase.SyntheticSourceExample(in, out, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::mapping));
        }

        private Tuple<Object, Object> generateValue() {
            if (this.ignoreMalformed && ESTestCase.randomBoolean()) {
                List<Supplier<Object>> choices = List.of(() -> "a" + ESTestCase.randomAlphaOfLength(3), ESTestCase::randomBoolean);
                Object v = ESTestCase.randomFrom(choices).get();
                return Tuple.tuple((Object)v, (Object)v);
            }
            if (this.nullValue != null && ESTestCase.randomBoolean()) {
                return Tuple.tuple(null, (Object)this.nullValue);
            }
            Number n = NumberFieldMapperTests.this.randomNumber();
            Object in = n;
            Number out = n;
            if (this.coerce && ESTestCase.randomBoolean()) {
                in = in.toString();
            }
            return Tuple.tuple((Object)in, (Object)out);
        }

        private void mapping(XContentBuilder b) throws IOException {
            NumberFieldMapperTests.this.minimalMapping(b);
            if (this.coerce) {
                b.field("coerce", true);
            }
            if (this.nullValue != null) {
                b.field("null_value", this.nullValue);
            }
            if (this.ignoreMalformed) {
                b.field("ignore_malformed", true);
            }
            if (!this.docValues) {
                b.field("doc_values", "false");
            }
        }

        @Override
        public List<MapperTestCase.SyntheticSourceInvalidExample> invalidExample() throws IOException {
            return List.of();
        }
    }

    protected final class NumberSyntheticSourceSupportForKeepTests
    extends NumberSyntheticSourceSupport {
        private final boolean preserveSource;

        protected NumberSyntheticSourceSupportForKeepTests(NumberFieldMapperTests this$0, Function<Number, Number> round, boolean ignoreMalformed, Mapper.SourceKeepMode sourceKeepMode) {
            super(round, ignoreMalformed);
            this.preserveSource = sourceKeepMode == Mapper.SourceKeepMode.ALL;
        }

        @Override
        public boolean preservesExactSource() {
            return this.preserveSource;
        }

        @Override
        public MapperTestCase.SyntheticSourceExample example(int maxVals) {
            MapperTestCase.SyntheticSourceExample example = super.example(maxVals);
            return new MapperTestCase.SyntheticSourceExample(example.expectedForSyntheticSource(), example.expectedForSyntheticSource(), example.mapping());
        }
    }
}

