/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonGenerationException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonGenerator;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonNode;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.BeanProperty;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.JsonMappingException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.JsonSerializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ResolvableSerializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.SerializerProvider;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.TypeSerializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ser.ContainerSerializerBase;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ser.impl.PropertySerializerMap;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.node.ObjectNode;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.schema.JsonSchema;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.schema.SchemaAware;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerSerializers {
    private ContainerSerializers() {
    }

    public static ContainerSerializerBase<?> indexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
        return new IndexedListSerializer(elemType, staticTyping, vts, property, valueSerializer);
    }

    public static ContainerSerializerBase<?> collectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
        return new CollectionSerializer(elemType, staticTyping, vts, property, valueSerializer);
    }

    public static ContainerSerializerBase<?> iteratorSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        return new IteratorSerializer(elemType, staticTyping, vts, property);
    }

    public static ContainerSerializerBase<?> iterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        return new IterableSerializer(elemType, staticTyping, vts, property);
    }

    public static JsonSerializer<?> enumSetSerializer(JavaType enumType, BeanProperty property) {
        return new EnumSetSerializer(enumType, property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSetSerializer
    extends AsArraySerializer<EnumSet<? extends Enum<?>>> {
        public EnumSetSerializer(JavaType elemType, BeanProperty property) {
            super(EnumSet.class, elemType, true, null, property);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public void serializeContents(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            JsonSerializer<Object> enumSer = this._elementSerializer;
            for (Enum enum_ : value) {
                if (enumSer == null) {
                    enumSer = provider.findValueSerializer(enum_.getDeclaringClass(), this._property);
                }
                enumSer.serialize(enum_, jgen, provider);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static class IterableSerializer
    extends AsArraySerializer<Iterable<?>> {
        public IterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
            super(Iterable.class, elemType, staticTyping, vts, property);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new IterableSerializer(this._elementType, this._staticTyping, vts, this._property);
        }

        @Override
        public void serializeContents(Iterable<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                TypeSerializer typeSer = this._valueTypeSerializer;
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.defaultSerializeNull(jgen);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                        prevClass = cc;
                    }
                    if (typeSer == null) {
                        currSerializer.serialize(elem, jgen, provider);
                        continue;
                    }
                    currSerializer.serializeWithType(elem, jgen, provider, typeSer);
                } while (it.hasNext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static class IteratorSerializer
    extends AsArraySerializer<Iterator<?>> {
        public IteratorSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
            super(Iterator.class, elemType, staticTyping, vts, property);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new IteratorSerializer(this._elementType, this._staticTyping, vts, this._property);
        }

        @Override
        public void serializeContents(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value.hasNext()) {
                TypeSerializer typeSer = this._valueTypeSerializer;
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                do {
                    JsonSerializer<Object> currSerializer;
                    Object elem;
                    if ((elem = value.next()) == null) {
                        provider.defaultSerializeNull(jgen);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                        prevClass = cc;
                    }
                    if (typeSer == null) {
                        currSerializer.serialize(elem, jgen, provider);
                        continue;
                    }
                    currSerializer.serializeWithType(elem, jgen, provider, typeSer);
                } while (value.hasNext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static class CollectionSerializer
    extends AsArraySerializer<Collection<?>> {
        @Deprecated
        public CollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
            this(elemType, staticTyping, vts, property, null);
        }

        public CollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            super(Collection.class, elemType, staticTyping, vts, property, valueSerializer);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new CollectionSerializer(this._elementType, this._staticTyping, vts, this._property);
        }

        @Override
        public void serializeContents(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (this._elementSerializer != null) {
                this.serializeContentsUsing(value, jgen, provider, this._elementSerializer);
                return;
            }
            Iterator<?> it = value.iterator();
            if (!it.hasNext()) {
                return;
            }
            PropertySerializerMap serializers = this._dynamicSerializers;
            TypeSerializer typeSer = this._valueTypeSerializer;
            int i = 0;
            try {
                do {
                    Object elem;
                    if ((elem = it.next()) == null) {
                        provider.defaultSerializeNull(jgen);
                    } else {
                        Class<?> cc = elem.getClass();
                        JsonSerializer<Object> serializer = serializers.serializerFor(cc);
                        if (serializer == null) {
                            serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, this._elementType.forcedNarrowBy(cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                            serializers = this._dynamicSerializers;
                        }
                        if (typeSer == null) {
                            serializer.serialize(elem, jgen, provider);
                        } else {
                            serializer.serializeWithType(elem, jgen, provider, typeSer);
                        }
                    }
                    ++i;
                } while (it.hasNext());
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }

        public void serializeContentsUsing(Collection<?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
            Iterator<?> it = value.iterator();
            if (it.hasNext()) {
                TypeSerializer typeSer = this._valueTypeSerializer;
                int i = 0;
                do {
                    Object elem = it.next();
                    try {
                        if (elem == null) {
                            provider.defaultSerializeNull(jgen);
                        } else if (typeSer == null) {
                            ser.serialize(elem, jgen, provider);
                        } else {
                            ser.serializeWithType(elem, jgen, provider, typeSer);
                        }
                        ++i;
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(provider, (Throwable)e, value, i);
                    }
                } while (it.hasNext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static class IndexedListSerializer
    extends AsArraySerializer<List<?>> {
        public IndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            super(List.class, elemType, staticTyping, vts, property, valueSerializer);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new IndexedListSerializer(this._elementType, this._staticTyping, vts, this._property, this._elementSerializer);
        }

        @Override
        public void serializeContents(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int i;
            if (this._elementSerializer != null) {
                this.serializeContentsUsing(value, jgen, provider, this._elementSerializer);
                return;
            }
            if (this._valueTypeSerializer != null) {
                this.serializeTypedContents(value, jgen, provider);
                return;
            }
            int len = value.size();
            if (len == 0) {
                return;
            }
            try {
                PropertySerializerMap serializers = this._dynamicSerializers;
                for (i = 0; i < len; ++i) {
                    Object elem = value.get(i);
                    if (elem == null) {
                        provider.defaultSerializeNull(jgen);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    JsonSerializer<Object> serializer = serializers.serializerFor(cc);
                    if (serializer == null) {
                        serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, this._elementType.forcedNarrowBy(cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                        serializers = this._dynamicSerializers;
                    }
                    serializer.serialize(elem, jgen, provider);
                }
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }

        public void serializeContentsUsing(List<?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
            int len = value.size();
            if (len == 0) {
                return;
            }
            TypeSerializer typeSer = this._valueTypeSerializer;
            for (int i = 0; i < len; ++i) {
                Object elem = value.get(i);
                try {
                    if (elem == null) {
                        provider.defaultSerializeNull(jgen);
                        continue;
                    }
                    if (typeSer == null) {
                        ser.serialize(elem, jgen, provider);
                        continue;
                    }
                    ser.serializeWithType(elem, jgen, provider, typeSer);
                    continue;
                }
                catch (Exception e) {
                    this.wrapAndThrow(provider, (Throwable)e, value, i);
                }
            }
        }

        public void serializeTypedContents(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int i;
            int len = value.size();
            if (len == 0) {
                return;
            }
            try {
                TypeSerializer typeSer = this._valueTypeSerializer;
                PropertySerializerMap serializers = this._dynamicSerializers;
                for (i = 0; i < len; ++i) {
                    Object elem = value.get(i);
                    if (elem == null) {
                        provider.defaultSerializeNull(jgen);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    JsonSerializer<Object> serializer = serializers.serializerFor(cc);
                    if (serializer == null) {
                        serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, this._elementType.forcedNarrowBy(cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                        serializers = this._dynamicSerializers;
                    }
                    serializer.serializeWithType(elem, jgen, provider, typeSer);
                }
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AsArraySerializer<T>
    extends ContainerSerializerBase<T>
    implements ResolvableSerializer {
        protected final boolean _staticTyping;
        protected final JavaType _elementType;
        protected final TypeSerializer _valueTypeSerializer;
        protected JsonSerializer<Object> _elementSerializer;
        protected final BeanProperty _property;
        protected PropertySerializerMap _dynamicSerializers;

        @Deprecated
        protected AsArraySerializer(Class<?> cls, JavaType et, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
            this(cls, et, staticTyping, vts, property, null);
        }

        protected AsArraySerializer(Class<?> cls, JavaType et, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> elementSerializer) {
            super(cls, false);
            this._elementType = et;
            this._staticTyping = staticTyping || et != null && et.isFinal();
            this._valueTypeSerializer = vts;
            this._property = property;
            this._elementSerializer = elementSerializer;
            this._dynamicSerializers = PropertySerializerMap.emptyMap();
        }

        @Override
        public final void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            this.serializeContents(value, jgen, provider);
            jgen.writeEndArray();
        }

        @Override
        public final void serializeWithType(T value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            typeSer.writeTypePrefixForArray(value, jgen);
            this.serializeContents(value, jgen, provider);
            typeSer.writeTypeSuffixForArray(value, jgen);
        }

        protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            Type[] typeArgs;
            JavaType javaType;
            ObjectNode o = this.createSchemaNode("array", true);
            JavaType contentType = null;
            if (typeHint != null && (contentType = (javaType = provider.constructType(typeHint)).getContentType()) == null && typeHint instanceof ParameterizedType && (typeArgs = ((ParameterizedType)typeHint).getActualTypeArguments()).length == 1) {
                contentType = provider.constructType(typeArgs[0]);
            }
            if (contentType == null && this._elementType != null) {
                contentType = this._elementType;
            }
            if (contentType != null) {
                JsonSerializer<Object> ser;
                JsonNode schemaNode = null;
                if (contentType.getRawClass() != Object.class && (ser = provider.findValueSerializer(contentType, this._property)) instanceof SchemaAware) {
                    schemaNode = ((SchemaAware)((Object)ser)).getSchema(provider, null);
                }
                if (schemaNode == null) {
                    schemaNode = JsonSchema.getDefaultSchemaNode();
                }
                o.put("items", schemaNode);
            }
            return o;
        }

        @Override
        public void resolve(SerializerProvider provider) throws JsonMappingException {
            if (this._staticTyping && this._elementType != null && this._elementSerializer == null) {
                this._elementSerializer = provider.findValueSerializer(this._elementType, this._property);
            }
        }

        protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
            PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
            if (map != result.map) {
                this._dynamicSerializers = result.map;
            }
            return result.serializer;
        }

        protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
            PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
            if (map != result.map) {
                this._dynamicSerializers = result.map;
            }
            return result.serializer;
        }
    }
}

