/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubstituteExpressionVisitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.AggregatorInfoList;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class GroupByNode
extends SingleChildResultSetNode {
    GroupByList groupingList;
    private List<AggregateNode> aggregates;
    private AggregatorInfoList aggInfo;
    FromTable parent;
    private boolean addDistinctAggregate;
    private boolean singleInputRowOptimization;
    private int addDistinctAggregateColumnNum;
    private final boolean isInSortedOrder;
    private ValueNode havingClause;
    private SubqueryList havingSubquerys;

    GroupByNode(ResultSetNode bottomPR, GroupByList groupingList, List<AggregateNode> aggregates, ValueNode havingClause, SubqueryList havingSubquerys, int nestingLevel, ContextManager cm) throws StandardException {
        super(bottomPR, null, cm);
        this.setLevel(nestingLevel);
        this.havingClause = havingClause;
        this.havingSubquerys = havingSubquerys;
        if (!(this.childResult instanceof Optimizable)) {
            SanityManager.THROWASSERT((String)("childResult, " + this.childResult.getClass().getName() + ", expected to be instanceof Optimizable"));
        }
        if (!(this.childResult instanceof FromTable)) {
            SanityManager.THROWASSERT((String)("childResult, " + this.childResult.getClass().getName() + ", expected to be instanceof FromTable"));
        }
        this.groupingList = groupingList;
        this.aggregates = aggregates;
        this.parent = this;
        ResultColumnList newBottomRCL = this.childResult.getResultColumns().copyListAndObjects();
        this.setResultColumns(this.childResult.getResultColumns());
        this.childResult.setResultColumns(newBottomRCL);
        this.addAggregates();
        if (this.groupingList != null && this.groupingList.isRollup()) {
            this.getResultColumns().setNullability(true);
            this.parent.getResultColumns().setNullability(true);
        }
        if (!this.addDistinctAggregate && groupingList != null) {
            GroupByColumn gc;
            int index;
            ColumnReference[] crs = new ColumnReference[this.groupingList.size()];
            int glSize = this.groupingList.size();
            for (index = 0; index < glSize && (gc = (GroupByColumn)this.groupingList.elementAt(index)).getColumnExpression() instanceof ColumnReference; ++index) {
                crs[index] = (ColumnReference)gc.getColumnExpression();
            }
            this.isInSortedOrder = index == glSize && this.childResult.isOrderedOn(crs, true, null);
        } else {
            this.isInSortedOrder = false;
        }
    }

    boolean getIsInSortedOrder() {
        return this.isInSortedOrder;
    }

    private void addAggregates() throws StandardException {
        this.addNewPRNode();
        this.addNewColumnsForAggregation();
        this.addDistinctAggregatesToOrderBy();
    }

    private void addDistinctAggregatesToOrderBy() {
        int numDistinct = GroupByNode.numDistinctAggregates(this.aggregates);
        if (numDistinct != 0) {
            SanityManager.ASSERT((this.groupingList != null || numDistinct == 1 ? 1 : 0) != 0, (String)"Should not have more than 1 distinct aggregate per Group By node");
            AggregatorInfo agg = null;
            int count = this.aggInfo.size();
            for (int i = 0; i < count && !(agg = (AggregatorInfo)this.aggInfo.elementAt(i)).isDistinct(); ++i) {
            }
            SanityManager.ASSERT((agg != null && agg.isDistinct() ? 1 : 0) != 0);
            this.addDistinctAggregate = true;
            this.addDistinctAggregateColumnNum = agg.getInputColNum();
        }
    }

    private void addNewPRNode() throws StandardException {
        ResultColumnList rclNew = new ResultColumnList(this.getContextManager());
        for (ResultColumn rc : this.getResultColumns()) {
            if (rc.isGenerated()) continue;
            rclNew.addElement(rc);
        }
        rclNew.copyOrderBySelect(this.getResultColumns());
        this.parent = new ProjectRestrictNode(this, rclNew, null, null, null, this.havingSubquerys, this.tableProperties, this.getContextManager());
        this.childResult.setResultColumns(new ResultColumnList(this.getContextManager()));
        this.setResultColumns(new ResultColumnList(this.getContextManager()));
    }

    private ArrayList<SubstituteExpressionVisitor> addUnAggColumns() throws StandardException {
        ResultColumnList bottomRCL = this.childResult.getResultColumns();
        ResultColumnList groupByRCL = this.getResultColumns();
        ArrayList<SubstituteExpressionVisitor> referencesToSubstitute = new ArrayList<SubstituteExpressionVisitor>();
        ArrayList<SubstituteExpressionVisitor> havingRefsToSubstitute = null;
        if (this.havingClause != null) {
            havingRefsToSubstitute = new ArrayList<SubstituteExpressionVisitor>();
        }
        for (GroupByColumn gbc : this.groupingList) {
            ResultColumn newRC = new ResultColumn("##UnaggColumn", gbc.getColumnExpression(), this.getContextManager());
            bottomRCL.addElement(newRC);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            newRC.setVirtualColumnId(bottomRCL.size());
            ResultColumn gbRC = new ResultColumn("##UnaggColumn", gbc.getColumnExpression(), this.getContextManager());
            groupByRCL.addElement(gbRC);
            gbRC.markGenerated();
            gbRC.bindResultColumnToExpression();
            gbRC.setVirtualColumnId(groupByRCL.size());
            VirtualColumnNode vc = new VirtualColumnNode(this, gbRC, groupByRCL.size(), this.getContextManager());
            ValueNode vn = gbc.getColumnExpression();
            SubstituteExpressionVisitor vis = new SubstituteExpressionVisitor(vn, vc, AggregateNode.class);
            referencesToSubstitute.add(vis);
            if (this.havingClause != null) {
                SubstituteExpressionVisitor havingSE = new SubstituteExpressionVisitor(vn, vc, null);
                havingRefsToSubstitute.add(havingSE);
            }
            gbc.setColumnPosition(bottomRCL.size());
        }
        ExpressionSorter sorter = new ExpressionSorter();
        Collections.sort(referencesToSubstitute, sorter);
        for (int r = 0; r < referencesToSubstitute.size(); ++r) {
            this.parent.getResultColumns().accept((Visitor)referencesToSubstitute.get(r));
        }
        if (havingRefsToSubstitute != null) {
            Collections.sort(havingRefsToSubstitute, sorter);
        }
        return havingRefsToSubstitute;
    }

    private void addNewColumnsForAggregation() throws StandardException {
        this.aggInfo = new AggregatorInfoList();
        ArrayList<SubstituteExpressionVisitor> havingRefsToSubstitute = null;
        if (this.groupingList != null) {
            havingRefsToSubstitute = this.addUnAggColumns();
        }
        this.addAggregateColumns();
        if (this.havingClause != null) {
            if (havingRefsToSubstitute != null) {
                for (int r = 0; r < havingRefsToSubstitute.size(); ++r) {
                    this.havingClause.accept(havingRefsToSubstitute.get(r));
                }
            }
            CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class, AggregateNode.class);
            this.havingClause.accept(collectNodesVisitor);
            for (ColumnReference cr : collectNodesVisitor.getList()) {
                if (cr.getGeneratedToReplaceAggregate() || cr.getGeneratedToReplaceWindowFunctionCall() || cr.getSourceLevel() != this.level) continue;
                throw StandardException.newException((String)"42X24", (Object[])new Object[]{cr.getSQLColumnName()});
            }
        }
    }

    private void addAggregateColumns() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        ResultColumnList bottomRCL = this.childResult.getResultColumns();
        ResultColumnList groupByRCL = this.getResultColumns();
        LanguageFactory lf = this.getLanguageConnectionContext().getLanguageFactory();
        ReplaceAggregatesWithCRVisitor replaceAggsVisitor = new ReplaceAggregatesWithCRVisitor(new ResultColumnList(this.getContextManager()), ((FromTable)this.childResult).getTableNumber(), ResultSetNode.class);
        this.parent.getResultColumns().accept(replaceAggsVisitor);
        if (this.havingClause != null) {
            replaceAggsVisitor = new ReplaceAggregatesWithCRVisitor(new ResultColumnList(this.getContextManager()), ((FromTable)this.childResult).getTableNumber());
            this.havingClause.accept(replaceAggsVisitor);
            ProjectRestrictNode parentPRSN = (ProjectRestrictNode)this.parent;
            parentPRSN.setRestriction(this.havingClause);
        }
        int alSize = this.aggregates.size();
        for (int index = 0; index < alSize; ++index) {
            AggregateNode aggregate = this.aggregates.get(index);
            ResultColumn newRC = new ResultColumn("##aggregate result", aggregate.getNewNullResultExpression(), this.getContextManager());
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            bottomRCL.addElement(newRC);
            newRC.setVirtualColumnId(bottomRCL.size());
            int aggResultVColId = newRC.getVirtualColumnId();
            ColumnReference newColumnRef = new ColumnReference(newRC.getName(), null, this.getContextManager());
            newColumnRef.setSource(newRC);
            newColumnRef.setNestingLevel(this.getLevel());
            newColumnRef.setSourceLevel(this.getLevel());
            ResultColumn tmpRC = new ResultColumn(newRC.getColumnName(), (ValueNode)newColumnRef, this.getContextManager());
            tmpRC.markGenerated();
            tmpRC.bindResultColumnToExpression();
            groupByRCL.addElement(tmpRC);
            tmpRC.setVirtualColumnId(groupByRCL.size());
            newColumnRef = aggregate.getGeneratedRef();
            newColumnRef.setSource(tmpRC);
            newRC = aggregate.getNewExpressionResultColumn(dd);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            bottomRCL.addElement(newRC);
            newRC.setVirtualColumnId(bottomRCL.size());
            int aggInputVColId = newRC.getVirtualColumnId();
            ResultColumn aggResultRC = new ResultColumn("##aggregate expression", aggregate.getNewNullResultExpression(), this.getContextManager());
            tmpRC = this.getColumnReference(newRC, dd);
            groupByRCL.addElement(tmpRC);
            tmpRC.setVirtualColumnId(groupByRCL.size());
            newRC = aggregate.getNewAggregatorResultColumn(dd);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            bottomRCL.addElement(newRC);
            newRC.setVirtualColumnId(bottomRCL.size());
            int aggregatorVColId = newRC.getVirtualColumnId();
            tmpRC = this.getColumnReference(newRC, dd);
            groupByRCL.addElement(tmpRC);
            tmpRC.setVirtualColumnId(groupByRCL.size());
            ResultColumnList aggRCL = new ResultColumnList(this.getContextManager());
            aggRCL.addElement(aggResultRC);
            this.aggInfo.addElement(new AggregatorInfo(aggregate.getAggregateName(), aggregate.getAggregatorClassName(), aggInputVColId - 1, aggResultVColId - 1, aggregatorVColId - 1, aggregate.isDistinct(), lf.getResultDescription(aggRCL.makeResultDescriptors(), "SELECT")));
        }
    }

    final FromTable getParent() {
        return this.parent;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, predList, outerCost, rowOrdering);
        CostEstimate retval = super.optimizeIt(optimizer, predList, outerCost, rowOrdering);
        return retval;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).estimateCost(predList, cd, outerCost, optimizer, rowOrdering);
        CostEstimate costEst = this.getCostEstimate(optimizer);
        costEst.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        return costEst;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return ((Optimizable)((Object)this.childResult)).pushOptPredicate(optimizablePredicate);
    }

    @Override
    public String toString() {
        return "singleInputRowOptimization: " + this.singleInputRowOptimization + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "aggregates:\n");
        for (int i = 0; i < this.aggregates.size(); ++i) {
            AggregateNode agg = this.aggregates.get(i);
            GroupByNode.debugPrint(GroupByNode.formatNodeString("[" + i + "]:", depth + 1));
            agg.treePrint(depth + 1);
        }
        if (this.groupingList != null) {
            this.printLabel(depth, "groupingList: ");
            this.groupingList.treePrint(depth + 1);
        }
        if (this.havingClause != null) {
            this.printLabel(depth, "havingClause: ");
            this.havingClause.treePrint(depth + 1);
        }
        if (this.havingSubquerys != null) {
            this.printLabel(depth, "havingSubqueries: ");
            this.havingSubquerys.treePrint(depth + 1);
        }
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicates, outerRows);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.childResult.makeResultDescriptors();
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        return this.groupingList == null || this.groupingList.size() == 0;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        FormatableArrayHolder orderingHolder = acb.getColumnOrdering(this.groupingList);
        if (this.addDistinctAggregate) {
            orderingHolder = acb.addColumnToOrdering(orderingHolder, this.addDistinctAggregateColumnNum);
        }
        if (SanityManager.DEBUG_ON((String)"AggregateTrace")) {
            StringBuilder s = new StringBuilder();
            s.append("Group by column ordering is (");
            ColumnOrdering[] ordering = (ColumnOrdering[])orderingHolder.getArray(ColumnOrdering[].class);
            for (int i = 0; i < ordering.length; ++i) {
                s.append(ordering[i].getColumnId());
                s.append(" ");
            }
            s.append(")");
            SanityManager.DEBUG((String)"AggregateTrace", (String)s.toString());
        }
        int orderingItem = acb.addItem(orderingHolder);
        SanityManager.ASSERT((this.aggInfo != null ? 1 : 0) != 0, (String)"aggInfo not set up as expected");
        int aggInfoItem = acb.addItem(this.aggInfo);
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(this.isInSortedOrder);
        mb.push(aggInfoItem);
        mb.push(orderingItem);
        mb.push(acb.addItem(this.getResultColumns().buildRowTemplate()));
        mb.push(this.getResultColumns().getTotalColumnSize());
        mb.push(this.getResultSetNumber());
        if (this.groupingList == null || this.groupingList.size() == 0) {
            this.genScalarAggregateResultSet(acb, mb);
        } else {
            this.genGroupedAggregateResultSet(acb, mb);
        }
    }

    private void genScalarAggregateResultSet(ActivationClassBuilder acb, MethodBuilder mb) {
        String resultSet = this.addDistinctAggregate ? "getDistinctScalarAggregateResultSet" : "getScalarAggregateResultSet";
        mb.push(this.singleInputRowOptimization);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, resultSet, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 10);
    }

    private void genGroupedAggregateResultSet(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        String resultSet = this.addDistinctAggregate ? "getDistinctGroupedAggregateResultSet" : "getGroupedAggregateResultSet";
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.push(this.groupingList.isRollup());
        mb.callMethod((short)185, null, resultSet, "org.apache.derby.iapi.sql.execute.NoPutResultSet", 10);
    }

    private ResultColumn getColumnReference(ResultColumn targetRC, DataDictionary dd) throws StandardException {
        ColumnReference tmpColumnRef = new ColumnReference(targetRC.getName(), null, this.getContextManager());
        tmpColumnRef.setSource(targetRC);
        tmpColumnRef.setNestingLevel(this.getLevel());
        tmpColumnRef.setSourceLevel(this.getLevel());
        ResultColumn newRC = new ResultColumn(targetRC.getColumnName(), (ValueNode)tmpColumnRef, this.getContextManager());
        newRC.markGenerated();
        newRC.bindResultColumnToExpression();
        return newRC;
    }

    void considerPostOptimizeOptimizations(boolean selectHasPredicates) throws StandardException {
        AggregateNode an;
        AggregateDefinition ad;
        if (this.groupingList == null && this.aggregates.size() == 1 && (ad = (an = this.aggregates.get(0)).getAggregateDefinition()) instanceof MaxMinAggregateDefinition) {
            if (an.getOperand() instanceof ColumnReference) {
                ColumnReference[] crs = new ColumnReference[]{(ColumnReference)an.getOperand()};
                ArrayList<FromBaseTable> fbtHolder = new ArrayList<FromBaseTable>(1);
                boolean minMaxOptimizationPossible = this.isOrderedOn(crs, false, fbtHolder);
                SanityManager.ASSERT((fbtHolder.size() <= 1 ? 1 : 0) != 0, (String)("bad number of FromBaseTables returned by isOrderedOn() -- " + fbtHolder.size()));
                if (minMaxOptimizationPossible) {
                    boolean ascIndex = true;
                    int colNum = crs[0].getColumnNumber();
                    AccessPath accessPath = this.getTrulyTheBestAccessPath();
                    if (accessPath == null || accessPath.getConglomerateDescriptor() == null || accessPath.getConglomerateDescriptor().getIndexDescriptor() == null) {
                        return;
                    }
                    IndexRowGenerator id = accessPath.getConglomerateDescriptor().getIndexDescriptor();
                    int[] keyColumns = id.baseColumnPositions();
                    boolean[] isAscending = id.isAscending();
                    for (int i = 0; i < keyColumns.length; ++i) {
                        if (colNum != keyColumns[i]) continue;
                        if (isAscending[i]) break;
                        ascIndex = false;
                        break;
                    }
                    FromBaseTable fbt = fbtHolder.get(0);
                    MaxMinAggregateDefinition temp = (MaxMinAggregateDefinition)ad;
                    if (!temp.isMax() && ascIndex || temp.isMax() && !ascIndex) {
                        fbt.disableBulkFetch();
                        this.singleInputRowOptimization = true;
                    } else if (!selectHasPredicates && (temp.isMax() && ascIndex || !temp.isMax() && !ascIndex)) {
                        fbt.disableBulkFetch();
                        fbt.doSpecialMaxScan();
                        this.singleInputRowOptimization = true;
                    }
                }
            } else if (an.getOperand() instanceof ConstantNode) {
                this.singleInputRowOptimization = true;
            }
        }
    }

    private static class ExpressionSorter
    implements Comparator<SubstituteExpressionVisitor> {
        private ExpressionSorter() {
        }

        @Override
        public int compare(SubstituteExpressionVisitor o1, SubstituteExpressionVisitor o2) {
            try {
                ValueNode v1 = o1.getSource();
                ValueNode v2 = o2.getSource();
                CollectNodesVisitor<ColumnReference> vis = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                v1.accept(vis);
                int refCount1 = vis.getList().size();
                vis = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                v2.accept(vis);
                int refCount2 = vis.getList().size();
                return refCount2 - refCount1;
            }
            catch (StandardException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

