"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLogger = void 0;
var fs_1 = require("fs");
var ecs_pino_format_1 = __importDefault(require("@elastic/ecs-pino-format"));
var pino_1 = __importDefault(require("pino"));
var config_service_1 = require("./config/config_service");
var utils_1 = require("./utils");
var getLogger = function (loggingLevel, loggingPath) {
    if (loggingLevel === void 0) { loggingLevel = config_service_1.Constants.DEFAULT_LOG_LEVEL; }
    if (loggingPath === void 0) { loggingPath = config_service_1.Constants.DEFAULT_LOG_PATH; }
    // For non development environment, logs to standard output and file
    var streams = utils_1.isDev
        ? [{ level: loggingLevel, stream: process.stdout }]
        : [
            { level: loggingLevel, stream: process.stdout },
            {
                level: loggingLevel,
                stream: (0, fs_1.createWriteStream)(loggingPath),
            },
        ];
    var pinoOptions = __assign(__assign({}, (0, ecs_pino_format_1.default)()), { name: 'Elastic Maps Server', level: loggingLevel });
    if (utils_1.isDev) {
        pinoOptions['transport'] = {
            target: 'pino-pretty',
        };
    }
    return (0, pino_1.default)(pinoOptions, pino_1.default.multistream(streams));
};
exports.getLogger = getLogger;
//# sourceMappingURL=logger.js.map