/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.SlowLogFieldProvider;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.plugins.internal.DocumentParsingProvider;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.crossproject.ProjectRoutingResolver;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public abstract class Plugin
implements Closeable {
    public Collection<?> createComponents(PluginServices services) {
        return Collections.emptyList();
    }

    public Settings additionalSettings() {
        return Settings.EMPTY;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.emptyList();
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Collections.emptyList();
    }

    public void onIndexModule(IndexModule indexModule) {
    }

    public List<Setting<?>> getSettings() {
        return Collections.emptyList();
    }

    public List<String> getSettingsFilter() {
        return Collections.emptyList();
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return UnaryOperator.identity();
    }

    public Map<String, UnaryOperator<Metadata.ProjectCustom>> getProjectCustomMetadataUpgraders() {
        return Map.of();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return Collections.emptyList();
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        return Collections.emptyList();
    }

    @Override
    public void close() throws IOException {
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        return Collections.emptyList();
    }

    public static interface PluginServices {
        public Client client();

        public ClusterService clusterService();

        public RerouteService rerouteService();

        public ThreadPool threadPool();

        public ResourceWatcherService resourceWatcherService();

        public ScriptService scriptService();

        public NamedXContentRegistry xContentRegistry();

        public Environment environment();

        public NodeEnvironment nodeEnvironment();

        public NamedWriteableRegistry namedWriteableRegistry();

        public IndexNameExpressionResolver indexNameExpressionResolver();

        public RepositoriesService repositoriesService();

        public TelemetryProvider telemetryProvider();

        public AllocationService allocationService();

        public IndicesService indicesService();

        public FeatureService featureService();

        public SystemIndices systemIndices();

        public DataStreamGlobalRetentionSettings dataStreamGlobalRetentionSettings();

        public DocumentParsingProvider documentParsingProvider();

        public TaskManager taskManager();

        public ProjectResolver projectResolver();

        public SlowLogFieldProvider slowLogFieldProvider();

        public IndexingPressure indexingPressure();

        public LinkedProjectConfigService linkedProjectConfigService();

        public ProjectRoutingResolver projectRoutingResolver();
    }
}

