/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.ESInetAddressPoint;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.FieldArrayContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.IpFallbackSyntheticSourceReader;
import org.elasticsearch.index.mapper.IpPrefixAutomatonUtil;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SearchAfterTermsEnum;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SortedSetDocValuesSyntheticFieldLoaderLayer;
import org.elasticsearch.index.mapper.SortedSetDocValuesTerms;
import org.elasticsearch.index.mapper.SortedSetWithOffsetsDocValuesSyntheticFieldLoaderLayer;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.index.mapper.blockloader.docvalues.BytesRefsFromOrdsBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.fn.MvMaxBytesRefsFromOrdsBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.fn.MvMinBytesRefsFromOrdsBlockLoader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.IpDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentString;

public class IpFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IpFieldMapper.class);
    public static final String CONTENT_TYPE = "ip";
    public static final FieldMapper.TypeParser PARSER = IpFieldMapper.createTypeParserWithLegacySupport((n, c) -> new Builder((String)n, c.scriptCompiler(), c.getIndexSettings()));
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final boolean ignoreMalformed;
    private final boolean storeIgnored;
    private final boolean dimension;
    private final InetAddress nullValue;
    private final String nullValueAsString;
    private final IndexSettings indexSettings;
    private final Script script;
    private final FieldValues<InetAddress> scriptValues;
    private final ScriptCompiler scriptCompiler;
    private final String offsetsFieldName;

    private static IpFieldMapper toType(FieldMapper in) {
        return (IpFieldMapper)in;
    }

    private IpFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean storeIgnored, Builder builder, String offsetsFieldName) {
        super(simpleName, mappedFieldType, builderParams);
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.nullValue = builder.parseNullValue();
        this.nullValueAsString = builder.nullValue.getValue();
        this.script = builder.script.get();
        this.scriptValues = builder.scriptValues();
        this.scriptCompiler = builder.scriptCompiler;
        this.dimension = builder.dimension.getValue();
        this.storeIgnored = storeIgnored;
        this.offsetsFieldName = offsetsFieldName;
        this.indexSettings = builder.indexSettings;
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        ESInetAddressPoint address;
        XContentString value = context.parser().optimizedTextOrNull();
        try {
            address = value == null ? (this.nullValue == null ? null : new ESInetAddressPoint(this.fieldType().name(), this.nullValue)) : new ESInetAddressPoint(this.fieldType().name(), value);
        }
        catch (IllegalArgumentException e) {
            if (this.ignoreMalformed) {
                context.addIgnoredField(this.fieldType().name());
                if (this.storeIgnored) {
                    context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField(this.fullPath(), context.parser()));
                }
                return;
            }
            throw e;
        }
        if (address != null) {
            this.indexValue(context, address);
        }
        if (this.offsetsFieldName != null && context.isImmediateParentAnArray() && context.canAddIgnoredField()) {
            if (address != null) {
                BytesRef sortableValue = address.binaryValue();
                context.getOffSetContext().recordOffset(this.offsetsFieldName, (Comparable<?>)sortableValue);
            } else {
                context.getOffSetContext().recordNull(this.offsetsFieldName);
            }
        }
    }

    private void indexValue(DocumentParserContext context, ESInetAddressPoint address) {
        if (this.dimension && !context.getRoutingFields().isNoop()) {
            context.getRoutingFields().addIp(this.fieldType().name(), address.getInetAddress());
        }
        LuceneDocument doc = context.doc();
        if (this.fieldType().indexType.hasPoints()) {
            doc.add((IndexableField)address);
        }
        if (this.fieldType().indexType.hasDocValues()) {
            if (this.fieldType().indexType.hasDocValuesSkipper()) {
                doc.add((IndexableField)SortedSetDocValuesField.indexedField((String)this.fieldType().name(), (BytesRef)address.binaryValue()));
            } else {
                doc.add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), address.binaryValue()));
            }
        } else if (this.stored || this.indexed) {
            context.addToFieldNames(this.fieldType().name());
        }
        if (this.stored) {
            doc.add((IndexableField)new StoredField(this.fieldType().name(), address.binaryValue()));
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, new ESInetAddressPoint(this.fieldType().name(), (InetAddress)value)));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.scriptCompiler, this.indexSettings).dimension(this.dimension).init(this);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (this.dimension && null != lookup.nestedLookup().getNestedParent(this.fullPath())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.fullPath() + "]");
        }
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> {
                ArrayList<CompositeSyntheticFieldLoader.Layer> layers = new ArrayList<CompositeSyntheticFieldLoader.Layer>(2);
                if (this.offsetsFieldName != null) {
                    layers.add(new SortedSetWithOffsetsDocValuesSyntheticFieldLoaderLayer(this.fullPath(), this.offsetsFieldName, IpFieldMapper::convert));
                } else {
                    layers.add(new SortedSetDocValuesSyntheticFieldLoaderLayer(this, this.fullPath()){

                        @Override
                        protected BytesRef convert(BytesRef value) {
                            return IpFieldMapper.convert(value);
                        }

                        @Override
                        protected BytesRef preserve(BytesRef value) {
                            return value;
                        }
                    });
                }
                if (this.ignoreMalformed) {
                    layers.add(new CompositeSyntheticFieldLoader.MalformedValuesLayer(this.fullPath()));
                }
                return new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), layers);
            });
        }
        return super.syntheticSourceSupport();
    }

    static BytesRef convert(BytesRef value) {
        byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
        return new BytesRef((CharSequence)NetworkAddress.format(InetAddressPoint.decode((byte[])bytes)));
    }

    @Override
    public String getOffsetFieldName() {
        return this.offsetsFieldName;
    }

    public static final class Builder
    extends FieldMapper.DimensionBuilder {
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> IpFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> IpFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> IpFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> IpFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptErrorParam = FieldMapper.Parameter.onScriptErrorParam(m -> IpFieldMapper.toType((FieldMapper)m).builderParams.onScriptError(), this.script);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Boolean> dimension;
        private final ScriptCompiler scriptCompiler;
        private final IndexSettings indexSettings;

        public Builder(String name, ScriptCompiler scriptCompiler, IndexSettings indexSettings) {
            super(name);
            this.indexSettings = indexSettings;
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> IpFieldMapper.toType((FieldMapper)m).ignoreMalformed, FieldMapper.IGNORE_MALFORMED_SETTING.get(indexSettings.getSettings()));
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed);
            this.dimension = TimeSeriesParams.dimensionParam(m -> IpFieldMapper.toType((FieldMapper)m).dimension, this.hasDocValues::get);
            this.indexed = FieldMapper.Parameter.indexParam(m -> IpFieldMapper.toType((FieldMapper)m).indexed, indexSettings, this.dimension);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        private InetAddress parseNullValue() {
            String nullValueAsString = this.nullValue.getValue();
            if (nullValueAsString == null) {
                return null;
            }
            try {
                return InetAddresses.forString(nullValueAsString);
            }
            catch (Exception e) {
                if (this.indexSettings.getIndexVersionCreated().onOrAfter(IndexVersions.V_8_0_0)) {
                    throw new MapperParsingException("Error parsing [null_value] on field [" + this.leafName() + "]: " + e.getMessage(), e);
                }
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "ip_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as IP in [null_value] on field [" + this.leafName() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        private FieldValues<InetAddress> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            IpFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), IpFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.leafName(), this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.nullValue, this.script, this.onScriptErrorParam, this.meta, this.dimension};
        }

        private IndexType indexType() {
            if (this.indexSettings.getIndexVersionCreated().isLegacyIndexVersion()) {
                return this.hasDocValues.get() != false ? IndexType.archivedPoints() : IndexType.NONE;
            }
            if (FieldMapper.Parameter.useTimeSeriesDocValuesSkippers(this.indexSettings, this.dimension.get())) {
                return IndexType.skippers();
            }
            return IndexType.points(this.indexed.get(), this.hasDocValues.get());
        }

        @Override
        public IpFieldMapper build(MapperBuilderContext context) {
            if (this.inheritDimensionParameterFromParentObject(context)) {
                this.dimension.setValue(true);
            }
            this.hasScript = this.script.get() != null;
            this.onScriptError = this.onScriptErrorParam.getValue();
            String offsetsFieldName = FieldArrayContext.getOffsetsFieldName(context, this.indexSettings.sourceKeepMode(), this.hasDocValues.getValue(), this.stored.getValue(), this, this.indexSettings.getIndexVersionCreated(), IndexVersions.SYNTHETIC_SOURCE_STORE_ARRAYS_NATIVELY_IP);
            return new IpFieldMapper(this.leafName(), new IpFieldType(context.buildFullName(this.leafName()), this.indexType(), this.stored.getValue(), this.parseNullValue(), this.scriptValues(), this.meta.getValue(), this.dimension.getValue(), context.isSourceSynthetic()), this.builderParams(this, context), context.isSourceSynthetic(), this, offsetsFieldName);
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        private final InetAddress nullValue;
        private final FieldValues<InetAddress> scriptValues;
        private final boolean isDimension;
        private final boolean isSyntheticSource;
        private final boolean hasPoints;

        public IpFieldType(String name, IndexType indexType, boolean stored, InetAddress nullValue, FieldValues<InetAddress> scriptValues, Map<String, String> meta, boolean isDimension, boolean isSyntheticSource) {
            super(name, indexType, stored, meta);
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
            this.isDimension = isDimension;
            this.isSyntheticSource = isSyntheticSource;
            this.hasPoints = indexType.hasPoints();
        }

        public IpFieldType(String name) {
            this(name, true, true);
        }

        public IpFieldType(String name, boolean isIndexed) {
            this(name, isIndexed, true);
        }

        public IpFieldType(String name, boolean isIndexed, boolean hasDocValues) {
            this(name, IndexType.points(isIndexed, hasDocValues), false, null, null, Collections.emptyMap(), false, false);
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean isSearchable() {
            return this.hasPoints || this.hasDocValues();
        }

        @Override
        public TextSearchInfo getTextSearchInfo() {
            return TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS;
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public boolean hasScriptValues() {
            return this.scriptValues != null;
        }

        private static InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, v -> InetAddresses.toAddrString((InetAddress)v), context);
            }
            return new SourceValueFetcher(this, this.name(), context, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    InetAddress address = value instanceof InetAddress ? (InetAddress)value : InetAddresses.forString(value.toString());
                    return InetAddresses.toAddrString(address);
                }
            };
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            Query query;
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (value instanceof InetAddress) {
                query = InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            } else {
                String term;
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                if ((term = value.toString()).contains("/")) {
                    Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
                    query = InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)((InetAddress)cidr.v1()), (int)((Integer)cidr.v2()));
                } else {
                    InetAddress address = InetAddresses.forString(term);
                    query = InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
                }
            }
            if (this.hasPoints) {
                return query;
            }
            return IpFieldType.convertToDocValuesQuery(query);
        }

        static Query convertToDocValuesQuery(Query query) {
            assert (query instanceof PointRangeQuery);
            PointRangeQuery pointRangeQuery = (PointRangeQuery)query;
            return SortedSetDocValuesField.newSlowRangeQuery((String)pointRangeQuery.getField(), (BytesRef)new BytesRef(pointRangeQuery.getLowerPoint()), (BytesRef)new BytesRef(pointRangeQuery.getUpperPoint()), (boolean)true, (boolean)true);
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (!this.hasPoints) {
                return super.termsQuery(values, context);
            }
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString(value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])addresses);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            return IpFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (lower, upper) -> {
                Query query = InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper);
                if (this.hasPoints) {
                    if (this.hasDocValues()) {
                        return new IndexOrDocValuesQuery(query, IpFieldType.convertToDocValuesQuery(query));
                    }
                    return query;
                }
                return IpFieldType.convertToDocValuesQuery(query);
            });
        }

        public static Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<InetAddress, InetAddress, Query> builder) {
            InetAddress upper;
            InetAddress lower;
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = IpFieldType.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = IpFieldType.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return builder.apply(lower, upper);
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues() && (blContext.fieldExtractPreference() != MappedFieldType.FieldExtractPreference.STORED || this.isSyntheticSource)) {
                BlockLoaderFunctionConfig cfg = blContext.blockLoaderFunctionConfig();
                if (cfg == null) {
                    return new BytesRefsFromOrdsBlockLoader(this.name());
                }
                return switch (cfg.function()) {
                    case BlockLoaderFunctionConfig.Function.MV_MAX -> new MvMaxBytesRefsFromOrdsBlockLoader(this.name());
                    case BlockLoaderFunctionConfig.Function.MV_MIN -> new MvMinBytesRefsFromOrdsBlockLoader(this.name());
                    default -> throw new UnsupportedOperationException("unknown fusion config [" + String.valueOf((Object)cfg.function()) + "]");
                };
            }
            if (this.isStored()) {
                return new BlockStoredFieldsReader.BytesFromBytesRefsBlockLoader(this.name());
            }
            if (this.isSyntheticSource && blContext.parentField(this.name()) == null) {
                return this.blockLoaderFromFallbackSyntheticSource(blContext);
            }
            BlockSourceReader.LeafIteratorLookup lookup = !this.hasDocValues() && this.hasPoints ? BlockSourceReader.lookupFromFieldNames(blContext.fieldNames(), this.name()) : BlockSourceReader.lookupMatchingAll();
            return new BlockSourceReader.IpsBlockLoader(this.sourceValueFetcher(blContext), lookup);
        }

        @Override
        public boolean supportsBlockLoaderConfig(BlockLoaderFunctionConfig config, MappedFieldType.FieldExtractPreference preference) {
            if (this.hasDocValues() && (preference != MappedFieldType.FieldExtractPreference.STORED || this.isSyntheticSource)) {
                return switch (config.function()) {
                    case BlockLoaderFunctionConfig.Function.MV_MAX, BlockLoaderFunctionConfig.Function.MV_MIN -> true;
                    default -> false;
                };
            }
            return true;
        }

        private BlockLoader blockLoaderFromFallbackSyntheticSource(MappedFieldType.BlockLoaderContext blContext) {
            IpFallbackSyntheticSourceReader reader = new IpFallbackSyntheticSourceReader(this.nullValue);
            return new FallbackSyntheticSourceBlockLoader(this, reader, this.name(), IgnoredSourceFieldMapper.ignoredSourceFormat(blContext.indexSettings().getIndexVersionCreated())){

                @Override
                public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                    return factory.bytesRefs(expectedCount);
                }
            };
        }

        private SourceValueFetcher sourceValueFetcher(MappedFieldType.BlockLoaderContext blContext) {
            return new SourceValueFetcher(this, blContext.sourcePaths(this.name()), this.nullValue, blContext.indexSettings().getIgnoredSourceFormat()){

                @Override
                public InetAddress parseSourceValue(Object value) {
                    return IpFieldType.parse(value);
                }
            };
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.IP, IpDocValuesField::new);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            this.checkNoFormat(format);
            this.checkNoTimeZone(timeZone);
            return DocValueFormat.IP;
        }

        @Override
        public TermsEnum getTerms(IndexReader reader, String prefix, boolean caseInsensitive, String searchAfter) throws IOException {
            Terms terms = null;
            if (this.hasDocValues()) {
                terms = SortedSetDocValuesTerms.getTerms(reader, this.name());
            }
            if (terms == null) {
                return null;
            }
            BytesRef searchBytes = searchAfter == null ? null : new BytesRef(InetAddressPoint.encode((InetAddress)InetAddress.getByName(searchAfter)));
            CompiledAutomaton prefixAutomaton = IpPrefixAutomatonUtil.buildIpPrefixAutomaton(prefix);
            if (prefixAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                Object result = terms.iterator();
                if (searchAfter != null) {
                    result = new SearchAfterTermsEnum((TermsEnum)result, searchBytes);
                }
                return result;
            }
            return terms.intersect(prefixAutomaton, searchBytes);
        }
    }
}

