/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

public final class BinaryDocValuesSyntheticFieldLoaderLayer
implements CompositeSyntheticFieldLoader.DocValuesLayer {
    private final String fieldName;
    private final ByteArrayStreamInput stream;
    private int valueCount;

    public BinaryDocValuesSyntheticFieldLoaderLayer(String fieldName) {
        this.fieldName = fieldName;
        this.stream = new ByteArrayStreamInput();
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        BinaryDocValues docValues = leafReader.getBinaryDocValues(this.fieldName);
        if (docValues == null) {
            this.valueCount = 0;
            return null;
        }
        return docId -> {
            if (!docValues.advanceExact(docId)) {
                this.valueCount = 0;
                return false;
            }
            BytesRef docValuesBytes = docValues.binaryValue();
            this.stream.reset(docValuesBytes.bytes, docValuesBytes.offset, docValuesBytes.length);
            this.valueCount = this.stream.readVInt();
            return this.hasValue();
        };
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        for (int i = 0; i < this.valueCount; ++i) {
            BytesRef valueBytes = this.stream.readBytesRef();
            b.value(valueBytes.utf8ToString());
        }
    }

    @Override
    public boolean hasValue() {
        return this.valueCount > 0;
    }

    @Override
    public long valueCount() {
        return this.valueCount;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }
}

