/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.IndexBalanceConstraintSettings;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;

public class IndexBalanceAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(IndexBalanceAllocationDecider.class);
    private static final String EMPTY = "";
    public static final String NAME = "index_balance";
    private final IndexBalanceConstraintSettings indexBalanceConstraintSettings;
    private final boolean isStateless;
    private volatile DiscoveryNodeFilters clusterRequireFilters;
    private volatile DiscoveryNodeFilters clusterIncludeFilters;
    private volatile DiscoveryNodeFilters clusterExcludeFilters;

    public IndexBalanceAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.indexBalanceConstraintSettings = new IndexBalanceConstraintSettings(clusterSettings);
        this.setClusterRequireFilters(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(settings));
        this.setClusterExcludeFilters(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(settings));
        this.setClusterIncludeFilters(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(settings));
        clusterSettings.addAffixMapUpdateConsumer(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP_SETTING, this::setClusterRequireFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING, this::setClusterExcludeFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP_SETTING, this::setClusterIncludeFilters, (a, b) -> {});
        this.isStateless = DiscoveryNode.isStateless(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (!this.indexBalanceConstraintSettings.isDeciderEnabled() || !this.isStateless || this.hasFilters()) {
            return allocation.decision(Decision.YES, NAME, "Decider is disabled.", new Object[0]);
        }
        Index index = shardRouting.index();
        if (!node.hasIndex(index)) {
            return allocation.decision(Decision.YES, NAME, "Node does not currently host this index.", new Object[0]);
        }
        assert (node.node() != null);
        assert (node.node().getRoles().contains(DiscoveryNodeRole.INDEX_ROLE) || node.node().getRoles().contains(DiscoveryNodeRole.SEARCH_ROLE));
        if (node.node().getRoles().contains(DiscoveryNodeRole.INDEX_ROLE) && !shardRouting.primary()) {
            return allocation.decision(Decision.YES, NAME, "An index node cannot own search shards. Decider inactive.", new Object[0]);
        }
        if (node.node().getRoles().contains(DiscoveryNodeRole.SEARCH_ROLE) && shardRouting.primary()) {
            return allocation.decision(Decision.YES, NAME, "A search node cannot own primary shards. Decider inactive.", new Object[0]);
        }
        ProjectId projectId = allocation.getClusterState().metadata().projectFor(index).id();
        HashSet<DiscoveryNode> eligibleNodes = new HashSet<DiscoveryNode>();
        int totalShards = 0;
        String nomenclature = EMPTY;
        if (node.node().getRoles().contains(DiscoveryNodeRole.INDEX_ROLE)) {
            this.collectEligibleNodes(allocation, eligibleNodes, DiscoveryNodeRole.INDEX_ROLE);
            totalShards = allocation.getClusterState().routingTable(projectId).index(index).size();
            nomenclature = "index";
        } else if (node.node().getRoles().contains(DiscoveryNodeRole.SEARCH_ROLE)) {
            this.collectEligibleNodes(allocation, eligibleNodes, DiscoveryNodeRole.SEARCH_ROLE);
            IndexMetadata indexMetadata = allocation.getClusterState().metadata().getProject(projectId).index(index);
            totalShards = indexMetadata.getNumberOfShards() * indexMetadata.getNumberOfReplicas();
            nomenclature = "search";
        }
        assert (!eligibleNodes.isEmpty());
        if (eligibleNodes.isEmpty()) {
            return allocation.decision(Decision.YES, NAME, "There are no eligible nodes available.", new Object[0]);
        }
        assert (totalShards > 0);
        double idealAllocation = Math.ceil((double)totalShards / (double)eligibleNodes.size());
        int threshold = Math.ceilDiv(totalShards + this.indexBalanceConstraintSettings.getExcessShards(), eligibleNodes.size());
        int currentAllocation = node.numberOfOwningShardsForIndex(index);
        if (currentAllocation >= threshold) {
            String explanation = Strings.format((String)"There are [%d] eligible nodes in the [%s] tier for assignment of [%d] shards in index [%s]. Ideally no more than [%.0f] shard would be assigned per node (the index balance excess shards setting is [%d]). This node is already assigned [%d] shards of the index.", (Object[])new Object[]{eligibleNodes.size(), nomenclature, totalShards, index, idealAllocation, this.indexBalanceConstraintSettings.getExcessShards(), currentAllocation});
            logger.trace(explanation);
            return allocation.decision(Decision.NOT_PREFERRED, NAME, explanation, new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, "Node index shard allocation is under the threshold.", new Object[0]);
    }

    private void collectEligibleNodes(RoutingAllocation allocation, Set<DiscoveryNode> eligibleNodes, DiscoveryNodeRole role) {
        for (DiscoveryNode discoveryNode : allocation.nodes()) {
            if (!discoveryNode.getRoles().contains(role) || allocation.metadata().nodeShutdowns().contains(discoveryNode.getId())) continue;
            eligibleNodes.add(discoveryNode);
        }
    }

    private void setClusterRequireFilters(Map<String, List<String>> filters) {
        this.clusterRequireFilters = DiscoveryNodeFilters.trimTier(DiscoveryNodeFilters.buildFromKeyValues(DiscoveryNodeFilters.OpType.AND, filters));
    }

    private void setClusterIncludeFilters(Map<String, List<String>> filters) {
        this.clusterIncludeFilters = DiscoveryNodeFilters.trimTier(DiscoveryNodeFilters.buildFromKeyValues(DiscoveryNodeFilters.OpType.OR, filters));
    }

    private void setClusterExcludeFilters(Map<String, List<String>> filters) {
        this.clusterExcludeFilters = DiscoveryNodeFilters.trimTier(DiscoveryNodeFilters.buildFromKeyValues(DiscoveryNodeFilters.OpType.OR, filters));
    }

    private boolean hasFilters() {
        return this.clusterExcludeFilters != null && this.clusterExcludeFilters.hasFilters() || this.clusterIncludeFilters != null && this.clusterIncludeFilters.hasFilters() || this.clusterRequireFilters != null && this.clusterRequireFilters.hasFilters();
    }
}

