/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexReshardingMetadata;
import org.elasticsearch.cluster.metadata.IndexReshardingState;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class SplitShardCountSummary
implements Writeable {
    public static final SplitShardCountSummary UNSET = new SplitShardCountSummary(0);
    private final int shardCountSummary;

    public static SplitShardCountSummary forIndexing(IndexMetadata indexMetadata, int shardId) {
        return SplitShardCountSummary.getReshardSplitShardCountSummary(indexMetadata, shardId, IndexReshardingState.Split.TargetShardState.HANDOFF);
    }

    public static SplitShardCountSummary forSearch(IndexMetadata indexMetadata, int shardId) {
        return SplitShardCountSummary.getReshardSplitShardCountSummary(indexMetadata, shardId, IndexReshardingState.Split.TargetShardState.SPLIT);
    }

    private static SplitShardCountSummary getReshardSplitShardCountSummary(IndexMetadata indexMetadata, int shardId, IndexReshardingState.Split.TargetShardState minShardState) {
        int numberOfShards = indexMetadata.getNumberOfShards();
        IndexReshardingMetadata reshardingMetadata = indexMetadata.getReshardingMetadata();
        assert (shardId >= 0 && shardId < numberOfShards) : "shardId is out of bounds";
        int shardCount = numberOfShards;
        if (reshardingMetadata != null) {
            if (reshardingMetadata.getSplit().isTargetShard(shardId)) {
                int sourceShardId = reshardingMetadata.getSplit().sourceShard(shardId);
                assert (reshardingMetadata.getSplit().allTargetStatesAtLeast(sourceShardId, minShardState)) : "unexpected target state";
                shardCount = reshardingMetadata.getSplit().shardCountAfter();
            } else if (reshardingMetadata.getSplit().isSourceShard(shardId)) {
                shardCount = reshardingMetadata.getSplit().allTargetStatesAtLeast(shardId, minShardState) ? reshardingMetadata.getSplit().shardCountAfter() : reshardingMetadata.getSplit().shardCountBefore();
            }
        }
        return new SplitShardCountSummary(shardCount);
    }

    public static SplitShardCountSummary fromInt(int payload) {
        return new SplitShardCountSummary(payload);
    }

    public SplitShardCountSummary(StreamInput in) throws IOException {
        this.shardCountSummary = in.readVInt();
    }

    public int asInt() {
        return this.shardCountSummary;
    }

    public boolean isUnset() {
        return this.shardCountSummary == SplitShardCountSummary.UNSET.shardCountSummary;
    }

    SplitShardCountSummary(int shardCountSummary) {
        this.shardCountSummary = shardCountSummary;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardCountSummary);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SplitShardCountSummary otherSummary = (SplitShardCountSummary)other;
        return this.shardCountSummary == otherSummary.shardCountSummary;
    }

    public int hashCode() {
        return Integer.hashCode(this.shardCountSummary);
    }

    public String toString() {
        return "SplitShardCountSummary [shardCountSummary=" + this.shardCountSummary + "]";
    }
}

