/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;

class BulkPrimaryExecutionContext {
    private final BulkShardRequest request;
    private final IndexShard primary;
    private Translog.Location locationToSync = null;
    private int currentIndex = -1;
    private ItemProcessingState currentItemState;
    private DocWriteRequest<?> requestToExecute;
    private BulkItemResponse executionResult;
    private int updateRetryCounter;
    private long noopMappingUpdateRetryForMappingVersion;

    BulkPrimaryExecutionContext(BulkShardRequest request, IndexShard primary) {
        this.request = request;
        this.primary = primary;
        this.advance();
    }

    private int findNextNonAborted(int startIndex) {
        int length = this.request.items().length;
        while (startIndex < length && BulkPrimaryExecutionContext.isAborted(this.request.items()[startIndex].getPrimaryResponse())) {
            ++startIndex;
        }
        return startIndex;
    }

    private static boolean isAborted(BulkItemResponse response) {
        return response != null && response.isFailed() && response.getFailure().isAborted();
    }

    private void advance() {
        assert (this.currentItemState == ItemProcessingState.COMPLETED || this.currentIndex == -1) : "moving to next but current item wasn't completed (state: " + String.valueOf((Object)this.currentItemState) + ")";
        this.currentItemState = ItemProcessingState.INITIAL;
        this.currentIndex = this.findNextNonAborted(this.currentIndex + 1);
        this.updateRetryCounter = 0;
        this.requestToExecute = null;
        this.executionResult = null;
        this.noopMappingUpdateRetryForMappingVersion = -1L;
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
    }

    public DocWriteRequest<?> getCurrent() {
        return this.getCurrentItem().request();
    }

    public BulkShardRequest getBulkShardRequest() {
        return this.request;
    }

    public BulkItemResponse getExecutionResult() {
        assert (this.assertInvariants(ItemProcessingState.EXECUTED));
        return this.executionResult;
    }

    public int getUpdateRetryCounter() {
        return this.updateRetryCounter;
    }

    public boolean requiresWaitingForMappingUpdate() {
        return this.currentItemState == ItemProcessingState.WAIT_FOR_MAPPING_UPDATE;
    }

    public boolean isInitial() {
        return this.currentItemState == ItemProcessingState.INITIAL;
    }

    public boolean hasMoreOperationsToExecute() {
        return this.currentIndex < this.request.items().length;
    }

    public String getConcreteIndex() {
        return this.getCurrentItem().index();
    }

    public Translog.Location getLocationToSync() {
        assert (!this.hasMoreOperationsToExecute());
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
        return this.locationToSync;
    }

    private BulkItemRequest getCurrentItem() {
        return this.request.items()[this.currentIndex];
    }

    public IndexShard getPrimary() {
        return this.primary;
    }

    public void setRequestToExecute(DocWriteRequest<?> writeRequest) {
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
        this.requestToExecute = writeRequest;
        this.currentItemState = ItemProcessingState.TRANSLATED;
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
    }

    public <T extends DocWriteRequest<T>> T getRequestToExecute() {
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
        return (T)this.requestToExecute;
    }

    public void markAsRequiringMappingUpdate() {
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
        this.currentItemState = ItemProcessingState.WAIT_FOR_MAPPING_UPDATE;
        this.requestToExecute = null;
        assert (this.assertInvariants(ItemProcessingState.WAIT_FOR_MAPPING_UPDATE));
    }

    public void resetForUpdateRetry() {
        assert (this.assertInvariants(ItemProcessingState.EXECUTED));
        ++this.updateRetryCounter;
        this.resetForExecutionRetry();
    }

    public void resetForMappingUpdateRetry() {
        assert (this.assertInvariants(ItemProcessingState.WAIT_FOR_MAPPING_UPDATE));
        this.resetForExecutionRetry();
    }

    public void resetForNoopMappingUpdateRetry(long mappingVersion) {
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
        if (this.noopMappingUpdateRetryForMappingVersion == mappingVersion) {
            String message = "On retry, this indexing request resulted in another noop mapping update. Failing the indexing operation to prevent an infinite retry loop.";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
        this.resetForExecutionRetry();
        this.noopMappingUpdateRetryForMappingVersion = mappingVersion;
    }

    private void resetForExecutionRetry() {
        this.currentItemState = ItemProcessingState.INITIAL;
        this.requestToExecute = null;
        this.executionResult = null;
        this.noopMappingUpdateRetryForMappingVersion = -1L;
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
    }

    public void markOperationAsNoOp(DocWriteResponse response) {
        assert (this.assertInvariants(ItemProcessingState.INITIAL));
        this.executionResult = BulkItemResponse.success(this.getCurrentItem().id(), this.getCurrentItem().request().opType(), response);
        this.currentItemState = ItemProcessingState.EXECUTED;
        assert (this.assertInvariants(ItemProcessingState.EXECUTED));
    }

    public void failOnMappingUpdate(Exception cause) {
        assert (this.assertInvariants(ItemProcessingState.WAIT_FOR_MAPPING_UPDATE));
        this.currentItemState = ItemProcessingState.EXECUTED;
        DocWriteRequest<?> docWriteRequest = this.getCurrentItem().request();
        this.executionResult = BulkItemResponse.failure(this.getCurrentItem().id(), docWriteRequest.opType(), new BulkItemResponse.Failure(this.getCurrentItem().index(), docWriteRequest.id(), cause));
        this.markAsCompleted(this.executionResult);
    }

    public void markOperationAsExecuted(Engine.Result result) {
        assert (this.assertInvariants(ItemProcessingState.TRANSLATED));
        BulkItemRequest current = this.getCurrentItem();
        Object docWriteRequest = this.getRequestToExecute();
        switch (result.getResultType()) {
            case SUCCESS: {
                DocWriteResponse response;
                if (result.getOperationType() == Engine.Operation.TYPE.INDEX) {
                    List<String> executedPipelines;
                    Engine.IndexResult indexResult = (Engine.IndexResult)result;
                    if (docWriteRequest instanceof IndexRequest) {
                        IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                        executedPipelines = indexRequest.getExecutedPipelines();
                    } else {
                        executedPipelines = null;
                    }
                    response = new IndexResponse(this.primary.shardId(), indexResult.getId(), result.getSeqNo(), result.getTerm(), indexResult.getVersion(), indexResult.isCreated(), executedPipelines);
                } else if (result.getOperationType() == Engine.Operation.TYPE.DELETE) {
                    Engine.DeleteResult deleteResult = (Engine.DeleteResult)result;
                    response = new DeleteResponse(this.primary.shardId(), this.requestToExecute.id(), deleteResult.getSeqNo(), result.getTerm(), deleteResult.getVersion(), deleteResult.isFound());
                } else {
                    throw new AssertionError((Object)("unknown result type :" + String.valueOf((Object)result.getResultType())));
                }
                this.executionResult = BulkItemResponse.success(current.id(), current.request().opType(), response);
                ((ReplicationResponse)this.executionResult.getResponse()).setShardInfo(ReplicationResponse.ShardInfo.EMPTY);
                this.locationToSync = TransportWriteAction.locationToSync(this.locationToSync, result.getTranslogLocation());
                break;
            }
            case FAILURE: {
                String index = this.request.index();
                this.executionResult = BulkItemResponse.failure(current.id(), docWriteRequest.opType(), new BulkItemResponse.Failure(index, result.getId(), result.getFailure(), result.getSeqNo(), result.getTerm()));
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown result type for " + String.valueOf(this.getCurrentItem()) + ": " + String.valueOf((Object)result.getResultType())));
            }
        }
        this.currentItemState = ItemProcessingState.EXECUTED;
    }

    public void markAsCompleted(BulkItemResponse translatedResponse) {
        assert (this.assertInvariants(ItemProcessingState.EXECUTED));
        assert (this.executionResult != null && translatedResponse.getItemId() == this.executionResult.getItemId());
        assert (translatedResponse.getItemId() == this.getCurrentItem().id());
        if (!translatedResponse.isFailed() && this.requestToExecute != null && this.requestToExecute != this.getCurrent()) {
            this.request.items()[this.currentIndex] = new BulkItemRequest(this.request.items()[this.currentIndex].id(), this.requestToExecute);
        }
        this.getCurrentItem().setPrimaryResponse(translatedResponse);
        this.currentItemState = ItemProcessingState.COMPLETED;
        this.advance();
    }

    public BulkShardResponse buildShardResponse() {
        assert (!this.hasMoreOperationsToExecute());
        return new BulkShardResponse(this.request.shardId(), (BulkItemResponse[])Arrays.stream(this.request.items()).map(BulkItemRequest::getPrimaryResponse).toArray(BulkItemResponse[]::new));
    }

    private boolean assertInvariants(ItemProcessingState ... expectedCurrentState) {
        assert (Arrays.asList(expectedCurrentState).contains((Object)this.currentItemState)) : "expected current state [" + String.valueOf((Object)this.currentItemState) + "] to be one of " + Arrays.toString((Object[])expectedCurrentState);
        assert (this.currentIndex >= 0) : this.currentIndex;
        assert (this.updateRetryCounter >= 0) : this.updateRetryCounter;
        switch (this.currentItemState.ordinal()) {
            case 0: {
                assert (this.requestToExecute == null) : this.requestToExecute;
                assert (this.executionResult == null) : this.executionResult;
                break;
            }
            case 1: {
                assert (this.requestToExecute != null);
                assert (this.executionResult == null) : this.executionResult;
                break;
            }
            case 2: {
                assert (this.requestToExecute == null);
                assert (this.executionResult == null) : this.executionResult;
                break;
            }
            case 3: {
                assert (this.executionResult != null);
                break;
            }
            case 4: {
                assert (this.requestToExecute != null);
                assert (this.executionResult != null);
                assert (this.getCurrentItem().getPrimaryResponse() != null);
                break;
            }
        }
        return true;
    }

    static enum ItemProcessingState {
        INITIAL,
        TRANSLATED,
        WAIT_FOR_MAPPING_UPDATE,
        EXECUTED,
        COMPLETED;

    }
}

