/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetSampleConfigurationAction
extends ActionType<Response> {
    public static final GetSampleConfigurationAction INSTANCE = new GetSampleConfigurationAction();
    public static final String NAME = "indices:monitor/sample/config/get";

    private GetSampleConfigurationAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final String index;
        private final SamplingConfiguration configuration;

        public Response(String index, SamplingConfiguration configuration) {
            this.index = index;
            this.configuration = configuration;
        }

        public Response(StreamInput in) throws IOException {
            this.index = in.readString();
            this.configuration = in.readOptionalWriteable(SamplingConfiguration::new);
        }

        public String getIndex() {
            return this.index;
        }

        public SamplingConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeOptionalWriteable(this.configuration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.index, response.index) && Objects.equals(this.configuration, response.configuration);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.configuration);
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Collections.singletonList((builder, p) -> this.toXContent(builder, params)).iterator();
        }

        private XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("index", this.index);
            if (this.configuration != null) {
                builder.field("configuration", (ToXContent)this.configuration);
            } else {
                builder.nullField("configuration");
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends LocalClusterStateRequest
    implements IndicesRequest.Replaceable {
        private String index;

        public Request(@Nullable TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
        }

        public String getIndex() {
            return this.index;
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.index = indices[0];
            return this;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty(this.index)) {
                validationException = ValidateActions.addValidationError("index name is required", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.index, request.index);
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "executing " + action, parentTaskId, headers);
        }
    }
}

