/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.selector;

import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.PlaceholderRelation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Evaluation;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatchers;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Selector;

public class LiteralSelector
extends Selector {
    private final Literal literal;

    public LiteralSelector(Source source, Literal literal) {
        this(source, PlaceholderRelation.INSTANCE, literal);
    }

    public LiteralSelector(Source source, LogicalPlan child, Literal literal) {
        super(source, child, (Expression)literal, Collections.emptyList(), LabelMatchers.EMPTY, Evaluation.NONE);
        this.literal = literal;
    }

    public Literal literal() {
        return this.literal;
    }

    protected NodeInfo<LiteralSelector> info() {
        return NodeInfo.create((Node)this, LiteralSelector::new, (Object)((Object)this.child()), (Object)this.literal);
    }

    @Override
    public LiteralSelector replaceChild(LogicalPlan newChild) {
        return new LiteralSelector(this.source(), newChild, this.literal);
    }

    public String telemetryLabel() {
        return "PROMQL_SELECTOR_LITERAL";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LiteralSelector that = (LiteralSelector)((Object)o);
        return Objects.equals(this.literal, that.literal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.literal);
    }
}

